/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import javax.baja.history.BCapacity;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"history:Capacity"})})
@NiagaraAction(name="updateState", flags=4)
public class BCapacityFE
extends BWbFieldEditor {
    @Generated
    public static final Action updateState = BCapacityFE.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCapacityFE.class);
    private static final Lexicon lex = Lexicon.make((String)"history");
    private static final int UNLIMITED = 0;
    private static final int BY_RECORD_COUNT = 1;
    private static final int BY_STORAGE_SIZE = 2;
    private BListDropDown typeChoice = new BListDropDown();
    private BWbFieldEditor maxField;
    private BLabel unitLabel;
    private String recordsText;
    private int typeIndex = 0;
    private int lastRecords = 500;
    private int lastKb = 5;

    @Generated
    public void updateState() {
        this.invoke(updateState, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCapacityFE() {
        this.typeChoice.getList().addItem((Object)lex.getText("unlimited"));
        this.typeChoice.getList().addItem((Object)lex.getText("recordCount"));
        this.maxField = BWbFieldEditor.makeFor((BObject)BInteger.DEFAULT);
        this.maxField.loadValue((BObject)BInteger.make((int)this.lastRecords), (Context)BCapacity.recordCountFacets);
        this.unitLabel = new BLabel(lex.getText("records"));
        BGridPane outer = new BGridPane(3);
        outer.add("typeChoice", (BValue)this.typeChoice);
        outer.add("maxField", (BValue)this.maxField);
        outer.add("unitLabel", (BValue)this.unitLabel);
        this.setContent((BWidget)outer);
        this.add("typeModified", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BDropDown.valueModified, (Slot)setModified));
        this.add("typeUpdate", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BDropDown.valueModified, (Slot)updateState));
        this.add("maxModified", (BValue)new BLink((BComponent)this.maxField, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified));
        this.add("maxAction", (BValue)new BLink((BComponent)this.maxField, (Slot)BWbFieldEditor.actionPerformed, (Slot)actionPerformed));
    }

    protected void doLoadValue(BObject value, Context cx) {
        BCapacity c = (BCapacity)value;
        if (c.isUnlimited() || c.isByStorageSize()) {
            this.typeChoice.setSelectedIndex(0);
            this.typeIndex = 0;
        } else if (c.isByRecordCount()) {
            this.typeChoice.setSelectedIndex(1);
            this.typeIndex = 1;
            this.maxField.loadValue((BObject)BInteger.make((int)c.getMaxRecords()), (Context)BCapacity.recordCountFacets);
            this.lastRecords = c.getMaxRecords();
        } else if (c.isByStorageSize()) {
            this.typeChoice.setSelectedIndex(2);
            this.typeIndex = 2;
            this.maxField.loadValue((BObject)BInteger.make((int)((int)c.getMaxStorage())), (Context)BCapacity.recordCountFacets);
            this.lastKb = (int)c.getMaxStorage();
        }
        this.updateState();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        int typeIndex = this.typeChoice.getSelectedIndex();
        if (typeIndex == 0) {
            return BCapacity.UNLIMITED;
        }
        if (typeIndex == 1) {
            return BCapacity.makeByRecordCount((int)((BInteger)this.maxField.saveValue()).getInt());
        }
        return BCapacity.makeByStorageSize((long)((BInteger)this.maxField.saveValue()).getInt());
    }

    public void doUpdateState() {
        int newTypeIndex = this.typeChoice.getList().getSelectedIndex();
        try {
            if (this.typeIndex == 1) {
                this.lastRecords = ((BInteger)this.maxField.saveValue()).getInt();
            } else if (this.typeIndex == 2) {
                this.lastKb = ((BInteger)this.maxField.saveValue()).getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newTypeIndex == 0) {
            this.maxField.setVisible(false);
            this.unitLabel.setVisible(false);
        } else if (newTypeIndex == 1) {
            this.maxField.loadValue((BObject)BInteger.make((int)this.lastRecords), (Context)BCapacity.recordCountFacets);
            this.maxField.setVisible(true);
            this.unitLabel.setText(lex.getText("records"));
            this.unitLabel.setVisible(true);
        } else if (newTypeIndex == 2) {
            this.maxField.loadValue((BObject)BInteger.make((int)this.lastKb), (Context)BCapacity.recordCountFacets);
            this.maxField.setVisible(true);
            this.unitLabel.setText("KB");
            this.unitLabel.setVisible(true);
        }
        this.typeIndex = newTypeIndex;
        this.getContent().relayout();
    }

    public void doSetReadonly(boolean readOnly) {
        this.typeChoice.setEnabled(!readOnly);
        this.maxField.setReadonly(readOnly);
    }
}

