/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.ui.BHistoryTable;
import com.tridium.history.util.HistoryUtil;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.PdfUtil;
import java.util.logging.Level;
import javax.baja.gx.BFont;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"history:HistoryTable"})})
public class BPdfHistoryTable
extends BPdfFlowPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BPdfHistoryTable.class);
    private static final Lexicon pdfLex = Lexicon.make((String)"pdf");
    static final LexiconText DELTA_MODE = LexiconText.make((String)"history", (String)"historyExport.deltaMode");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void fromWidget(BWidget widget, PdfOp op) {
        BDynamicTimeRange historyRange;
        if (!(widget instanceof BHistoryTable)) {
            return;
        }
        BHistoryTable history = (BHistoryTable)widget;
        try {
            historyRange = history.getRange();
        }
        catch (Exception e) {
            PdfUtil.log.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        BLabel name = new BLabel("history:" + history.getHistory().getNavDisplayName((Context)new BasicContext((Context)op, BHistory.FULL_DISPLAY_NAME_CX.getFacets())));
        BLabel range = new BLabel(HistoryUtil.getRangeStr((BDynamicTimeRange)historyRange, (Context)op));
        BLabel delta = null;
        if (history.isDelta()) {
            delta = new BLabel(DELTA_MODE.getText((Context)op));
            delta.setHalign(BHalign.left);
        }
        name.setFont(BFont.make((String)pdfLex.getText("pdf.propertySheetToPdf.font")));
        name.setHalign(BHalign.left);
        range.setHalign(BHalign.left);
        BTable table = new BTable((TableModel)new Model(history.getTableModel()));
        this.add(null, (BValue)name);
        this.add(null, (BValue)range);
        if (delta != null) {
            this.add(null, (BValue)delta);
        }
        this.add(null, (BValue)new BLabel(""));
        this.add(null, (BValue)table);
        this.setupPane();
    }

    static class Model
    extends TableModel {
        TableModel orig;

        Model(TableModel orig) {
            this.orig = orig;
        }

        public int getColumnCount() {
            return this.orig.getColumnCount();
        }

        public int getRowCount() {
            return this.orig.getRowCount();
        }

        public String getColumnName(int col) {
            return this.orig.getColumnName(col);
        }

        public Object getValueAt(int row, int col) {
            return this.orig.getValueAt(row, col);
        }
    }
}

