/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.nav;

import com.tridium.history.BHistoryFolder;
import com.tridium.history.nav.BFilteredHistoryDevice;
import com.tridium.history.nav.BFilteredHistoryFolder;
import com.tridium.history.nav.BFilteredHistoryNavNode;
import java.util.ArrayList;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistorySpace;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"history:HistorySpace"})})
public class BFilteredHistorySpace
extends BFilteredHistoryNavNode {
    @Generated
    public static final Type TYPE = Sys.loadType(BFilteredHistorySpace.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFilteredHistorySpace() {
    }

    public BFilteredHistorySpace(BHistorySpace historySpace) {
        this(historySpace, null, null);
    }

    public BFilteredHistorySpace(BHistorySpace historySpace, IFilter deviceFilter, IFilter historyFilter) {
        this.historyNavNode = historySpace;
        this.deviceFilter = deviceFilter;
        this.historyFilter = historyFilter;
    }

    public BFilteredHistorySpace(BHistorySpace historySpace, IFilter deviceFilter, IFilter historyFilter, IFilter folderFilter) {
        this(historySpace, deviceFilter, historyFilter);
        this.folderFilter = folderFilter;
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String name) {
        BINavNode node = this.historyNavNode.getNavChild(name);
        if (node instanceof BHistoryDevice) {
            return new BFilteredHistoryDevice((BHistoryDevice)node, this.historyFilter);
        }
        if (node instanceof BHistoryFolder) {
            return new BFilteredHistoryFolder((BHistoryFolder)node, this.historyFilter, this.folderFilter);
        }
        return null;
    }

    @Override
    public BINavNode resolveNavChild(String name) {
        BINavNode node = this.historyNavNode.resolveNavChild(name);
        if (node instanceof BHistoryDevice) {
            return new BFilteredHistoryDevice((BHistoryDevice)node, this.historyFilter);
        }
        if (node instanceof BHistoryFolder) {
            return new BFilteredHistoryFolder((BHistoryFolder)node, this.historyFilter, this.folderFilter);
        }
        return null;
    }

    @Override
    public BINavNode[] getNavChildren() {
        BINavNode[] children = this.historyNavNode.getNavChildren();
        if (children.length == 0) {
            return children;
        }
        ArrayList<BFilteredHistoryNavNode> result = new ArrayList<BFilteredHistoryNavNode>();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof BHistoryDevice) {
                if (this.deviceFilter != null && !this.deviceFilter.accept((Object)children[i])) continue;
                result.add(new BFilteredHistoryDevice((BHistoryDevice)children[i], this.historyFilter));
                continue;
            }
            if (!(children[i] instanceof BHistoryFolder) || this.folderFilter != null && !this.folderFilter.accept((Object)children[i])) continue;
            result.add(new BFilteredHistoryFolder((BHistoryFolder)children[i], this.historyFilter, this.folderFilter));
        }
        return result.toArray(new BINavNode[0]);
    }
}

