/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.propMigration.converters;

import java.util.ArrayList;
import java.util.List;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BPropNameChangeConverter
extends BObject
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BPropNameChangeConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typespecName, Version sourceVersion) {
        log.finer("Migrate a PropNameChange! typespecName=" + typespecName + ", xelem=" + x);
        XElem[] props = x.elems("p");
        String xnam = x.get("n");
        for (XElem p : props) {
            String n = p.get("n", "-");
            if (n.equals("oldBoolProp")) {
                log.info("Changing name of " + xnam + ":oldBoolProp to newBoolProp");
                p.setAttr("n", "newBoolProp");
                continue;
            }
            if (!n.equals("valOld")) continue;
            log.info("Changing name of " + xnam + ":valOld to valNew");
            p.setAttr("n", "valNew");
        }
        log.finer("migrated: new x is " + x);
        return x;
    }

    public BValue newInstance(String moduleName, String typeName) {
        log.finest("PropNameChangeConverter.newInstance is stubbed!");
        return (BValue)BTypeSpec.make((String)(moduleName + ":" + typeName)).getInstance();
    }

    public BOrd fixOrd(BOrd originalOrd) {
        String newS;
        String ordS = originalOrd.toString(null);
        if (ordS.contains("oldBoolProp")) {
            newS = ordS.replace("oldBoolProp", "newBoolProp");
        } else if (ordS.contains("valOld")) {
            newS = ordS.replace("valOld", "valNew");
        } else if (ordS.contains("oldAction")) {
            newS = ordS.replace("oldAction", "newAction");
        } else if (ordS.contains("oldTopic")) {
            newS = ordS.replace("oldTopic", "newTopic");
        } else {
            return null;
        }
        return BOrd.make((String)newS);
    }

    static {
        convertTypes.add("propMigration:PropNameChange");
        convertTypes.add("propMigration:OrdProps");
    }
}

