/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.propMigration.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BNumPropNameChangeConverter
extends BObject
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BNumPropNameChangeConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typespecName, Version sourceVersion) {
        XElem[] props;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Migrate a NumPropNameChange! typespecName=" + typespecName + ", xelem=" + x);
        }
        for (XElem p : props = x.elems("p")) {
            String name = p.get("n", "-");
            if (!name.equals("oldNumProp")) continue;
            log.info("Changing name of property " + name + " to newNumProp in bog element " + x);
            p.setAttr("n", "newNumProp");
        }
        log.finer("migrated: new x is " + x);
        return x;
    }

    public BValue newInstance(String moduleName, String typeName) {
        log.finest("NumPropNameChangeConverter.newInstance is stubbed!");
        return (BValue)BTypeSpec.make((String)(moduleName + ":" + typeName)).getInstance();
    }

    static {
        convertTypes.add("propMigration:NumPropNameChange");
    }
}

