/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmOrion;

import com.tridium.alarm.AlarmsToSourcesCursor;
import com.tridium.alarmOrion.OrionAlarmCursor;
import com.tridium.alarmOrion.transactions.AppendAlarmRecord;
import com.tridium.alarmOrion.transactions.ClearAlarmRecord;
import com.tridium.alarmOrion.transactions.UpdateAlarmRecord;
import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.SelectQuery;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BExtentProjection;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.SqlColumns;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmFacetName;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.BOrionAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.bql.BqlQuery;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataUtil;
import javax.baja.naming.BOrdList;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.util.Columns;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDate;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class OrionAlarmDbConnection
extends AlarmDbConnection {
    private BOrionAlarmDatabase db;
    private OrionSession session;

    public OrionAlarmDbConnection(BOrionAlarmDatabase db, OrionSession session) {
        this.db = db;
        this.session = session;
    }

    public BAlarmDatabase getAlarmDatabase() {
        return this.db;
    }

    public OrionSession getOrionSession() {
        return this.session;
    }

    public void flush() {
    }

    public void close() {
        if (this.session.isOpen()) {
            if (!this.session.getAutoCommit()) {
                this.session.commit();
            }
            this.session.close();
        }
    }

    public void append(BAlarmRecord alarmRecord) throws IOException, AlarmException {
        if (BOrionAlarmDatabase.log.isLoggable(Level.FINE)) {
            BOrionAlarmDatabase.log.fine("Appending record " + alarmRecord.getUuid());
        }
        if (!this.db.isOpen()) {
            throw new AlarmException("Unable to append, database unavailable.");
        }
        if (alarmRecord.getSource().size() == 0) {
            throw new AlarmException("Alarm must have a source " + alarmRecord.getUuid());
        }
        new AppendAlarmRecord(alarmRecord, this.db).run();
    }

    public void update(BAlarmRecord alarmRecord) throws IOException, AlarmException {
        if (BOrionAlarmDatabase.log.isLoggable(Level.FINE)) {
            BOrionAlarmDatabase.log.fine("Updating record " + alarmRecord.getUuid());
        }
        if (!this.db.isOpen()) {
            throw new AlarmException("Unable to update, database unavailable.");
        }
        if (alarmRecord.getSource().size() == 0) {
            throw new AlarmException("Alarm must have a source " + alarmRecord.getUuid());
        }
        new UpdateAlarmRecord(alarmRecord, this.db).run();
    }

    public int getRecordCount() {
        BSqlQuery countQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BFieldExpression expression = Exprs.field((Property)BOrionAlarmRecord.id);
        countQuery.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((BExpression)expression.newExprCopy())).as("recordCount")));
        int count = -1;
        try (OrionCursor cursor = this.session.select((BQuery)countQuery);){
            if (cursor.next()) {
                BDynamicOrionObject temp = (BDynamicOrionObject)cursor.get();
                count = ((BInteger)temp.get("recordCount")).getInt();
            }
        }
        return count;
    }

    public int getOpenRecordCount(BOrdList alarmSource) {
        BSqlExtent alarmExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        BSqlQuery countQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BExpression expression = this.getOpenAlarmsForSourceExpression(alarmSource, alarmExt, countQuery);
        countQuery.where(expression);
        countQuery.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((BExpression)expression.newExprCopy())).as("openCount")));
        int count = -1;
        try (OrionCursor cursor = this.session.select((BQuery)countQuery);){
            if (cursor.next()) {
                BDynamicOrionObject temp = (BDynamicOrionObject)cursor.get();
                count = ((BInteger)temp.get("openCount")).getInt();
            }
        }
        return count;
    }

    public int getOpenAckPendingRecordCount(BOrdList alarmSource) {
        BSqlExtent alarmExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        BSqlQuery countQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BExpression expression = null;
        for (int i = 0; i < alarmSource.size(); ++i) {
            BSqlExtent sourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE).alias("sourceOrder" + i);
            BSqlExtent sourceExt = new BSqlExtent(BOrionAlarmSource.ORION_TYPE).alias("alarmSource" + i);
            countQuery.join(new BSqlJoin(new BSqlField(alarmExt, BOrionAlarmRecord.id), new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm)));
            countQuery.join(new BSqlJoin(new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarmSource), new BSqlField(sourceExt, BOrionAlarmSource.id)));
            BExpression joinExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.sourceOrder), (BSimple)BInteger.make((int)i))).and(Predicates.eq((BExpression)new BSqlField(sourceExt, BOrionAlarmSource.source), (BSimple)alarmSource.get(i))).getExpression();
            BExpression ackPendExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.ackState), (BSimple)BAckState.ackPending)).and(Predicates.eq((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.isOpen), (BSimple)BBoolean.TRUE)).getExpression();
            BExpression orExpression = Exprs.builder((BExpression)ackPendExpression).getExpression();
            BExpression andExpression = Exprs.builder((BExpression)joinExpression).and(orExpression).getExpression();
            expression = expression == null ? andExpression : Exprs.builder((BExpression)expression).and(andExpression).getExpression();
        }
        countQuery.where(expression);
        countQuery.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((BExpression)expression.newExprCopy())).as("openAckCount")));
        int count = -1;
        try (OrionCursor cursor = this.session.select((BQuery)countQuery);){
            if (cursor.next()) {
                BDynamicOrionObject temp = (BDynamicOrionObject)cursor.get();
                count = ((BInteger)temp.get("openAckCount")).getInt();
            }
        }
        return count;
    }

    public int getOpenUnackedRecordCount(BOrdList alarmSource) {
        BSqlExtent alarmExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        BSqlQuery countQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BExpression expression = null;
        for (int i = 0; i < alarmSource.size(); ++i) {
            BSqlExtent sourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE).alias("sourceOrder" + i);
            BSqlExtent sourceExt = new BSqlExtent(BOrionAlarmSource.ORION_TYPE).alias("alarmSource" + i);
            countQuery.join(new BSqlJoin(new BSqlField(alarmExt, BOrionAlarmRecord.id), new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm)));
            countQuery.join(new BSqlJoin(new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarmSource), new BSqlField(sourceExt, BOrionAlarmSource.id)));
            BExpression joinExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.sourceOrder), (BSimple)BInteger.make((int)i))).and(Predicates.eq((BExpression)new BSqlField(sourceExt, BOrionAlarmSource.source), (BSimple)alarmSource.get(i))).getExpression();
            BExpression openUnackedExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.ackState), (BSimple)BAckState.unacked)).and(Predicates.eq((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.isOpen), (BSimple)BBoolean.TRUE)).getExpression();
            BExpression orExpression = Exprs.builder((BExpression)openUnackedExpression).getExpression();
            BExpression andExpression = Exprs.builder((BExpression)joinExpression).and(orExpression).getExpression();
            expression = expression == null ? andExpression : Exprs.builder((BExpression)expression).and(andExpression).getExpression();
        }
        countQuery.where(expression);
        countQuery.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((BExpression)expression.newExprCopy())).as("unackCount")));
        int count = -1;
        try (OrionCursor cursor = this.session.select((BQuery)countQuery);){
            if (cursor.next()) {
                BDynamicOrionObject temp = (BDynamicOrionObject)cursor.get();
                count = ((BInteger)temp.get("unackCount")).getInt();
            }
        }
        return count;
    }

    public int getOpenAckedRecordCount(BOrdList alarmSource) {
        BSqlExtent alarmExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        BSqlQuery countQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BExpression expression = null;
        for (int i = 0; i < alarmSource.size(); ++i) {
            BSqlExtent sourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE).alias("sourceOrder" + i);
            BSqlExtent sourceExt = new BSqlExtent(BOrionAlarmSource.ORION_TYPE).alias("alarmSource" + i);
            countQuery.join(new BSqlJoin(new BSqlField(alarmExt, BOrionAlarmRecord.id), new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm)));
            countQuery.join(new BSqlJoin(new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarmSource), new BSqlField(sourceExt, BOrionAlarmSource.id)));
            BExpression joinExpression1 = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.sourceOrder), (BSimple)BInteger.make((int)i))).and(Predicates.eq((BExpression)new BSqlField(sourceExt, BOrionAlarmSource.source), (BSimple)alarmSource.get(i))).getExpression();
            BExpression openAckedExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.ackState), (BSimple)BAckState.acked)).and(Predicates.eq((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.isOpen), (BSimple)BBoolean.TRUE)).getExpression();
            BExpression andExpression = Exprs.builder((BExpression)joinExpression1).and(openAckedExpression).getExpression();
            expression = expression == null ? andExpression : Exprs.builder((BExpression)expression).and(andExpression).getExpression();
        }
        countQuery.where(expression);
        countQuery.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((BExpression)expression.newExprCopy())).as("ackCount")));
        int count = -1;
        try (OrionCursor cursor = this.session.select((BQuery)countQuery);){
            if (cursor.next()) {
                BDynamicOrionObject temp = (BDynamicOrionObject)cursor.get();
                count = ((BInteger)temp.get("ackCount")).getInt();
            }
        }
        return count;
    }

    public BAlarmRecord getRecord(BUuid uuid) {
        return this.getRecord(uuid, this.session);
    }

    public BAlarmRecord getRecord(BUuid uuid, OrionSession session) {
        BOrionAlarmRecord record = this.getOrionRecord(uuid, session);
        if (record != null) {
            return record.getAlarmRecord(session);
        }
        return null;
    }

    public BOrionAlarmRecord getOrionRecord(BUuid uuid) {
        return this.getOrionRecord(uuid, this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionAlarmRecord getOrionRecord(BUuid uuid, OrionSession session) {
        try (OrionCursor cursor = session.select(BOrionAlarmRecord.ORION_TYPE, new PropertyValue[]{new PropertyValue(BOrionAlarmRecord.uuidHash, (BValue)BInteger.make((int)uuid.hashCode())), new PropertyValue(BOrionAlarmRecord.uuid, (BValue)uuid)});){
            if (cursor.next()) {
                BOrionAlarmRecord bOrionAlarmRecord = (BOrionAlarmRecord)((Object)cursor.get());
                return bOrionAlarmRecord;
            }
            BOrionAlarmRecord bOrionAlarmRecord = null;
            return bOrionAlarmRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BAlarmRecord> getOpenAlarms() throws IOException {
        BSqlQuery queryRecords = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        queryRecords.where(Exprs.builder((BExpression)Predicates.eq((Property)BOrionAlarmRecord.isOpen, (BSimple)BBoolean.TRUE)));
        BOrdering ordering = new BOrdering();
        ordering.add(Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmRecord.id)).asc());
        queryRecords.orderBy(ordering);
        BSqlQuery queryFacets = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent facetValueExt = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent alarmRecordExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        queryFacets.join(new BSqlJoin(new BSqlField(facetValueExt, BOrionAlarmFacetValue.alarm), new BSqlField(alarmRecordExt, BOrionAlarmRecord.id)));
        queryFacets.where(Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(alarmRecordExt, BOrionAlarmRecord.isOpen), (BSimple)BBoolean.TRUE)));
        BOrdering ordering2 = new BOrdering();
        ordering2.add(Columns.orderBy((BExpression)new BSqlField(facetValueExt, BOrionAlarmFacetValue.alarm)).asc());
        queryFacets.orderBy(ordering2);
        BSqlQuery querySources = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlExtent sourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlExtent alarmRecordExt2 = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        querySources.join(new BSqlJoin(new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm), new BSqlField(alarmRecordExt2, BOrionAlarmRecord.id)));
        querySources.where(Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(alarmRecordExt2, BOrionAlarmRecord.isOpen), (BSimple)BBoolean.TRUE)));
        BOrdering ordering3 = new BOrdering();
        ordering3.add(Columns.orderBy((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm)).asc());
        ordering3.add(Columns.orderBy((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.sourceOrder)));
        querySources.orderBy(ordering3);
        Object object = this.db.exclusiveAccessMutex;
        synchronized (object) {
            OrionCursor records = this.session.select((BQuery)queryRecords);
            OrionCursor facets = this.session.select((BQuery)queryFacets);
            OrionCursor sources = this.session.select((BQuery)querySources);
            return new OrionAlarmCursor(records, facets, sources, this.session, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BAlarmRecord> getAckPendingAlarms() throws IOException {
        BSqlQuery queryRecords = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        queryRecords.where(Predicates.eq((Property)BOrionAlarmRecord.ackState, (BSimple)BAckState.ackPending));
        BOrdering ordering = new BOrdering();
        ordering.add(Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmRecord.id)).asc());
        queryRecords.orderBy(ordering);
        BSqlQuery queryFacets = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent facetValueExt = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent alarmRecordExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        queryFacets.where(Predicates.eq((Property)BOrionAlarmRecord.ackState, (BSimple)BAckState.ackPending));
        queryFacets.join(new BSqlJoin(new BSqlField(facetValueExt, BOrionAlarmFacetValue.alarm), new BSqlField(alarmRecordExt, BOrionAlarmRecord.id)));
        BOrdering ordering2 = new BOrdering();
        ordering2.add(Columns.orderBy((BExpression)new BSqlField(alarmRecordExt, BOrionAlarmRecord.id)).asc());
        queryFacets.orderBy(ordering2);
        BSqlQuery querySources = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlExtent sourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlExtent alarmRecordExt2 = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        querySources.where(Predicates.eq((Property)BOrionAlarmRecord.ackState, (BSimple)BAckState.ackPending));
        querySources.join(new BSqlJoin(new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm), new BSqlField(alarmRecordExt2, BOrionAlarmRecord.id)));
        BOrdering ordering3 = new BOrdering();
        ordering3.add(Columns.orderBy((BExpression)new BSqlField(alarmRecordExt2, BOrionAlarmRecord.id)).asc());
        ordering3.add(Columns.orderBy((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.sourceOrder)));
        querySources.orderBy(ordering3);
        Object object = this.db.exclusiveAccessMutex;
        synchronized (object) {
            return new OrionAlarmCursor(this.session.select((BQuery)queryRecords), this.session.select((BQuery)queryFacets), this.session.select((BQuery)querySources), this.session, false);
        }
    }

    public Cursor<BAlarmSource> getOpenAlarmSources() throws IOException {
        Cursor<BAlarmRecord> alarms = this.getOpenAlarms();
        return new AlarmsToSourcesCursor(alarms);
    }

    public Cursor<BAlarmRecord> getAlarmsForSource(BOrdList alarmSource) throws IOException {
        BSqlExtent alarmExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        BSqlQuery query = this.generateAlarmsForSourceQuery(alarmSource, alarmExt);
        query.orderBy(BOrdering.make((BOrderByColumn)Columns.orderBy((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.id)).asc()));
        OrionCursor cursor = this.session.select((BQuery)query);
        return new OrionAlarmCursor(cursor, null, null, this.session, false);
    }

    public Cursor<BAlarmRecord> getOpenAlarmsForSource(BOrdList alarmSource) throws IOException {
        BSqlExtent alarmExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        BSqlQuery query = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BExpression expression = this.getOpenAlarmsForSourceExpression(alarmSource, alarmExt, query);
        query.where(expression);
        query.orderBy(BOrdering.make((BOrderByColumn)Columns.orderBy((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.id)).asc()));
        OrionCursor cursor = this.session.select((BQuery)query);
        return new OrionAlarmCursor(cursor, null, null, this.session, false);
    }

    private BExpression getAlarmsForSourceExpression(BOrdList alarmSource, BSqlExtent alarmExt, BSqlQuery query) {
        BExpression expression = null;
        for (int i = 0; i < alarmSource.size(); ++i) {
            BSqlExtent sourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE).alias("sourceOrder" + i);
            BSqlExtent sourceExt = new BSqlExtent(BOrionAlarmSource.ORION_TYPE).alias("alarmSource" + i);
            query.join(new BSqlJoin(new BSqlField(alarmExt, BOrionAlarmRecord.id), new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm)));
            query.join(new BSqlJoin(new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarmSource), new BSqlField(sourceExt, BOrionAlarmSource.id)));
            BExpression joinExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.sourceOrder), (BSimple)BInteger.make((int)i))).and(Predicates.eq((BExpression)new BSqlField(sourceExt, BOrionAlarmSource.source), (BSimple)alarmSource.get(i))).getExpression();
            expression = expression == null ? joinExpression : Exprs.builder((BExpression)expression).and(joinExpression).getExpression();
        }
        return expression;
    }

    private BSqlQuery generateAlarmsForSourceQuery(BOrdList alarmSource, BSqlExtent alarmExt) {
        BSqlQuery query = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BExpression expression = this.getAlarmsForSourceExpression(alarmSource, alarmExt, query);
        query.where(expression);
        return query;
    }

    private BExpression getOpenAlarmsForSourceExpression(BOrdList alarmSource, BSqlExtent alarmExt, BSqlQuery query) {
        BExpression expression = null;
        for (int i = 0; i < alarmSource.size(); ++i) {
            BSqlExtent sourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE).alias("sourceOrder" + i);
            BSqlExtent sourceExt = new BSqlExtent(BOrionAlarmSource.ORION_TYPE).alias("alarmSource" + i);
            query.join(new BSqlJoin(new BSqlField(alarmExt, BOrionAlarmRecord.id), new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm)));
            query.join(new BSqlJoin(new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarmSource), new BSqlField(sourceExt, BOrionAlarmSource.id)));
            BExpression joinExpression1 = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.sourceOrder), (BSimple)BInteger.make((int)i))).and(Predicates.eq((BExpression)new BSqlField(sourceExt, BOrionAlarmSource.source), (BSimple)alarmSource.get(i))).getExpression();
            BExpression isOpenExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.isOpen), (BSimple)BBoolean.TRUE)).getExpression();
            BExpression andExpression = Exprs.builder((BExpression)joinExpression1).and(isOpenExpression).getExpression();
            expression = expression == null ? andExpression : Exprs.builder((BExpression)expression).and(andExpression).getExpression();
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BAlarmRecord> scan() throws IOException, AlarmException {
        BSqlQuery queryRecords = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BOrdering ordering = new BOrdering();
        ordering.add(Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmRecord.id)));
        queryRecords.orderBy(ordering);
        BSqlQuery queryFacets = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent facetValueExt = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent alarmRecordExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        queryFacets.join(new BSqlJoin(new BSqlField(facetValueExt, BOrionAlarmFacetValue.alarm), new BSqlField(alarmRecordExt, BOrionAlarmRecord.id)));
        BSqlQuery querySources = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlExtent sourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlExtent alarmRecordExt2 = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        querySources.join(new BSqlJoin(new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm), new BSqlField(alarmRecordExt2, BOrionAlarmRecord.id)));
        BOrdering ordering2 = new BOrdering();
        ordering2.add(Columns.orderBy((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.sourceOrder)));
        querySources.orderBy(ordering2);
        Object object = this.db.exclusiveAccessMutex;
        synchronized (object) {
            OrionCursor records = this.session.select((BQuery)queryRecords);
            OrionCursor facets = this.session.select((BQuery)queryFacets);
            OrionCursor sources = this.session.select((BQuery)querySources);
            return new OrionAlarmCursor(records, facets, sources, this.session, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BAlarmRecord> timeQuery(BAbsTime start, BAbsTime end) throws IOException, AlarmException {
        BSqlQuery queryRecords = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
        BSqlExtent alarmRecordExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        queryRecords.where(Exprs.builder((BExpression)Predicates.ge((BExpression)new BSqlField(alarmRecordExt, BOrionAlarmRecord.timestamp), (BSimple)start)).and(Predicates.le((BExpression)new BSqlField(alarmRecordExt, BOrionAlarmRecord.timestamp), (BSimple)end)));
        BOrdering ordering = new BOrdering();
        ordering.add(Columns.orderBy((BExpression)new BSqlField(alarmRecordExt, BOrionAlarmRecord.id)).asc());
        queryRecords.orderBy(ordering);
        BSqlQuery queryFacets = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent facetValueExt = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent alarmRecordExt2 = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        queryFacets.join(new BSqlJoin(new BSqlField(facetValueExt, BOrionAlarmFacetValue.alarm), new BSqlField(alarmRecordExt2, BOrionAlarmRecord.id)));
        queryFacets.where(Exprs.builder((BExpression)Predicates.ge((BExpression)new BSqlField(alarmRecordExt2, BOrionAlarmRecord.timestamp), (BSimple)start)).and(Predicates.le((BExpression)new BSqlField(alarmRecordExt2, BOrionAlarmRecord.timestamp), (BSimple)end)));
        BOrdering ordering2 = new BOrdering();
        ordering2.add(Columns.orderBy((BExpression)new BSqlField(facetValueExt, BOrionAlarmFacetValue.alarm)).asc());
        queryFacets.orderBy(ordering2);
        BSqlQuery querySources = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlExtent sourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlExtent alarmRecordExt3 = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE);
        querySources.join(new BSqlJoin(new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm), new BSqlField(alarmRecordExt3, BOrionAlarmRecord.id)));
        querySources.where(Exprs.builder((BExpression)Predicates.ge((BExpression)new BSqlField(alarmRecordExt3, BOrionAlarmRecord.timestamp), (BSimple)start)).and(Predicates.le((BExpression)new BSqlField(alarmRecordExt3, BOrionAlarmRecord.timestamp), (BSimple)end)));
        BOrdering ordering3 = new BOrdering();
        ordering3.add(Columns.orderBy((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.alarm)).asc());
        ordering3.add(Columns.orderBy((BExpression)new BSqlField(sourceOrderExt, BOrionAlarmSourceOrder.sourceOrder)));
        querySources.orderBy(ordering3);
        Object object = this.db.exclusiveAccessMutex;
        synchronized (object) {
            OrionCursor records = this.session.select((BQuery)queryRecords);
            OrionCursor facets = this.session.select((BQuery)queryFacets);
            OrionCursor sources = this.session.select((BQuery)querySources);
            return new OrionAlarmCursor(records, facets, sources, this.session, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BAlarmRecord> doBqlQuery(BqlQuery bql) throws AlarmException {
        if (BOrionAlarmDatabase.log.isLoggable(Level.FINE)) {
            BOrionAlarmDatabase.log.fine("Executing bql " + bql.toString());
        }
        try {
            SelectQuery select = (SelectQuery)bql;
            BSqlQuery query = (BSqlQuery)new BSqlQuery().select((BProjection)new BExtentProjection());
            query.getProjection().setDistinct(true);
            BExpression expression = null;
            BSqlExtent alarmExt = new BSqlExtent(BOrionAlarmRecord.ORION_TYPE).alias("alarms");
            SlotCursor slotCursor = new BOrionAlarmRecord().getProperties();
            while (slotCursor.next()) {
                RangeSet rangeSet;
                Property property = slotCursor.property();
                if (property.getType().is(BRef.TYPE) || (rangeSet = select.getRange(property.getName(), property.getType(), false)).isAll()) continue;
                expression = expression == null ? this.createExpression(rangeSet, property) : Exprs.builder(expression).and(this.createExpression(rangeSet, property)).getExpression();
                if (!property.equals(BOrionAlarmRecord.timestamp)) continue;
                BAbsTime max = (BAbsTime)rangeSet.getRange((int)0).max;
                BAbsTime min = (BAbsTime)rangeSet.getRange((int)0).min;
                for (int i = 1; i < rangeSet.getCount(); ++i) {
                    Range range = rangeSet.getRange(i);
                    if (max != null && (range.max == null || ((BAbsTime)range.max).isAfter(max))) {
                        max = (BAbsTime)range.max;
                    }
                    if (min == null || range.min != null && !((BAbsTime)range.min).isBefore(min)) continue;
                    min = (BAbsTime)range.min;
                }
                if (min != null) {
                    expression = Exprs.builder((BExpression)expression).and(Predicates.gt((Property)BOrionAlarmRecord.datestamp, (BSimple)BDate.make((BAbsTime)min).prevDay())).getExpression();
                }
                if (max == null) continue;
                expression = Exprs.builder((BExpression)expression).and(Predicates.lt((Property)BOrionAlarmRecord.datestamp, (BSimple)BDate.make((BAbsTime)max).nextDay())).getExpression();
            }
            RangeSet rangeSet = select.getRange("source", BOrdList.TYPE, true);
            if (!rangeSet.isAll() && rangeSet.getCount() == 1) {
                BOrdList alarmSource = (BOrdList)rangeSet.getRange(0).getMin();
                for (int i = 0; i < alarmSource.size(); ++i) {
                    BSqlExtent sourceListOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE).alias("sourceOrder" + i);
                    BSqlExtent sourceListExt = new BSqlExtent(BOrionAlarmSource.ORION_TYPE).alias("alarmSource" + i);
                    query.join(new BSqlJoin(new BSqlField(alarmExt, BOrionAlarmRecord.id), new BSqlField(sourceListOrderExt, BOrionAlarmSourceOrder.alarm)));
                    query.join(new BSqlJoin(new BSqlField(sourceListOrderExt, BOrionAlarmSourceOrder.alarmSource), new BSqlField(sourceListExt, BOrionAlarmSource.id)));
                    BExpression joinExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(sourceListOrderExt, BOrionAlarmSourceOrder.sourceOrder), (BSimple)BInteger.make((int)i))).and(Predicates.eq((BExpression)new BSqlField(sourceListExt, BOrionAlarmSource.source), (BSimple)alarmSource.get(i))).getExpression();
                    expression = expression == null ? joinExpression : Exprs.builder((BExpression)expression).and(joinExpression).getExpression();
                }
            }
            if (!(rangeSet = select.getRange("alarmClass", BString.TYPE, true)).isAll() && rangeSet.getCount() == 1) {
                BString className = (BString)rangeSet.getRange(0).getMin();
                BSqlExtent alarmClassExt = new BSqlExtent(BOrionAlarmClass.ORION_TYPE);
                query.join(new BSqlJoin(new BSqlField(alarmExt, BOrionAlarmRecord.alarmClass), new BSqlField(alarmClassExt, BOrionAlarmClass.id)));
                BExpression joinExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(alarmClassExt, BOrionAlarmClass.alarmClass), (BSimple)className)).getExpression();
                expression = expression == null ? joinExpression : Exprs.builder((BExpression)expression).and(joinExpression).getExpression();
            }
            try (OrionCursor facetCursor = this.session.scan(BOrionAlarmFacetName.ORION_TYPE);){
                BExpression facetsExpression = null;
                while (facetCursor.next()) {
                    BExpression facetExpression;
                    BOrionAlarmFacetName facetName = (BOrionAlarmFacetName)((Object)facetCursor.get());
                    RangeSet rangeSet2 = select.getRange(facetName.getFacetName(), BIDataValue.TYPE, true);
                    if (rangeSet2.isAll() || rangeSet2.getCount() != 1) continue;
                    BSqlExtent facetValueExt = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE).alias("value_" + facetName.getFacetName());
                    query.join(new BSqlJoin(new BSqlField(alarmExt, BOrionAlarmRecord.id), new BSqlField(facetValueExt, BOrionAlarmFacetValue.alarm)));
                    try {
                        facetExpression = Exprs.builder((BExpression)Predicates.eq((BExpression)new BSqlField(facetValueExt, BOrionAlarmFacetValue.value), (BSimple)BString.make((String)DataUtil.marshal((BObject)rangeSet2.getRange(0).getMin())))).and(Predicates.eq((BExpression)new BSqlField(facetValueExt, BOrionAlarmFacetValue.facetName), (BSimple)BRef.make((BIOrionObject)facetName))).getExpression();
                    }
                    catch (IOException ioe) {
                        throw new BajaRuntimeException("Unable to marshal facet expression: " + rangeSet2.getRange(0).getMin(), (Throwable)ioe);
                    }
                    if (expression == null) {
                        facetsExpression = facetExpression;
                        continue;
                    }
                    facetsExpression = Exprs.builder((BExpression)facetsExpression).or(facetExpression).getExpression();
                }
                expression = expression == null ? facetsExpression : Exprs.builder((BExpression)expression).and(facetsExpression).getExpression();
            }
            query.where(expression);
            query = (BSqlQuery)query.from((BExtent)alarmExt);
            query.orderBy(BOrdering.make((BOrderByColumn)Columns.orderBy((BExpression)new BSqlField(alarmExt, BOrionAlarmRecord.id)).asc()));
            Object object = this.db.exclusiveAccessMutex;
            synchronized (object) {
                return new OrionAlarmCursor(this.session.select((BQuery)query), null, null, this.session, true);
            }
        }
        catch (RuntimeException e) {
            throw new BajaRuntimeException("Unable to execute BQL against alarm database.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllRecords(Context cx) throws IOException {
        Object object = this.db.exclusiveAccessMutex;
        synchronized (object) {
            this.session.delete(BOrionAlarmRecord.ORION_TYPE, null);
            try (OrionCursor cursor = this.session.scan(BOrionAlarmClass.ORION_TYPE);){
                while (cursor.next()) {
                    this.session.delete((BIOrionObject)((BOrionAlarmClass)((Object)cursor.get())));
                }
            }
        }
        try {
            BOrionAlarmService service = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
            BAlarmClass[] alarmClasses = service.getAlarmClasses();
            for (int i = 0; i < alarmClasses.length; ++i) {
                BAlarmClass alarmClass = alarmClasses[i];
                alarmClass.setUnackedAlarmCount(0);
                alarmClass.setOpenAlarmCount(0);
                alarmClass.setInAlarmCount(0);
                alarmClass.setTotalAlarmCount(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOldRecords(BAbsTime before, Context cx) throws IOException {
        block5: {
            Object object = this.db.exclusiveAccessMutex;
            synchronized (object) {
                BExpression dateExpression = Exprs.builder((BExpression)Predicates.lt((Property)BOrionAlarmRecord.datestamp, (BSimple)BDate.make((BAbsTime)before).nextDay())).and(Predicates.lt((Property)BOrionAlarmRecord.timestamp, (BSimple)before)).getExpression();
                this.session.delete(BOrionAlarmRecord.ORION_TYPE, dateExpression);
            }
            try {
                this.db.recalculateAlarmClassStatistics();
            }
            catch (Exception e) {
                if (!BOrionAlarmDatabase.log.isLoggable(Level.SEVERE)) break block5;
                BOrionAlarmDatabase.log.log(Level.SEVERE, "Failed to update Alarm Class Statistics", e);
            }
        }
    }

    public void clearRecord(BUuid uuid, Context cx) throws IOException {
        if (BOrionAlarmDatabase.log.isLoggable(Level.FINE)) {
            BOrionAlarmDatabase.log.fine("Clearing record " + uuid);
        }
        if (!this.db.isOpen()) {
            throw new AlarmException("Unable to update, database unavailable.");
        }
        new ClearAlarmRecord(uuid, this.db).run();
    }

    private BExpression createExpression(RangeSet rangeSet, Property property) {
        BExpression rangeSetExpression = null;
        for (int i = 0; i < rangeSet.getCount(); ++i) {
            Range range = rangeSet.getRange(i);
            BExpression rangeExpression = null;
            if (range.getMin() != null) {
                rangeExpression = range.getMax() != null ? (range.getMinInclusive() ? (range.getMaxInclusive() ? (range.getMin().equals((Object)range.getMax()) ? Predicates.eq((Property)property, (BSimple)range.getMin()) : Exprs.builder((BExpression)Predicates.ge((Property)property, (BSimple)range.getMin())).and(Predicates.le((Property)property, (BSimple)range.getMax())).getExpression()) : Exprs.builder((BExpression)Predicates.ge((Property)property, (BSimple)range.getMin())).and(Predicates.lt((Property)property, (BSimple)range.getMax())).getExpression()) : (range.getMaxInclusive() ? Exprs.builder((BExpression)Predicates.gt((Property)property, (BSimple)range.getMin())).and(Predicates.le((Property)property, (BSimple)range.getMax())).getExpression() : Exprs.builder((BExpression)Predicates.gt((Property)property, (BSimple)range.getMin())).and(Predicates.lt((Property)property, (BSimple)range.getMax())).getExpression())) : (range.getMinInclusive() ? Predicates.ge((Property)property, (BSimple)range.getMin()) : Predicates.gt((Property)property, (BSimple)range.getMin()));
            } else if (range.getMax() != null) {
                rangeExpression = range.getMaxInclusive() ? Predicates.le((Property)property, (BSimple)range.getMax()) : Predicates.lt((Property)property, (BSimple)range.getMax());
            }
            rangeSetExpression = rangeSetExpression == null ? rangeExpression : Exprs.builder(rangeSetExpression).or(rangeExpression).getExpression();
        }
        return rangeSetExpression;
    }
}

