/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import com.tridium.alarm.BIAlarmRecordDecorator;
import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.alarmOrion.transactions.AppendAlarmRecord;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmFacetName;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.alarmOrion.OrionAlarmDbConnection;
import javax.baja.data.DataUtil;
import javax.baja.naming.BOrdList;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.ICoalesceable;

public class UpdateAlarmRecord
extends AlarmRecordTransaction
implements ICoalesceable {
    protected BAlarmRecord alarmRecord;
    private final BOrionAlarmDatabase database;

    public UpdateAlarmRecord(BAlarmRecord alarmRecord, BOrionAlarmDatabase database) {
        this.alarmRecord = alarmRecord;
        this.database = database;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    public Object getCoalesceKey() {
        return this.alarmRecord.getUuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun() {
        Object object = this.database.exclusiveAccessMutex;
        synchronized (object) {
            block66: {
                OrionSession session = null;
                try (OrionAlarmDbConnection conn = (OrionAlarmDbConnection)this.database.getDbConnection(null);){
                    session = conn.getOrionSession();
                    session.setAutoCommit(false);
                    BOrionAlarmRecord orionAlarmDbRecord = conn.getOrionRecord(this.alarmRecord.getUuid(), session);
                    if (orionAlarmDbRecord == null) {
                        new AppendAlarmRecord(this.alarmRecord, this.database).run();
                    } else {
                        BAlarmRecord undecoratedAlarmRec = BIAlarmRecordDecorator.undecorateAllOnWriteStart((BAlarmRecord)this.alarmRecord, (Context)BAlarmRecord.ALARM_STORE_CX);
                        try {
                            BAlarmRecord orionAlarmRecord = orionAlarmDbRecord.getAlarmRecord(session);
                            BOrionAlarmClass alarmClass = orionAlarmDbRecord.resolveAlarmClass(session);
                            alarmClass.setTotalAlarmCount(alarmClass.getTotalAlarmCount() - 1);
                            if (!orionAlarmRecord.isAcknowledged()) {
                                alarmClass.setUnackedAlarmCount(alarmClass.getUnackedAlarmCount() - 1);
                            }
                            if (!orionAlarmRecord.isNormal()) {
                                alarmClass.setInAlarmCount(alarmClass.getInAlarmCount() - 1);
                            }
                            if (orionAlarmRecord.isOpen()) {
                                alarmClass.setOpenAlarmCount(alarmClass.getOpenAlarmCount() - 1);
                            }
                            orionAlarmDbRecord.setTimestamp(undecoratedAlarmRec.getTimestamp());
                            orionAlarmDbRecord.setSourceState(undecoratedAlarmRec.getSourceState());
                            orionAlarmDbRecord.setAckState(undecoratedAlarmRec.getAckState());
                            orionAlarmDbRecord.setAckRequired(undecoratedAlarmRec.getAckRequired());
                            orionAlarmDbRecord.setPriority(undecoratedAlarmRec.getPriority());
                            orionAlarmDbRecord.setNormalTime(undecoratedAlarmRec.getNormalTime());
                            orionAlarmDbRecord.setAckTime(undecoratedAlarmRec.getAckTime());
                            orionAlarmDbRecord.setUserAccount(undecoratedAlarmRec.getUser());
                            orionAlarmDbRecord.setAlarmTransition(undecoratedAlarmRec.getAlarmTransition());
                            orionAlarmDbRecord.setLastUpdate(undecoratedAlarmRec.getLastUpdate());
                            if (!undecoratedAlarmRec.getAlarmClass().equals(orionAlarmRecord.getAlarmClass())) {
                                session.update((BIOrionObject)alarmClass);
                                alarmClass = BOrionAlarmClass.get(undecoratedAlarmRec.getAlarmClass(), session);
                                orionAlarmDbRecord.setAlarmClass(BRef.make((BIOrionObject)alarmClass));
                            }
                            if (!undecoratedAlarmRec.getAlarmData().equivalent((Object)orionAlarmRecord.getAlarmData())) {
                                String[] orionAlarmFacetKeys;
                                String[] alarmFacetKeys = undecoratedAlarmRec.getAlarmData().list();
                                BFacets orionAlarmFacets = orionAlarmRecord.getAlarmData();
                                BatchStatement facetInserter = session.batchInsert(BOrionAlarmFacetValue.ORION_TYPE);
                                BatchStatement facetUpdater = session.batchUpdate(BOrionAlarmFacetValue.ORION_TYPE);
                                BatchStatement facetDeleter = session.batchDelete(BOrionAlarmFacetValue.ORION_TYPE);
                                for (int i = 0; i < alarmFacetKeys.length; ++i) {
                                    block64: {
                                        BObject obj = orionAlarmFacets.get(alarmFacetKeys[i]);
                                        if (obj == null) {
                                            BObject value = undecoratedAlarmRec.getAlarmData().get(alarmFacetKeys[i]);
                                            try {
                                                String encodedValue;
                                                try {
                                                    encodedValue = DataUtil.marshal((BObject)value);
                                                }
                                                catch (IOException ioe) {
                                                    throw new BajaRuntimeException("Facet " + alarmFacetKeys[i] + " can not be marshalled.", (Throwable)ioe);
                                                }
                                                if (encodedValue.length() > BOrionAlarmFacetValue.value.getFacets().geti("width", 0)) {
                                                    throw new BajaRuntimeException("Facet " + alarmFacetKeys[i] + " too big, " + encodedValue.length() + '>' + BOrionAlarmFacetValue.value.getFacets().geti("width", 0));
                                                }
                                                BOrionAlarmFacetValue orionAlarmData = BOrionAlarmFacetValue.make(alarmFacetKeys[i], encodedValue, orionAlarmDbRecord, session);
                                                facetInserter.add((BIOrionObject)orionAlarmData);
                                            }
                                            catch (Exception e) {
                                                if (BOrionAlarmService.logger.isLoggable(Level.FINE)) {
                                                    BOrionAlarmService.logger.log(Level.WARNING, "Unable to save alarm facet", e);
                                                }
                                                break block64;
                                            }
                                        }
                                        if (undecoratedAlarmRec.getAlarmData().get(alarmFacetKeys[i]) != null && !obj.equivalent((Object)undecoratedAlarmRec.getAlarmData().get(alarmFacetKeys[i]))) {
                                            try (OrionCursor cursor = null;){
                                                String encodedValue;
                                                BObject value;
                                                cursor = session.select(BOrionAlarmFacetValue.ORION_TYPE, new PropertyValue[]{new PropertyValue(BOrionAlarmFacetValue.alarm, (BValue)BRef.make((BIOrionObject)orionAlarmDbRecord)), new PropertyValue(BOrionAlarmFacetValue.facetName, (BValue)BRef.make((BIOrionObject)BOrionAlarmFacetName.get(alarmFacetKeys[i], session)))});
                                                if (cursor.next()) {
                                                    value = undecoratedAlarmRec.getAlarmData().get(alarmFacetKeys[i]);
                                                    try {
                                                        try {
                                                            encodedValue = DataUtil.marshal((BObject)value);
                                                        }
                                                        catch (IOException ioe) {
                                                            throw new BajaRuntimeException("Facet " + alarmFacetKeys[i] + " can not be marshalled.", (Throwable)ioe);
                                                        }
                                                        if (encodedValue.length() > BOrionAlarmFacetValue.value.getFacets().geti("width", 0)) {
                                                            throw new BajaRuntimeException("Facet " + alarmFacetKeys[i] + " too big, " + encodedValue.length() + '>' + BOrionAlarmFacetValue.value.getFacets().geti("width", 0));
                                                        }
                                                        BOrionAlarmFacetValue facetValue = (BOrionAlarmFacetValue)((Object)cursor.get());
                                                        facetValue.setValue(encodedValue);
                                                        facetUpdater.add((BIOrionObject)facetValue);
                                                        if (cursor.next()) {
                                                            throw new BajaRuntimeException("Multiple values defined found for facet " + alarmFacetKeys[i] + ", should only be one.");
                                                        }
                                                        break block64;
                                                    }
                                                    catch (Exception e) {
                                                        if (BOrionAlarmService.logger.isLoggable(Level.FINE)) {
                                                            BOrionAlarmService.logger.log(Level.WARNING, "Unable to save alarm facet", e);
                                                        }
                                                        break block64;
                                                    }
                                                }
                                                facetInserter.add((BIOrionObject)BOrionAlarmFacetValue.make(alarmFacetKeys[i], undecoratedAlarmRec.getAlarmData().get(alarmFacetKeys[i]), orionAlarmDbRecord, session));
                                                value = undecoratedAlarmRec.getAlarmData().get(alarmFacetKeys[i]);
                                                try {
                                                    try {
                                                        encodedValue = DataUtil.marshal((BObject)value);
                                                    }
                                                    catch (IOException ioe) {
                                                        throw new BajaRuntimeException("Facet " + alarmFacetKeys[i] + " can not be marshalled.", (Throwable)ioe);
                                                    }
                                                    if (encodedValue.length() > BOrionAlarmFacetValue.value.getFacets().geti("width", 0)) {
                                                        throw new BajaRuntimeException("Facet " + alarmFacetKeys[i] + " too big, " + encodedValue.length() + '>' + BOrionAlarmFacetValue.value.getFacets().geti("width", 0));
                                                    }
                                                    BOrionAlarmFacetValue orionAlarmData = BOrionAlarmFacetValue.make(alarmFacetKeys[i], encodedValue, orionAlarmDbRecord, session);
                                                    facetInserter.add((BIOrionObject)orionAlarmData);
                                                }
                                                catch (Exception e) {
                                                    if (BAlarmService.logger.isLoggable(Level.FINE)) {
                                                        BAlarmService.logger.log(Level.WARNING, "Unable to save alarm facet", e);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    orionAlarmFacets = BFacets.makeRemove((BFacets)orionAlarmFacets, (String)alarmFacetKeys[i]);
                                }
                                facetInserter.execute();
                                facetUpdater.execute();
                                for (String orionAlarmFacetKey : orionAlarmFacetKeys = orionAlarmFacets.list()) {
                                    try (OrionCursor cursor = null;){
                                        cursor = session.select(BOrionAlarmFacetValue.ORION_TYPE, new PropertyValue[]{new PropertyValue(BOrionAlarmFacetValue.alarm, (BValue)BRef.make((BIOrionObject)orionAlarmDbRecord)), new PropertyValue(BOrionAlarmFacetValue.facetName, (BValue)BRef.make((BIOrionObject)BOrionAlarmFacetName.get(orionAlarmFacetKey, session)))});
                                        if (!cursor.next()) continue;
                                        do {
                                            facetDeleter.add((BIOrionObject)((BOrionAlarmFacetValue)((Object)cursor.get())));
                                        } while (cursor.next());
                                    }
                                }
                                facetDeleter.execute();
                            }
                            if (!orionAlarmRecord.getSource().equivalent((Object)undecoratedAlarmRec.getSource())) {
                                session.delete(BOrionAlarmSourceOrder.ORION_TYPE, Predicates.eq((Property)BOrionAlarmSourceOrder.alarm, (BSimple)BRef.make((BIOrionObject)orionAlarmDbRecord)));
                                BatchStatement sourceInserter = session.batchInsert(BOrionAlarmSourceOrder.ORION_TYPE);
                                BOrdList alarmSource = undecoratedAlarmRec.getSource();
                                for (int i = 0; i < alarmSource.size(); ++i) {
                                    BOrionAlarmSourceOrder orionAlarmSource = BOrionAlarmSourceOrder.make(alarmSource.get(i), i, orionAlarmDbRecord, session);
                                    sourceInserter.add((BIOrionObject)orionAlarmSource);
                                }
                                sourceInserter.execute();
                            }
                            session.update((BIOrionObject)orionAlarmDbRecord);
                            alarmClass.setTotalAlarmCount(alarmClass.getTotalAlarmCount() + 1);
                            if (!(undecoratedAlarmRec.isAcknowledged() || undecoratedAlarmRec.isNormal() && !undecoratedAlarmRec.getAckRequired())) {
                                alarmClass.setUnackedAlarmCount(alarmClass.getUnackedAlarmCount() + 1);
                            }
                            if (!undecoratedAlarmRec.isNormal()) {
                                alarmClass.setInAlarmCount(alarmClass.getInAlarmCount() + 1);
                            }
                            if (undecoratedAlarmRec.isOpen()) {
                                alarmClass.setOpenAlarmCount(alarmClass.getOpenAlarmCount() + 1);
                            }
                            session.update((BIOrionObject)alarmClass);
                        }
                        finally {
                            BIAlarmRecordDecorator.redecorateAllOnWriteEnd((BAlarmRecord)undecoratedAlarmRec, (Context)BAlarmRecord.ALARM_STORE_CX);
                        }
                    }
                    session.commit();
                }
                catch (RuntimeException e) {
                    BAlarmDatabase.log.log(Level.SEVERE, "Unable to update record " + this.alarmRecord.getUuid(), e);
                    this.setTransactionFailed();
                    if (session == null) break block66;
                    session.rollback();
                }
            }
        }
    }
}

