/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import java.util.logging.Level;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.OrionAlarmDbConnection;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.util.BUuid;
import javax.baja.util.ICoalesceable;

public class ClearAlarmRecord
extends AlarmRecordTransaction
implements ICoalesceable {
    BUuid uuid;
    private final BOrionAlarmDatabase database;

    public ClearAlarmRecord(BUuid uuid, BOrionAlarmDatabase database) {
        this.uuid = uuid;
        this.database = database;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    public Object getCoalesceKey() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun() {
        Object object = this.database.exclusiveAccessMutex;
        synchronized (object) {
            block21: {
                OrionSession session = null;
                try (OrionAlarmDbConnection conn = (OrionAlarmDbConnection)this.database.getDbConnection(null);){
                    session = conn.getOrionSession();
                    session.setAutoCommit(false);
                    BOrionAlarmRecord orionAlarmRecord = (BOrionAlarmRecord)session.read(BOrionAlarmRecord.ORION_TYPE, new PropertyValue(BOrionAlarmRecord.uuid, (BValue)this.uuid));
                    if (orionAlarmRecord != null) {
                        BOrionAlarmClass alarmClass = orionAlarmRecord.resolveAlarmClass(session);
                        alarmClass.setTotalAlarmCount(alarmClass.getTotalAlarmCount() - 1);
                        if (!orionAlarmRecord.isAcknowledged()) {
                            alarmClass.setUnackedAlarmCount(alarmClass.getUnackedAlarmCount() - 1);
                        }
                        if (!orionAlarmRecord.isNormal()) {
                            alarmClass.setInAlarmCount(alarmClass.getInAlarmCount() - 1);
                        }
                        if (orionAlarmRecord.isOpen()) {
                            alarmClass.setOpenAlarmCount(alarmClass.getOpenAlarmCount() - 1);
                        }
                        session.update((BIOrionObject)alarmClass);
                        session.delete(BOrionAlarmRecord.ORION_TYPE, Predicates.eq((Property)BOrionAlarmRecord.id, (BSimple)BInteger.make((int)orionAlarmRecord.getId())));
                    }
                    session.commit();
                }
                catch (Exception e) {
                    BOrionAlarmDatabase.log.log(Level.SEVERE, "Unable to clear alarm " + this.uuid, e);
                    this.setTransactionFailed();
                    if (session == null) break block21;
                    session.rollback();
                }
            }
        }
    }
}

