/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="queueSize", type="int", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="processRate", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"per minute\"), BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="peekProcessRate", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"per minute\"), BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="enqueueRate", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"per minute\"), BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="peekEnqueueRate", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"per minute\"), BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="alarmCount", type="int", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")})})
@NiagaraActions(value={@NiagaraAction(name="update", flags=4), @NiagaraAction(name="transactionEnqueued", flags=4), @NiagaraAction(name="transactionProcessed", parameterType="BComponent", defaultValue="new BComponent()", flags=4), @NiagaraAction(name="reset")})
public class BOrionAlarmTransactionStatistics
extends BComponent {
    @Generated
    public static final Property queueSize = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property processRate = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"per minute"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property peekProcessRate = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"per minute"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property enqueueRate = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"per minute"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property peekEnqueueRate = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"per minute"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property alarmCount = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Action update = BOrionAlarmTransactionStatistics.newAction((int)4, null);
    @Generated
    public static final Action transactionEnqueued = BOrionAlarmTransactionStatistics.newAction((int)4, null);
    @Generated
    public static final Action transactionProcessed = BOrionAlarmTransactionStatistics.newAction((int)4, (BValue)new BComponent(), null);
    @Generated
    public static final Action reset = BOrionAlarmTransactionStatistics.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionAlarmTransactionStatistics.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"charts/line.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final int FLAGS = 11;
    private int processedCount = 0;
    private int enqueuedCount = 0;
    private Clock.Ticket ticket;
    private static final BRelTime updateRate = BRelTime.makeSeconds((int)10);

    @Generated
    public int getQueueSize() {
        return this.getInt(queueSize);
    }

    @Generated
    public void setQueueSize(int v) {
        this.setInt(queueSize, v, null);
    }

    @Generated
    public double getProcessRate() {
        return this.getDouble(processRate);
    }

    @Generated
    public void setProcessRate(double v) {
        this.setDouble(processRate, v, null);
    }

    @Generated
    public double getPeekProcessRate() {
        return this.getDouble(peekProcessRate);
    }

    @Generated
    public void setPeekProcessRate(double v) {
        this.setDouble(peekProcessRate, v, null);
    }

    @Generated
    public double getEnqueueRate() {
        return this.getDouble(enqueueRate);
    }

    @Generated
    public void setEnqueueRate(double v) {
        this.setDouble(enqueueRate, v, null);
    }

    @Generated
    public double getPeekEnqueueRate() {
        return this.getDouble(peekEnqueueRate);
    }

    @Generated
    public void setPeekEnqueueRate(double v) {
        this.setDouble(peekEnqueueRate, v, null);
    }

    @Generated
    public int getAlarmCount() {
        return this.getInt(alarmCount);
    }

    @Generated
    public void setAlarmCount(int v) {
        this.setInt(alarmCount, v, null);
    }

    @Generated
    public void update() {
        this.invoke(update, null, null);
    }

    @Generated
    public void transactionEnqueued() {
        this.invoke(transactionEnqueued, null, null);
    }

    @Generated
    public void transactionProcessed(BComponent parameter) {
        this.invoke(transactionProcessed, (BValue)parameter, null);
    }

    @Generated
    public void reset() {
        this.invoke(reset, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)updateRate, (Action)update, null);
    }

    public void stopped() {
        if (this.ticket != null && !this.ticket.isExpired()) {
            this.ticket.cancel();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BOrionAlarmService.TYPE) && ((BOrionAlarmTransactionStatistics[])parent.getChildren(((Object)((Object)this)).getClass())).length == 0;
    }

    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        if (dynamic instanceof BIcon) {
            return (BIcon)dynamic;
        }
        return icon;
    }

    public void doReset() {
        Property[] properties = this.getDynamicPropertiesArray();
        for (int i = 0; i < properties.length; ++i) {
            if (!Flags.isTransient((BComplex)this, (Slot)properties[i])) continue;
            this.remove(properties[i]);
        }
        this.enqueuedCount = 0;
        this.processedCount = 0;
        this.update();
    }

    public void doTransactionEnqueued() {
        ++this.enqueuedCount;
    }

    public void doTransactionProcessed(BComponent data) {
        BRelTime total;
        BRelTime avg;
        String className = ((BString)data.get("className")).toString();
        long processTime = ((BRelTime)data.get("processTime")).getMillis();
        String countSlot = className + "Count";
        String avgSlot = className + "Avg";
        String totalSlot = className + "Total";
        ++this.processedCount;
        BDouble count = (BDouble)this.get(countSlot);
        if (count == null) {
            count = BDouble.DEFAULT;
            this.add(countSlot, (BValue)count, 11, BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)), null);
        }
        if ((avg = (BRelTime)this.get(avgSlot)) == null) {
            avg = BRelTime.DEFAULT;
            this.add(avgSlot, (BValue)avg, 11, BFacets.make((String)"showMilliseconds", (boolean)true), null);
        }
        if ((total = (BRelTime)this.get(totalSlot)) == null) {
            total = BRelTime.DEFAULT;
            this.add(totalSlot, (BValue)total, 11, BFacets.make((String)"showMilliseconds", (boolean)true), null);
        }
        count = BDouble.make((double)(count.getDouble() + 1.0));
        total = BRelTime.make((long)(total.getMillis() + processTime));
        avg = BRelTime.make((long)(total.getMillis() / count.getLong()));
        this.set(countSlot, (BValue)count);
        this.set(avgSlot, (BValue)avg);
        this.set(totalSlot, (BValue)total);
    }

    public void doUpdate() {
        BOrionAlarmService service = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        this.setQueueSize(((Queue)service.fw(601)).size());
        try (AlarmDbConnection conn = service.getAlarmDb().getDbConnection(null);){
            this.setAlarmCount(conn.getRecordCount());
        }
        this.setProcessRate(this.processedCount * (60 / updateRate.getSeconds()));
        this.setPeekProcessRate(Math.max(this.getPeekProcessRate(), this.getProcessRate()));
        this.processedCount = 0;
        this.setEnqueueRate(this.enqueuedCount * (60 / updateRate.getSeconds()));
        this.setPeekEnqueueRate(Math.max(this.getPeekEnqueueRate(), this.getEnqueueRate()));
        this.enqueuedCount = 0;
    }
}

