/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.util.SchemaUpgradeUtil;
import com.tridium.rdb.jdbc.RdbmsDialect;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.rdb.ddl.AlterColumn;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public class Upgrade_1_2_to_1_3
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BSchemaVersion.make((String)"1.2");
    private static final BSchemaVersion TO_VERSION = BSchemaVersion.make((String)"1.3");

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp app, OrionSession session) throws Exception {
        block6: {
            try {
                BAlarmService.logger.info("Attempting to resize BOrionAlarmSource.source...");
                AlterColumn ddl = SchemaUpgradeUtil.alterColumn((OrionType)BOrionAlarmSource.ORION_TYPE, (Property)BOrionAlarmSource.source, (BLocalOrionDatabase)db);
                session.invokeDdl((DdlCommand)ddl);
                BAlarmService.logger.info("Width change for BOrionAlarmSource.source complete.");
            }
            catch (Exception firstException) {
                BAlarmService.logger.log(Level.FINE, "Problem resizing database since some BOrionAlarmSource data is too long.", firstException);
                if (BOrionAlarmSource.SOURCE_LENGTH >= 256) break block6;
                BAlarmService.logger.warning("Removing records of BOrionAlarmSource length of 256 to comply with new limit of " + BOrionAlarmSource.SOURCE_LENGTH + "...");
                try {
                    String tableName = session.getOrionDatabase().getTableName(BOrionAlarmSource.ORION_TYPE);
                    OrionCursor c = session.select(BOrionAlarmSource.ORION_TYPE, "select * from " + tableName + " where " + ((RdbmsDialect)session.getRdbmsContext()).getStringLengthFunctionName() + "(" + tableName + "." + BOrionAlarmSource.source.getName() + ") > " + BOrionAlarmSource.SOURCE_LENGTH);
                    while (c.next()) {
                        BOrionAlarmSource source = (BOrionAlarmSource)((Object)c.get());
                        OrionCursor sourceCursor = session.select(BOrionAlarmSourceOrder.ORION_TYPE, new PropertyValue(BOrionAlarmSourceOrder.alarmSource, (BValue)BRef.make((BIOrionObject)source)));
                        while (sourceCursor.next()) {
                            BOrionAlarmSourceOrder order = (BOrionAlarmSourceOrder)((Object)sourceCursor.get());
                            BOrionAlarmRecord record = order.resolveAlarm(session);
                            if (record == null) continue;
                            session.delete((BIOrionObject)record);
                        }
                        BAlarmService.logger.warning(source.getSource().toString().length() + " > " + BOrionAlarmSource.SOURCE_LENGTH + ", removing all records associated with " + source.getSource());
                        session.delete((BIOrionObject)source);
                    }
                    BAlarmService.logger.info("Attempting to resize BOrionAlarmSource.source again...");
                    AlterColumn ddl = SchemaUpgradeUtil.alterColumn((OrionType)BOrionAlarmSource.ORION_TYPE, (Property)BOrionAlarmSource.source, (BLocalOrionDatabase)db);
                    session.invokeDdl((DdlCommand)ddl);
                    BAlarmService.logger.info("Width change for BOrionAlarmSource.source completed on second attempt.");
                }
                catch (Exception e) {
                    BAlarmService.logger.log(Level.SEVERE, "Upgrade_1_2_to_1_3 Schema Upgrade either not needed or failed", e);
                }
            }
        }
    }
}

