/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.conversion.file;

import com.tridium.alarm.BTextOp;
import com.tridium.alarm.db.file.BFileAlarmDatabase;
import com.tridium.alarmOrion.conversion.BAlarmConversion;
import com.tridium.alarmOrion.conversion.BAlarmConversionJob;
import com.tridium.orion.OrionSession;
import java.io.IOException;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.OrionAlarmDbConnection;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Queue;

@NiagaraType
public class BFileAlarmConversionJob
extends BAlarmConversionJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BFileAlarmConversionJob.class);
    private boolean running = true;
    private BAlarmConversion conversion;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFileAlarmConversionJob() {
    }

    public BFileAlarmConversionJob(BAlarmConversion conversion) {
        this.conversion = conversion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) {
        BOrionAlarmService service = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        BOrionAlarmDatabase database = (BOrionAlarmDatabase)service.getAlarmDb();
        try (OrionAlarmDbConnection orionConn = (OrionAlarmDbConnection)database.getDbConnection(cx);){
            OrionSession session = orionConn.getOrionSession();
            Queue queue = (Queue)service.fw(601);
            this.log().start("Conversion started");
            this.recordsConverted = 0.0;
            this.recordsFailed = 0.0;
            this.running = true;
            try (BFileAlarmDatabase fileDatabase = new BFileAlarmDatabase();){
                fileDatabase.open();
                try (AlarmDbConnection fileDbConn = fileDatabase.getDbConnection(cx);
                     AlarmDbConnection conn = database.getDbConnection(cx);){
                    this.recordsTotal = fileDbConn.getRecordCount();
                    try (Cursor cursor = fileDbConn.scan();){
                        while (cursor.next() && this.running) {
                            String newName;
                            BString sourceName;
                            String alarmClass;
                            BAlarmRecord record = new BAlarmRecord(BUuid.DEFAULT);
                            record.copyFrom((BComplex)cursor.get());
                            if (this.conversion.getChangeLastUpdated()) {
                                record.setLastUpdate(Clock.time());
                            }
                            if ((alarmClass = this.conversion.getAlarmClass()) != null && !alarmClass.equals("")) {
                                record.setAlarmClass(SlotPath.escape((String)TextUtil.replace((String)alarmClass, (String)"%alarmClass%", (String)SlotPath.unescape((String)record.getAlarmClass()))));
                            }
                            if ((sourceName = (BString)record.getAlarmData().get("sourceName")) != null) {
                                newName = this.conversion.getSourceName().customize(sourceName.toString());
                                record.setAlarmData(BFacets.make((BFacets)record.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)newName)));
                            } else if (this.conversion.getSourceName().getOp() == BTextOp.replace) {
                                newName = this.conversion.getSourceName().customize("");
                                record.setAlarmData(BFacets.make((BFacets)record.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)newName)));
                            }
                            this.progress();
                            conn.update(record);
                            try {
                                while (queue.size() > 250) {
                                    Thread.sleep(1000L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.recordsConverted += 1.0;
                        }
                    }
                }
            }
            catch (IOException e) {
                this.failed(e);
            }
            finally {
                session.close();
            }
        }
    }

    public void doCancel(Context cx) {
        this.running = false;
    }
}

