/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.archive;

import com.tridium.alarmOrion.archive.BOrionAlarmArchive;
import com.tridium.alarmOrion.archive.BOrionAlarmArchiveDatabase;
import com.tridium.alarmOrion.transactions.AppendAlarmRecord;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmArchive;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BArchiveAlarmProvider;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmFacetName;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.BOrionAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="rdbOrd", type="BOrd", defaultValue="BOrd.DEFAULT")
@NiagaraAction(name="importOpenAlarms", flags=16)
public class BOrionArchiveAlarmProvider
extends BArchiveAlarmProvider
implements BIOrionApp {
    @Generated
    public static final Property rdbOrd = BOrionArchiveAlarmProvider.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Action importOpenAlarms = BOrionArchiveAlarmProvider.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionArchiveAlarmProvider.class);
    private BOrionAlarmArchive orionAlarmArchive;
    private BOrionDatabase orionDb;
    private static final Logger LOG = Logger.getLogger("alarmOrion");
    private static final OrionType[] ORION_TYPES = new OrionType[]{BOrionAlarmRecord.ORION_TYPE, BOrionAlarmClass.ORION_TYPE, BOrionAlarmFacetValue.ORION_TYPE, BOrionAlarmFacetName.ORION_TYPE, BOrionAlarmSource.ORION_TYPE, BOrionAlarmSourceOrder.ORION_TYPE};
    private RdbmsSubscriber rdbmsSubscriber;
    private static final BComponentEventMask EVENT_MASKS = BComponentEventMask.make((int)0x100001);
    public static final Lexicon LEX = Lexicon.make((String)"alarmOrion");
    private static final Set<String> SUBSCRIBED_DB_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("serviceName", "databaseName", "instanceName", "hostAddress")));

    @Generated
    public BOrd getRdbOrd() {
        return (BOrd)this.get(rdbOrd);
    }

    @Generated
    public void setRdbOrd(BOrd v) {
        this.set(rdbOrd, (BValue)v, null);
    }

    @Generated
    public void importOpenAlarms() {
        this.invoke(importOpenAlarms, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmArchive getAlarmArchive() {
        if (this.orionAlarmArchive == null) {
            this.orionAlarmArchive = new BOrionAlarmArchive(this, new BOrionAlarmArchiveDatabase(this));
        }
        return this.orionAlarmArchive;
    }

    public BStatus getArchiveStatus() {
        BRdbms rdbms;
        if (!Sys.isStationStarted()) {
            return BStatus.stale;
        }
        this.checkConfig();
        if (this.isFatalFault()) {
            return BStatus.fault;
        }
        if (this.orionDb == null) {
            this.configFatal(LEX.getText("orionAlarmArchive.orionDbNotReady"));
            return BStatus.fault;
        }
        try {
            BOrionDatabase currentOrionDb = ((BOrionAlarmArchive)this.getAlarmArchive()).getOrionAlarmDb().getOrionDatabase();
            if (currentOrionDb == null || !currentOrionDb.equals((Object)this.orionDb)) {
                this.configFatal(LEX.getText("orionAlarmArchive.rdbOrdChange"));
                return BStatus.fault;
            }
        }
        catch (BajaRuntimeException e) {
            this.configFatal(e.getLocalizedMessage());
            return BStatus.fault;
        }
        Optional<BRdbms> db = this.getRdbms();
        if (db.isPresent() && (rdbms = db.get()).isRunning()) {
            return rdbms.getStatus();
        }
        return BStatus.fault;
    }

    public Optional<BRdbms> getRdbms() {
        BRdbms rdbms = null;
        try {
            rdbms = (BRdbms)this.getRdbOrd().get((BObject)this);
            if (this.rdbmsSubscriber != null && !this.rdbmsSubscriber.isSubscribed((BComponent)rdbms)) {
                this.rdbmsSubscriber.unsubscribeAll();
                this.rdbmsSubscriber.subscribe((BComponent)rdbms);
                this.updateStatus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.ofNullable(rdbms);
    }

    public boolean isProviderReady() {
        Optional<BRdbms> rdbms = this.getRdbms();
        if (!rdbms.isPresent()) {
            this.executeFail(LEX.getText("orionAlarmArchive.archiveNotFound"));
            return false;
        }
        BRdbms db = rdbms.get();
        if (!db.getEnabled()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("rdbms disabled, on thread " + Thread.currentThread().getName());
            }
            this.updateStatus();
            return false;
        }
        return true;
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        Optional<BRdbms> rdbms = this.getRdbms();
        if (rdbms.isPresent()) {
            rdbms.get().getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        } else {
            this.executeFail(LEX.getText("orionAlarmArchive.archiveNotFound"));
        }
        return null;
    }

    public final void doImportOpenAlarms(Context cx) {
        block34: {
            if (!this.canExecuteRequest()) {
                return;
            }
            try {
                List<BUuid> openUuids;
                if (!this.isProviderReady()) break block34;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("begin import on thread " + Thread.currentThread().getName());
                }
                BOrd query = BOrd.make((String)"alarm:archive|bql:select * from openAlarms");
                try (TableCursor result = ((BITable)query.resolve((BObject)this).get()).cursor();){
                    openUuids = this.importOpenAlarmsToLocalDb((Cursor<BAlarmRecord>)result);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("imported " + openUuids.size() + " alarm records");
                }
                int clearCount = 0;
                try (AlarmDbConnection conn = this.getAlarmArchive().getDbConnection(null);){
                    for (BUuid uuid : openUuids) {
                        conn.clearRecord(uuid, null);
                        ++clearCount;
                    }
                }
                catch (IOException ioe) {
                    LOG.fine("failed to clear all the open alarm records from archive");
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("cleared " + clearCount + " open alarm records");
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("end import");
                }
            }
            catch (Exception e) {
                LOG.fine("import failed " + e.getMessage());
            }
        }
    }

    private List<BUuid> importOpenAlarmsToLocalDb(Cursor<BAlarmRecord> recordsToImport) {
        ArrayList<BUuid> uuidToRemove = new ArrayList<BUuid>();
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        try (AlarmDbConnection alarmDbConn = alarmService.getAlarmDb().getDbConnection(null);){
            while (recordsToImport.next()) {
                BAlarmRecord record = (BAlarmRecord)recordsToImport.get();
                alarmDbConn.append(record);
                uuidToRemove.add(record.getUuid());
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to append alarms", e);
        }
        return uuidToRemove;
    }

    public List<BUuid> exportClearedRecords(Cursor<BAlarmRecord> recordsToExport) {
        BOrionService orionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BOrionSpace orionSpace = orionService.getOrionSpace();
        BLocalOrionDatabase db = (BLocalOrionDatabase)orionSpace.getOrionDatabase(this.getRdbms().get());
        ArrayList<BUuid> uuidsToRemove = new ArrayList<BUuid>();
        try (OrionSession session = null;){
            session = db.createSession(null);
            session.setAutoCommit(false);
            while (recordsToExport.next()) {
                BAlarmRecord rec = (BAlarmRecord)recordsToExport.get();
                AppendAlarmRecord appendRecord = new AppendAlarmRecord(rec, this.orionAlarmArchive.getOrionAlarmDb());
                appendRecord.doRun();
                if (appendRecord.getTransactionFailed()) continue;
                uuidsToRemove.add(rec.getUuid());
            }
            session.commit();
        }
        return uuidsToRemove;
    }

    public OrionType[] getOrionTypes() {
        return ORION_TYPES;
    }

    public void orionReady(BOrionDatabase db) {
        this.orionDb = db;
    }

    public BSchemaVersion getSchemaVersion() {
        return new BOrionAlarmService().getSchemaVersion();
    }

    public void performSchemaUpgrade(BLocalOrionDatabase db, BSchemaVersion oldVersion) throws Exception {
        new BOrionAlarmService().performSchemaUpgrade(db, oldVersion);
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void checkConfig() {
        if (this.getRdbOrd().isNull()) {
            this.configFatal(LEX.getText("orionAlarmArchive.rdbOrdWrongType", new Object[]{"null"}));
            return;
        }
        try {
            BObject obj = this.getRdbOrd().get((BObject)this);
            if (!(obj instanceof BRdbms)) {
                String type = "null";
                if (obj != null && obj.getType() != null) {
                    type = obj.getType().getTypeName();
                }
                throw new Exception(LEX.getText("orionAlarmArchive.rdbOrdWrongType", new Object[]{type}));
            }
        }
        catch (Exception ex) {
            this.configFatal(LEX.getText("orionAlarmArchive.rdbOrdNotConfigured", new Object[]{ex.getLocalizedMessage()}));
        }
        try {
            Sys.getService((Type)BOrionService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            this.configFatal(LEX.getText("orionAlarmArchive.orionServiceNotFound"));
        }
    }

    public void serviceStarted() throws Exception {
        this.checkConfig();
        if (!this.getStatus().isFault()) {
            this.registerApp();
        }
    }

    public void registerApp() {
        BOrionService service;
        BLocalOrionDatabase localOrionDatabase;
        Optional<BRdbms> rdbms = this.getRdbms();
        if (rdbms.isPresent() && !(localOrionDatabase = (BLocalOrionDatabase)(service = (BOrionService)Sys.getService((Type)BOrionService.TYPE)).getOrionDatabase(rdbms.get())).isRegistered((BIOrionApp)this)) {
            localOrionDatabase.registerApp((BIOrionApp)this);
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.subscribeToRdbms();
        this.updateStatus();
    }

    public void serviceStopped() throws Exception {
        if (this.rdbmsSubscriber != null) {
            this.rdbmsSubscriber.unsubscribeAll();
            this.rdbmsSubscriber = null;
        }
        this.unregisterApp();
    }

    public void unregisterApp() {
        try {
            Optional<BRdbms> rdbms = this.getRdbms();
            if (rdbms.isPresent()) {
                BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
                ((BLocalOrionDatabase)service.getOrionDatabase(rdbms.get())).unregisterApp((BIOrionApp)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void subscribeToRdbms() {
        BRdbms db;
        if (this.rdbmsSubscriber == null) {
            this.rdbmsSubscriber = new RdbmsSubscriber();
        } else {
            this.rdbmsSubscriber.unsubscribeAll();
            this.unregisterApp();
        }
        Optional<BRdbms> rdbms = this.getRdbms();
        if (!this.getRdbOrd().isNull() && rdbms.isPresent() && (db = rdbms.get()).isRunning()) {
            if (this.rdbmsSubscriber == null) {
                this.rdbmsSubscriber = new RdbmsSubscriber();
            }
            this.rdbmsSubscriber.subscribe((BComponent)db);
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(rdbOrd)) {
            this.subscribeToRdbms();
            this.updateStatus();
        }
    }

    private class RdbmsSubscriber
    extends Subscriber {
        public RdbmsSubscriber() {
            this.setMask(EVENT_MASKS);
        }

        public void event(BComponentEvent event) {
            int id = event.getId();
            if (id == 0) {
                Property prop = (Property)event.getSlot();
                if (prop.equals(BRdbms.status)) {
                    BOrionArchiveAlarmProvider.this.updateStatus();
                }
                if (prop.isFrozen() && SUBSCRIBED_DB_PROPERTIES.contains(prop.getName())) {
                    BOrionArchiveAlarmProvider.this.configFatal(LEX.getText("orionAlarmArchive.rdbPropertyChange", new Object[]{prop.getName()}));
                    BOrionArchiveAlarmProvider.this.updateStatus();
                }
            } else if (id == 20) {
                this.unsubscribeAll();
                BOrionArchiveAlarmProvider.this.unregisterApp();
                BOrionArchiveAlarmProvider.this.updateStatus();
            }
        }
    }
}

