/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.archive;

import com.tridium.alarmOrion.SkipLocalAlarmClassUpdates;
import com.tridium.alarmOrion.archive.BOrionArchiveAlarmProvider;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionException;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.OrionAlarmDbConnection;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.security.BIProtected;
import javax.baja.status.BStatus;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BOrionAlarmArchiveDatabase
extends BOrionAlarmDatabase {
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionAlarmArchiveDatabase.class);
    private final BOrionArchiveAlarmProvider provider;
    public static final Lexicon LEX = Lexicon.make((String)"alarmOrion");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOrionAlarmArchiveDatabase(BOrionArchiveAlarmProvider provider) {
        this.provider = provider;
    }

    @Override
    public BStatus getStatus() {
        if (!this.provider.getRdbms().isPresent()) {
            throw new OrionException("Database is not configured.");
        }
        BRdbms rdbms = this.provider.getRdbms().get();
        return rdbms.getStatus();
    }

    @Override
    public BOrionDatabase getOrionDatabase() {
        if (!this.provider.getRdbms().isPresent()) {
            throw new OrionException(LEX.getText("Database is not configured."));
        }
        BRdbms rdbms = this.provider.getRdbms().get();
        BOrionSpace orionSpace = (BOrionSpace)BOrd.make((String)"orion:").resolve((BObject)this.provider).get();
        return orionSpace.getOrionDatabase(rdbms);
    }

    @Override
    public AlarmDbConnection getDbConnection(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissionsFor((BIProtected)this).hasOperatorRead()) {
            throw new AlarmException("user needs alarm space permissions");
        }
        return new OrionAlarmDbConnection(this, this.getOrionDatabase().createSession((Context)new SkipLocalAlarmClassUpdates(cx)));
    }

    @Override
    public void recalculateAlarmClassStatistics() {
    }
}

