/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ux;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.batchJob.BLocalTimeUtil;
import com.tridium.box.json.BsonEncoderPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobPrototype;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraSingleton
public final class BBatchJobRpcUtil
extends BSingleton {
    @Generated
    public static final BBatchJobRpcUtil INSTANCE = new BBatchJobRpcUtil();
    @Generated
    public static final Type TYPE = Sys.loadType(BBatchJobRpcUtil.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getLogFile(String detailsOrd, String startTime, String stepTypeSpec, Context cx) throws Exception {
        BBatchJobStepLogFile logFile;
        if (!detailsOrd.equals("null")) {
            BJobStepDetails details = (BJobStepDetails)BOrd.make((String)detailsOrd).get(null, cx);
            if (!details.getPermissions(cx).hasOperatorRead()) {
                throw new PermissionException("Insufficient privileges to Details");
            }
            logFile = BBatchJobStepLogFile.find((BJobStepDetails)details, null);
        } else {
            logFile = BBatchJobStepLogFile.find((BTypeSpec)BTypeSpec.make((String)stepTypeSpec), (BAbsTime)BAbsTime.make((String)startTime), null);
            if (!logFile.getPermissions(cx).hasOperatorRead()) {
                throw new PermissionException("Insufficient privileges to access job log file");
            }
        }
        return logFile.getOrdInSession().toString();
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getJobLogStepDetails(String jobStepLogOrd, Context cx) throws Exception {
        BBatchJobStepLogFile stepLogFile = (BBatchJobStepLogFile)BOrd.make((String)jobStepLogOrd).get(null, cx);
        if (!stepLogFile.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to view job step details.");
        }
        BComponent doc = (BComponent)BLocalTimeUtil.decodeBogFile((BIFile)stepLogFile);
        return BsonEncoderPlugin.marshal((BValue)doc, (Context)cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getJobLogDetails(String jobLogOrd, Context cx) throws Exception {
        BBatchJobLogFile jobLogFile = (BBatchJobLogFile)BOrd.make((String)jobLogOrd).get(null, cx);
        if (!jobLogFile.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to view job log details.");
        }
        BComponent doc = (BComponent)BLocalTimeUtil.decodeBogFile((BIFile)jobLogFile);
        return BsonEncoderPlugin.marshal((BValue)doc, (Context)cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getJobOrd(String jobStartTime, String baseNavOrdStr, Context cx) throws Exception {
        BIProtected base = (BIProtected)BOrd.make((String)baseNavOrdStr).get(null, cx);
        if (!base.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to look up job details.");
        }
        BAbsTime startTime = BAbsTime.make((String)jobStartTime);
        BBatchJob job = BBatchJob.findMounted((BAbsTime)startTime, (BObject)((BObject)base));
        if (job == null) {
            BBatchJobLogFile logFile = BBatchJobLogFile.find((BAbsTime)startTime, (BObject)((BObject)base));
            return BOrd.make((BOrd)((BINavNode)base).getNavOrd(), (BOrd)logFile.getOrdInSession()).normalize().toString(cx);
        }
        return job.getOrdInSession().toString(cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void cancelJobs(List<String> jobStartTimes, String baseNavOrdStr, Context cx) throws Exception {
        BIProtected base = (BIProtected)BOrd.make((String)baseNavOrdStr).get(null, cx);
        if (!base.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to look up job details.");
        }
        jobStartTimes.forEach(jobStartTime -> {
            try {
                BAbsTime startTime = BAbsTime.make((String)jobStartTime);
                BBatchJob job = BBatchJob.find((BAbsTime)startTime, (BObject)((BObject)base));
                if (!job.isMounted()) {
                    job.setDisplayTimeZone(startTime.getTimeZone());
                }
                job.invoke(BJob.cancel, null, cx);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<String> getJobSummaries(String jobTypeSpec, String baseNavOrd, Context cx) throws Exception {
        BJobService jobSvc = (BJobService)BOrd.make((String)"service:baja:JobService").get(null, cx);
        if (!jobSvc.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to access Job Service.");
        }
        ArrayList<BIBatchJobSummary> summaries = new ArrayList<BIBatchJobSummary>();
        Class jobClass = Sys.getType((String)jobTypeSpec).getTypeClass();
        SlotCursor c = jobSvc.getProperties();
        while (c.next(jobClass)) {
            BBatchJob job = (BBatchJob)c.get();
            if (job.getJobState().isComplete()) continue;
            BIBatchJobSummary summary2 = BBatchJobRpcUtil.getQueryManager(cx).makeJobSummary(job);
            summaries.add(summary2);
        }
        BObject base = BOrd.make((String)baseNavOrd).get(null, cx);
        try (IterableCursor c2 = BBatchJobRpcUtil.getQueryManager(cx).listJobSummaries(Sys.getType((String)jobTypeSpec), base);){
            while (c2.next()) {
                BIBatchJobSummary summary3 = (BIBatchJobSummary)c2.get();
                summaries.add(summary3);
            }
        }
        summaries.sort(Comparator.comparing(BIBatchJobSummary::getStartTime).reversed());
        return summaries.stream().map(summary -> BBatchJobRpcUtil.encodeWrapper(summary, base)).collect(Collectors.toList());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<String> getPrototypeJobSummaries(String jobPrototypeOrd, Context cx) {
        BBatchJobPrototype jobPrototype = (BBatchJobPrototype)BOrd.make((String)jobPrototypeOrd).get(null, cx);
        if (!jobPrototype.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to access the prototype job.");
        }
        BJobService jobSvc = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)jobPrototype, cx);
        if (!jobSvc.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to access Job Service.");
        }
        jobSvc.lease(2);
        BOrd protoOrd = jobPrototype.getOrdInSpace();
        ArrayList<BIBatchJobSummary> summaries = new ArrayList<BIBatchJobSummary>();
        SlotCursor c = jobSvc.getProperties();
        while (c.next(BBatchJob.class)) {
            BBatchJob job = (BBatchJob)c.get();
            if (!job.getPrototypeOrd().equals((Object)protoOrd) || job.getJobState().isComplete()) continue;
            BIBatchJobSummary summary2 = BBatchJobRpcUtil.getQueryManager(cx).makeJobSummary(job);
            summaries.add(summary2);
        }
        c = jobPrototype.listBatchJobSummaries();
        while (c.next()) {
            BIBatchJobSummary summary3 = (BIBatchJobSummary)c.get();
            summaries.add(summary3);
        }
        summaries.sort(Comparator.comparing(BIBatchJobSummary::getStartTime).reversed());
        return summaries.stream().map(summary -> BBatchJobRpcUtil.encodeWrapper(summary, (BObject)jobPrototype)).collect(Collectors.toList());
    }

    private static BIJobQueryManager getQueryManager(Context cx) {
        BBatchJobService service = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(null, cx);
        if (!service.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to access Batch Job Service.");
        }
        return service.getJobQueryManager();
    }

    private static String encodeWrapper(BIBatchJobSummary summary, BObject base) {
        try {
            BComponent summaryComp = new BComponent();
            summaryComp.add("summary", (BValue)summary);
            BBatchJob job = null;
            try {
                job = summary.getJob(base);
            }
            catch (Exception exception) {
                // empty catch block
            }
            summaryComp.add("jobOrd", (BValue)(job != null && job.isMounted() ? job.getNavOrd() : BOrd.DEFAULT));
            return BsonEncoderPlugin.marshal((BValue)summaryComp);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

