/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.json;

import com.tridium.box.json.BlackListedTypes;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.baja.io.ValueDocEncoder;
import javax.baja.status.BStatus;
import javax.baja.sys.BAction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;

public final class BsonEncoderPlugin
implements ValueDocEncoder.IEncoderPlugin {
    private JSONWriter w;
    private OutputStream out;
    private OutputStreamWriter outw;
    private static final Type[] emptyTypeArray = new Type[0];

    public BsonEncoderPlugin(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public BsonEncoderPlugin(OutputStream out) throws IOException {
        this.out = new BufferedOutputStream(out);
        this.outw = new OutputStreamWriter(out);
        this.w = QuickJSONWriter.make((Appendable)this.outw);
    }

    public BsonEncoderPlugin(JSONWriter writer) throws IOException {
        this.w = writer;
    }

    public ValueDocEncoder.IEncoderPlugin encodeDocStart() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin encodeDocEnd() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin encodeDocument(ValueDocEncoder encoder, BValue value) throws IOException {
        encoder.encode(value);
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin start(String name) throws IOException {
        try {
            this.w.object().key("nm").value((Object)name);
        }
        catch (JSONException e) {
            throw new BsonIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin startArray(String name) throws IOException {
        try {
            this.w.key(name).array();
        }
        catch (JSONException e) {
            throw new BsonIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin endArray() throws IOException {
        try {
            this.w.endArray();
        }
        catch (JSONException e) {
            throw new BsonIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin end() throws IOException {
        try {
            this.w.endObject();
        }
        catch (JSONException e) {
            throw new BsonIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin end(String name) throws IOException {
        return this.end();
    }

    public ValueDocEncoder.IEncoderPlugin endAttr() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin newLine() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin endProp() throws IOException {
        try {
            this.w.endObject();
        }
        catch (JSONException e) {
            throw new BsonIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin key(String key) throws IOException {
        try {
            this.w.key(key);
        }
        catch (JSONException e) {
            throw new BsonIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin attr(String key, boolean val) throws IOException {
        this.attr(key, String.valueOf(val));
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin attr(String key, double val) throws IOException {
        this.attr(key, String.valueOf(val));
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin attr(String key, String str) throws IOException {
        try {
            this.w.key(key).value((Object)str);
        }
        catch (JSONException e) {
            throw new BsonIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin attrSafe(String key, String str) throws IOException {
        return this.attr(key, str);
    }

    public ValueDocEncoder.IEncoderPlugin value(String str) throws IOException {
        try {
            this.w.value((Object)str);
        }
        catch (JSONException e) {
            throw new BsonIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin comment(String text) throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin incrementIndent() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin decrementIndent() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin indent() throws IOException {
        return this;
    }

    public int getIndent() {
        return -1;
    }

    public String encodeSimple(ValueDocEncoder encoder, BSimple simple, Context cx) throws IOException {
        if (BlackListedTypes.isTypeBlackListedForEncoding(simple.getType())) {
            simple = simple.getType().getInstance().asSimple();
        }
        return super.encodeSimple(encoder, simple, cx);
    }

    public ValueDocEncoder.IEncoderPlugin encodeType(Type type) throws IOException {
        this.attr("t", type.toString());
        return this;
    }

    public void flush() throws IOException {
        if (this.outw != null) {
            this.outw.flush();
        }
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.outw != null) {
            this.outw.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public boolean isZipped() {
        return false;
    }

    public void setZipped(boolean zipped) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static String marshal(BValue value) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DisplayEncoder encoder = new DisplayEncoder(new BsonEncoderPlugin(out));
        encoder.encode(value);
        encoder.close();
        return out.toString();
    }

    public static String marshal(BValue value, Context cx) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DisplayEncoder encoder = new DisplayEncoder(new BsonEncoderPlugin(out), cx);
        encoder.encode(value);
        encoder.close();
        return out.toString();
    }

    public static void encodingSlotBson(ValueDocEncoder encoder, BComplex parent, Slot slot) throws IOException {
        encoder.getPlugin().attr("dn", BsonEncoderPlugin.getSlotDisplayName(parent, slot, encoder.getContext()));
    }

    public static String getSlotDisplayName(BComplex clx, Slot slot, Context cx) {
        BValue val;
        if (slot.isDynamic() && (val = clx.get((Property)slot)) instanceof BIMixIn) {
            return ((BIMixIn)val).getDisplayNameInParent(cx);
        }
        return slot.getDefaultDisplayName(cx);
    }

    private static void detectEnumRangeTypes(ArrayList<Type> types, BEnumRange range) {
        if (range == null || range == BEnumRange.DEFAULT) {
            return;
        }
        Type frozenType = range.getFrozenType();
        if (frozenType != null) {
            types.add(frozenType);
        }
    }

    private static void detectDynEnumTypes(ArrayList<Type> types, BDynamicEnum dynEnum) {
        if (dynEnum == BDynamicEnum.DEFAULT) {
            return;
        }
        BsonEncoderPlugin.detectEnumRangeTypes(types, dynEnum.getRange());
    }

    private static ArrayList<Type> detectFacetsTypes(ArrayList<Type> types, BFacets facets) {
        String[] keys;
        if (facets == null || facets == BFacets.DEFAULT) {
            return types;
        }
        for (String key : keys = facets.list()) {
            BObject obj = facets.get(key);
            if (obj.getType().is(BDynamicEnum.TYPE)) {
                if (types == null) {
                    types = new ArrayList();
                }
                BsonEncoderPlugin.detectDynEnumTypes(types, (BDynamicEnum)obj);
                continue;
            }
            if (!obj.getType().is(BEnumRange.TYPE)) continue;
            if (types == null) {
                types = new ArrayList();
            }
            BsonEncoderPlugin.detectEnumRangeTypes(types, (BEnumRange)obj);
        }
        return types;
    }

    private static void detectStatusTypes(ArrayList<Type> types, BStatus status) {
        if (status == BStatus.DEFAULT) {
            return;
        }
        BsonEncoderPlugin.detectFacetsTypes(types, status.getFacets());
    }

    public static Type[] detectTypeDependencies(BObject val) {
        ArrayList<Object> types = null;
        if (val instanceof BStatus && val != BStatus.DEFAULT) {
            types = new ArrayList<Type>();
            BsonEncoderPlugin.detectStatusTypes(types, (BStatus)val);
        } else if (val instanceof BFacets && val != BFacets.DEFAULT) {
            types = new ArrayList();
            BsonEncoderPlugin.detectFacetsTypes(types, (BFacets)val);
        } else if (val instanceof BDynamicEnum && val != BDynamicEnum.DEFAULT) {
            types = new ArrayList();
            BsonEncoderPlugin.detectDynEnumTypes(types, (BDynamicEnum)val);
        } else if (val instanceof BEnumRange && val != BEnumRange.DEFAULT) {
            types = new ArrayList();
            BsonEncoderPlugin.detectEnumRangeTypes(types, (BEnumRange)val);
        }
        return types == null ? emptyTypeArray : types.toArray(emptyTypeArray);
    }

    public static void encodingValueBson(ValueDocEncoder encoder, BValue val, Context cx) throws IOException {
        ValueDocEncoder.IEncoderPlugin plugin = encoder.getPlugin();
        try {
            String display;
            Type[] type = val.getType();
            if (!encoder.isTypeBlackListed((Type)type) && !BlackListedTypes.isTypeBlackListedForEncoding((Type)type)) {
                if (val instanceof BNameMap) {
                    String[] keys;
                    BNameMap nMap = (BNameMap)val;
                    JSONObject obj = new JSONObject();
                    for (String key : keys = nMap.list()) {
                        obj.put(key, (Object)nMap.get(key).format((Object)val, cx));
                    }
                    display = obj.toString();
                } else {
                    display = val.toString(cx);
                }
            } else {
                display = "";
            }
            plugin.attr("d", display);
        }
        catch (Exception e) {
            plugin.attr("d", "");
        }
        Type[] types = BsonEncoderPlugin.detectTypeDependencies((BObject)val);
        if (types.length > 0) {
            plugin.startArray("td");
            for (Type type : types) {
                plugin.value(type.toString());
            }
            plugin.endArray();
        }
        if (val.getType().is(BAction.TYPE)) {
            BAction action = (BAction)val;
            BsonEncoderPlugin.encodeActionBson(encoder, action.getParameterType(), action.getParameterDefault(), action.getReturnType());
        }
        if (val.getType().is(BTopic.TYPE)) {
            BTopic topic = (BTopic)val;
            BsonEncoderPlugin.encodeTopicBson(encoder, topic.getEventType());
        }
    }

    public static void encodingFacetsBson(ValueDocEncoder encoder, BFacets facets) throws IOException {
        ArrayList<Type> types = BsonEncoderPlugin.detectFacetsTypes(null, facets);
        if (types != null && types.size() > 0) {
            ValueDocEncoder.IEncoderPlugin plugin = encoder.getPlugin();
            plugin.startArray("xtd");
            for (int i = 0; i < types.size(); ++i) {
                plugin.value(types.get(i).toString());
            }
            plugin.endArray();
        }
    }

    public static void encodeActionBson(ValueDocEncoder encoder, Type paramType, BValue paramDefault, Type returnType) throws IOException {
        ValueDocEncoder.IEncoderPlugin plugin = encoder.getPlugin();
        if (paramType != null) {
            plugin.attr("apt", paramType.toString());
        }
        if (paramDefault != null) {
            encoder.key("apd");
            encoder.encode(paramDefault);
        }
        if (returnType != null) {
            encoder.attr("art", returnType.toString());
        }
    }

    public static void encodeTopicBson(ValueDocEncoder encoder, Type eventType) throws IOException {
        if (eventType != null) {
            encoder.attr("tet", eventType.toString());
        }
    }

    public static void encodeIsNavChild(ValueDocEncoder encoder, BComponent comp) throws IOException {
        encoder.attr("nc", comp.isNavChild());
    }

    private static class BsonIoException
    extends IOException {
        private BsonIoException(JSONException e) {
            super(e.getMessage());
            this.initCause(e);
        }
    }

    public static final class DisplayEncoder
    extends ValueDocEncoder {
        public DisplayEncoder(ValueDocEncoder.IEncoderPlugin plugin) throws IOException {
            super(plugin);
            this.setEncodeComments(false);
            this.setEncodeTransients(true);
        }

        public DisplayEncoder(ValueDocEncoder.IEncoderPlugin plugin, Context cx) throws IOException {
            super(plugin, cx);
            this.setEncodeComments(false);
            this.setEncodeTransients(true);
        }

        protected void encodingSlot(BComplex parent, Slot slot) throws IOException {
            BsonEncoderPlugin.encodingSlotBson(this, parent, slot);
        }

        protected void encodingValue(BValue val, Context cx) throws IOException {
            BsonEncoderPlugin.encodingValueBson(this, val, cx);
        }

        public boolean isTypeBlackListed(Type type) {
            return BlackListedTypes.isTypeBlackListed(type);
        }

        protected void encodingFacets(BFacets facets) throws IOException {
            BsonEncoderPlugin.encodingFacetsBson(this, facets);
        }

        protected void encodingComponent(BComponent c) throws IOException {
            BsonEncoderPlugin.encodeIsNavChild(this, c);
        }

        protected void encodingComponentStub(BComponent c) throws IOException {
            BsonEncoderPlugin.encodeIsNavChild(this, c);
        }
    }
}

