/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.json;

import java.security.AccessController;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BlackListedTypes {
    private static final Logger LOG = Logger.getLogger("box");
    private static Collection<Type> BLACKLISTED_TYPES = BlackListedTypes.getSimpleTypes(new String[0]);
    private static Collection<Type> BLACKLISTED_FOR_ENCODING_TYPES = BlackListedTypes.getSimpleTypes("baja:Password");
    private static Collection<Type> BLACKLISTED_FOR_DECODING_TYPES = BlackListedTypes.getSimpleTypes(new String[0]);
    private static Collection<Type> SENSITIVE_TYPES = BlackListedTypes.getSimpleTypes("baja:Password");

    private BlackListedTypes() {
    }

    public static boolean isTypeBlackListed(Type type) {
        return BlackListedTypes.isAny(type, BLACKLISTED_TYPES);
    }

    public static boolean isTypeBlackListedForEncoding(Type type) {
        return BlackListedTypes.isTypeBlackListed(type) || BlackListedTypes.isAny(type, BLACKLISTED_FOR_ENCODING_TYPES);
    }

    public static boolean isTypeBlackListedForDecoding(Type type) {
        return BlackListedTypes.isTypeBlackListed(type) || BlackListedTypes.isAny(type, BLACKLISTED_FOR_DECODING_TYPES);
    }

    public static boolean isTypeSensitive(Type type) {
        return BlackListedTypes.isAny(type, SENSITIVE_TYPES);
    }

    public static Type[] getBlacklistedTypes() {
        return BLACKLISTED_TYPES.toArray(new Type[0]);
    }

    private static boolean isAny(Type type, Collection<Type> typesToCheck) {
        for (Type typeToCheck : typesToCheck) {
            if (!type.is(typeToCheck)) continue;
            return true;
        }
        return false;
    }

    private static String[] getTypeSpecs(String systemPropertyKey) {
        return TextUtil.splitAndTrim((String)System.getProperty(systemPropertyKey, ""), (char)';');
    }

    private static Collection<Type> getSimpleTypes(String ... simpleTypeSpecs) {
        HashSet<Type> types = new HashSet<Type>();
        for (String simpleTypeSpec : simpleTypeSpecs) {
            try {
                Type t = Sys.getType((String)simpleTypeSpec);
                if (!t.is(BSimple.TYPE)) {
                    LOG.warning("Cannot add non-Simple User Type to deny list: " + t);
                }
                types.add(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return types;
    }

    static {
        AccessController.doPrivileged(() -> {
            String[] blacklistedTypes = BlackListedTypes.getTypeSpecs("box.blackListedTypes");
            String[] blacklistedForEncodingTypes = BlackListedTypes.getTypeSpecs("box.blackListedForEncodingTypes");
            String[] blacklistedForDecodingTypes = BlackListedTypes.getTypeSpecs("box.blackListedForDecodingTypes");
            String[] sensitiveTypes = BlackListedTypes.getTypeSpecs("box.sensitiveTypes");
            BLACKLISTED_TYPES.addAll(BlackListedTypes.getSimpleTypes(blacklistedTypes));
            BLACKLISTED_FOR_ENCODING_TYPES.addAll(BlackListedTypes.getSimpleTypes(blacklistedForEncodingTypes));
            BLACKLISTED_FOR_DECODING_TYPES.addAll(BlackListedTypes.getSimpleTypes(blacklistedForDecodingTypes));
            SENSITIVE_TYPES.addAll(BlackListedTypes.getSimpleTypes(sensitiveTypes));
            return null;
        });
    }
}

