/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.coll.BBoxQueryResult;
import com.tridium.box.coll.BBoxTable;
import com.tridium.box.file.BBoxFile;
import com.tridium.box.json.AllPermissionsContext;
import com.tridium.box.json.BJsonSimple;
import com.tridium.box.json.BoxString;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.json.JSONWriter;
import com.tridium.web.servlets.FileServlet;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.entityIo.json.JsonEntityEncoder;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipSpace;
import javax.baja.history.BIHistory;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQueryResult;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.BFormat;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.virtual.BVirtualComponentSpace;

@NiagaraType
public final class BOrdChannel
extends BBoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BOrdChannel.class);
    private static final Logger log = Logger.getLogger("box.ord");
    private static final String[] NON_UI_FACET_KEYS = new String[]{"username", "remoteHost", "remotePort"};

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getChannelName() {
        return "ord";
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        boolean handled = false;
        if ("resolve".equals(key)) {
            BOrdChannel.resolve((JSONObject)body, out, op);
            handled = true;
        } else if ("cursor".equals(key)) {
            BOrdChannel.encodeTableContents((JSONObject)body, out, (Context)op);
            handled = true;
        }
        return handled;
    }

    private static void resolve(JSONObject obj, BoxWriter out, BoxOp op) throws Exception {
        String facetsEncoding;
        OrdTarget target = BOrdChannel.resolveOrd(obj, (Context)op);
        BObject res = target.get();
        BJsonSimple val = null;
        if (res instanceof BQueryResult) {
            JSONObject data = new JSONObject();
            BQueryResult qRes = (BQueryResult)res;
            data.put("req", (Object)obj);
            data.put("query", (Object)qRes.getQuery().toString());
            data.put("scope", (Object)qRes.getScope().getOrd().encodeToString());
            val = BBoxQueryResult.DEFAULT.make(data);
        } else if (res instanceof BITable) {
            val = BBoxTable.DEFAULT.make(BOrdChannel.encodeTableSchema(obj, target.getOrd(), (BITable<? extends BIObject>)((BITable)res), (Context)op));
        } else if (res instanceof BIFile) {
            BIFile file = (BIFile)res;
            FilePath filePath = file.getFilePath();
            BFileSpace space = (BFileSpace)file.getSpace();
            String readFileUri = "";
            String writeFileUri = "";
            if (Sys.isStation()) {
                String readPath = "/ord/" + filePath.toString() + "|view:web:FileDownloadView";
                String writePath = space instanceof BZipSpace || space instanceof BModule ? "/module/" + filePath.getAuthority() + "/" + Arrays.stream(filePath.getNames()).collect(Collectors.joining("/")) : "/file/" + Arrays.stream(filePath.getNames()).collect(Collectors.joining("/"));
                readFileUri = new URI(null, null, readPath, null).toASCIIString();
                writeFileUri = new URI(null, null, writePath, null).toASCIIString();
            }
            boolean canRead = FileServlet.canRead((OrdTarget)target);
            boolean canWrite = FileServlet.canWrite((OrdTarget)target);
            val = BBoxFile.DEFAULT.make(new JSONObject().put("navOrd", (Object)file.getNavOrd().toString()).put("ordInSession", (Object)file.getOrdInSession().toString()).put("fileName", (Object)Objects.toString(file.getFileName(), "")).put("ext", (Object)Objects.toString(file.getExtension(), "")).put("dir", file.isDirectory()).put("mime", (Object)Objects.toString(file.getMimeType(), "")).put("size", file.getSize()).put("lastModified", (Object)file.getLastModified().encodeToString()).put("readOnly", !canWrite).put("read", (Object)(canRead ? readFileUri : "")).put("write", (Object)(canWrite ? writeFileUri : "")));
        }
        if (val == null && res != null) {
            val = res instanceof BValue ? (BValue)res : BString.make((String)res.toString((Context)op));
        }
        boolean encodeValue = val != null;
        out.object();
        out.key("p").value((Object)BOrdChannel.encodePermissions(target, (Context)op));
        if (obj.has("sp") && obj.getBoolean("sp")) {
            BComponent targetComp;
            boolean isActionOrTopic = false;
            Slot slotInComponent = target.getSlotInComponent();
            if (val == null && null != slotInComponent && (slotInComponent.isAction() || slotInComponent.isTopic())) {
                isActionOrTopic = true;
            }
            if (BOrdChannel.isMountedInSupportedComponentSpace(targetComp = target.getComponent())) {
                boolean bl = encodeValue = val != null && !(val instanceof BComponent);
                if (!isActionOrTopic) {
                    out.key("sp").value((Object)targetComp.getSlotPath().getBody());
                } else {
                    out.key("sp").value((Object)(targetComp.getSlotPath().getBody() + "/" + slotInComponent.getName()));
                }
                out.key("cs").value((Object)targetComp.getComponentSpace().getOrdInSession().toString((Context)op));
                Property[] propertyPath = target.getPropertyPathInComponent();
                if (null != propertyPath) {
                    out.key("pp").array();
                    for (Property property : propertyPath) {
                        out.value(property.getName());
                    }
                    out.endArray();
                }
            }
        }
        if ((facetsEncoding = BOrdChannel.getFacetsEncoding(target)) != null) {
            out.key("f").value((Object)facetsEncoding);
        }
        if (encodeValue) {
            out.key("o").value((Object)new BoxString(BsonEncoderPlugin.marshal((BValue)val, (Context)new AllPermissionsContext((Context)op))));
            if (obj.has("c") && (res instanceof BITable || res instanceof BQueryResult)) {
                out.key("c");
                BOrdChannel.encodeTableContents(res, (JSONObject)obj.get("c"), out, (Context)op);
            }
        }
        out.endObject();
    }

    private static String getFacetsEncoding(OrdTarget target) throws Exception {
        BFacets facets = target.getFacets();
        if (facets == null || facets.isEmpty()) {
            return null;
        }
        if ((facets = BFacets.makeRemove((BFacets)facets, (String[])NON_UI_FACET_KEYS)) == null || facets.isEmpty()) {
            return null;
        }
        return facets.encodeToString();
    }

    public static JSONObject encodeTableSchema(BITable<? extends BIObject> table, Context cx) throws IOException {
        return BOrdChannel.encodeTableSchema(null, BOrd.NULL, table, cx);
    }

    private static JSONObject encodeTableSchema(Object req, BOrd ord, BITable<? extends BIObject> table, Context op) throws IOException {
        BComponent config;
        JSONObject tableData = new JSONObject();
        if (req != null) {
            tableData.put("req", req);
        }
        if (table.getTableFacets() != null) {
            tableData.put("x", (Object)table.getTableFacets());
        }
        JSONArray columnsArray = new JSONArray();
        for (Column col : table.getColumns().list()) {
            JSONObject colData = new JSONObject();
            colData.put("n", (Object)col.getName());
            colData.put("t", (Object)col.getType().toString());
            colData.put("f", col.getFlags());
            if (col.getFacets() != null) {
                colData.put("x", (Object)col.getFacets().encodeToString());
            }
            colData.put("dn", (Object)BFormat.make((String)col.getDisplayName(op)).format(null));
            columnsArray.put((Object)colData);
        }
        if (table instanceof BIHistory) {
            config = (BComponent)((BIHistory)table).getConfig().newCopy(true);
            if (config.get("typeSpec") == null) {
                config.asComponent().add("typeSpec", (BValue)BString.make((String)table.getType().toString()));
            }
        } else {
            config = new BComponent();
            config.asComponent().add("ord", (BValue)ord);
            config.asComponent().add("typeSpec", (BValue)BString.make((String)table.getType().toString()));
        }
        if (table instanceof BINavNode) {
            BINavNode navNode = (BINavNode)table;
            String navName = Objects.toString(navNode.getNavName(), "");
            if (config.get("navName") == null) {
                config.add("navName", (BValue)BString.make((String)navName));
            }
            String displayName = Objects.toString(navNode.getNavDisplayName(op), "");
            if (config.get("navDisplayName") == null) {
                config.add("navDisplayName", (BValue)BString.make((String)displayName));
            }
            String description = Objects.toString(navNode.getNavDescription(op), "");
            if (config.get("navDescription") == null) {
                config.add("navDescription", (BValue)BString.make((String)description));
            }
            BOrd navOrd = navNode.getNavOrd();
            if (config.get("navOrd") == null) {
                config.add("navOrd", (BValue)(navOrd == null ? BOrd.NULL : navOrd));
            }
            BIcon navIcon = navNode.getNavIcon();
            if (config.get("navIcon") == null) {
                config.add("navIcon", (BValue)(navIcon == null ? BIcon.DEFAULT : navIcon));
            }
        }
        tableData.put("config", (Object)new BoxString(BsonEncoderPlugin.marshal((BValue)config, (Context)new AllPermissionsContext(op))));
        tableData.put("cols", (Object)columnsArray);
        return tableData;
    }

    public static void encodeTableContents(BITable<? extends BIObject> table, JSONWriter out, Context cx) throws Exception {
        BOrdChannel.encodeTableContents((BObject)table, -1, -1, out, cx);
    }

    private static void encodeTableContents(JSONObject obj, BoxWriter out, Context cx) throws Exception {
        BOrdChannel.encodeTableContents(BOrdChannel.resolveOrd(obj, cx).get(), obj, out, cx);
    }

    private static void encodeTableContents(BObject val, JSONObject obj, BoxWriter out, Context cx) throws Exception {
        int offset = obj.has("of") ? obj.getInt("of") : -1;
        int limit = obj.has("lm") ? obj.getInt("lm") : -1;
        BOrdChannel.encodeTableContents(val, offset, limit, (JSONWriter)out, cx);
    }

    private static void encodeTableContents(BObject val, int offset, int limit, JSONWriter out, Context cx) throws Exception {
        out.array();
        if (val instanceof BQueryResult) {
            try (Stream<Entity> entityStream = ((BQueryResult)val).stream().skip(offset == -1 ? 0L : (long)offset).limit(limit == -1 ? Long.MAX_VALUE : (long)limit);){
                entityStream.forEach(entity -> {
                    try {
                        out.value((Object)new BoxString(JsonEntityEncoder.encodeToString((Entity)entity)));
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Failed to encode Entity", e);
                    }
                });
            }
        }
        if (val instanceof BITable) {
            BITable table = (BITable)val;
            try (TableCursor cursor = table.cursor();
                 BsonEncoderPlugin.DisplayEncoder encoder = new BsonEncoderPlugin.DisplayEncoder(new BsonEncoderPlugin(out), (Context)new AllPermissionsContext(cx));){
                cursor.stream().skip(offset == -1 ? 0L : (long)offset).limit(limit == -1 ? Long.MAX_VALUE : (long)limit).forEach(o -> {
                    BUnrestrictedFolder row = new BUnrestrictedFolder();
                    for (Column col : table.getColumns().list()) {
                        BObject rowObj = (BObject)cursor.cell(col).as(BObject.class);
                        if (!rowObj.isValue()) {
                            rowObj = BString.make((String)rowObj.toString(cx));
                        }
                        row.add(SlotPath.escape((String)col.getName()), rowObj.asValue().newCopy(true), 0, BFacets.make((BFacets)col.getFacets(), (BFacets)cursor.row().getCellFacets(col)), null);
                    }
                    try {
                        encoder.encode((BValue)row);
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Failed to encode Table row", e);
                    }
                });
            }
        }
        out.endArray();
    }

    private static JSONObject encodePermissions(OrdTarget target, Context cx) throws Exception {
        JSONObject obj = new JSONObject();
        obj.put("v", (Object)target.getPermissionsForTarget().encodeToString());
        obj.put("cr", target.canRead());
        obj.put("cw", target.canWrite());
        obj.put("ci", target.canInvoke());
        return obj;
    }

    private static boolean isMountedInSupportedComponentSpace(BComponent targetComp) {
        return targetComp != null && targetComp.isMounted() && (targetComp.getSpace().getType() == BComponentSpace.TYPE || targetComp.getSpace().getType() == BVirtualComponentSpace.TYPE);
    }

    public static OrdTarget resolveOrd(JSONObject obj, Context cx) {
        return BOrdChannel.resolveOrd(JSONUtil.getString((JSONObject)obj, (String)"o"), JSONUtil.getString((JSONObject)obj, (String)"bo"), cx);
    }

    private static OrdTarget resolveOrd(String ordString, String baseOrdString, Context cx) {
        BOrd ord = BOrd.make((String)ordString).relativizeToSession().normalize();
        log.fine("Attempting to resolve ORD: " + ord);
        BOrd baseOrd = BOrd.make((String)baseOrdString);
        OrdTarget baseTarget = baseOrd.resolve(null, cx);
        if (!baseTarget.canRead()) {
            throw new PermissionException(baseOrd.toString());
        }
        BObject baseObj = baseTarget.get();
        OrdTarget resTarget = ord.resolve(baseObj, cx);
        if (!resTarget.canRead()) {
            throw new PermissionException(ord.toString());
        }
        return resTarget;
    }
}

