/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxService;
import com.tridium.box.BoxOp;
import com.tridium.box.BoxWsHttpSessionListener;
import com.tridium.box.IBoxEventHandler;
import com.tridium.box.mux.BoxEnvelope;
import com.tridium.session.SessionManager;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.function.BiConsumerCanThrowException;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.WebDev;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;

@NiagaraType
public final class BBoxWebSocketAcceptor
extends BAbstractService {
    @Generated
    public static final Type TYPE = Sys.loadType(BBoxWebSocketAcceptor.class);
    private final Array<WebSocketInfo> webSockets = new Array(WebSocketInfo.class);
    private static final BIcon icon = BIcon.std((String)"braces.png");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBoxService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        WebSocketInfo[] webSocketInfoArray = this.webSockets;
        synchronized (this.webSockets) {
            WebSocketInfo[] socketInfos = (WebSocketInfo[])this.webSockets.trim();
            this.webSockets.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (WebSocketInfo info : socketInfos) {
                info.socket.close();
            }
            return;
        }
    }

    public boolean isNavChild() {
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        WebSocketInfo[] infos;
        Array<WebSocketInfo> array = this.webSockets;
        synchronized (array) {
            infos = (WebSocketInfo[])this.webSockets.trim();
        }
        out.startTable(true);
        out.trTitle((Object)("Open Connections (" + infos.length + ')'), 5);
        out.w((Object)"<tr>");
        out.th((Object)"URI").th((Object)"Encrypted").th((Object)"Accept").th((Object)"Open").th((Object)"Last Message");
        out.w((Object)"</tr>\n");
        BFacets dateTimeFacets = BFacets.make((String[])new String[]{"showTimeZone", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BBoolean.FALSE, BBoolean.TRUE, BBoolean.TRUE});
        for (int i = 0; i < infos.length; ++i) {
            WebSocketInfo info = (WebSocketInfo)this.webSockets.get(i);
            out.tr((Object)info.socket.getRequestURI(), (Object)(info.isEncrypted ? "Yes" : "No "), (Object)info.acceptTime.toString((Context)dateTimeFacets), (Object)(info.openTime.isNull() ? " - " : info.openTime.toString((Context)dateTimeFacets)), (Object)(info.lastMessageTime.isNull() ? " - " : info.lastMessageTime.toString((Context)dateTimeFacets)));
        }
        out.endTable();
        super.spy(out);
    }

    private static final class WebSocketBoxEventHandler
    implements IBoxEventHandler {
        private final BoxWebSocket socket;

        private WebSocketBoxEventHandler(BoxWebSocket socket) {
            this.socket = socket;
        }

        @Override
        public void writeBoxEvents(String serverSessionId, byte[] data, Context cx) {
            if (this.socket.isOpen()) {
                try {
                    this.socket.send(data);
                }
                catch (Exception e) {
                    System.out.println("Error encoding BOX events...");
                    e.printStackTrace();
                }
            }
        }

        @Override
        public boolean isClosed() {
            return !this.socket.isOpen();
        }

        @Override
        public boolean isMuxEnabled() {
            return BoxEnvelope.MUX_ENABLED;
        }
    }

    @WebSocket
    public static final class BoxWebSocket
    implements BoxWsHttpSessionListener.IHttpSessionDestroyListener {
        private final HttpSession httpSession;
        private org.eclipse.jetty.websocket.api.Session session;
        private BBoxService service;
        private Array<WebSocketInfo> webSockets;
        private WebSocketInfo info;
        private WebSocketBoxEventHandler eventHandler;
        private Context cx;
        private Context acceptCx;
        private String remoteAddr;

        public BoxWebSocket(HttpSession httpSession) {
            this.httpSession = httpSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnWebSocketConnect
        public void onConnect(org.eclipse.jetty.websocket.api.Session session) {
            BBoxService.log.fine("onConnect");
            this.session = session;
            this.service = (BBoxService)Sys.getService((Type)BBoxService.TYPE);
            this.webSockets = this.service.getWebSocketAcceptor().webSockets;
            InetAddress inetAddr = session.getRemoteAddress().getAddress();
            this.remoteAddr = Objects.toString(inetAddr != null ? inetAddr.getHostAddress() : "", "");
            String host = session.isSecure() ? "wss://" : "ws://" + this.remoteAddr;
            BFacets facets = BFacets.make((String)"remoteHost", (BIDataValue)BString.make((String)host), (String)"remotePort", (BIDataValue)BInteger.make((int)-1));
            ServletUpgradeRequest req = (ServletUpgradeRequest)session.getUpgradeRequest();
            HttpServletRequest httpReq = req.getHttpServletRequest();
            if (this.isCrossOrigin(httpReq, this.getRequestURI())) {
                BBoxService.log.severe("Cross origin WebSocket request is not allowed: " + httpReq.getHeader("origin"));
                throw new IllegalStateException("Cross origin WebSocket request is not allowed");
            }
            this.cx = (Context)req.getHttpServletRequest().getAttribute("niagara.context");
            this.acceptCx = new BasicContext(this.cx, facets);
            if (this.service.hasListeners()) {
                this.service.notifyListeners(this.acceptCx, BBoxRecordType.status, "Accepted Web Socket");
            }
            this.info = new WebSocketInfo(this, session.isSecure());
            this.eventHandler = new WebSocketBoxEventHandler(this);
            Array<WebSocketInfo> array = this.webSockets;
            synchronized (array) {
                this.webSockets.add((Object)this.info);
            }
            this.info.openTime = BAbsTime.now();
            if (this.service.hasListeners()) {
                this.service.notifyListeners(this.acceptCx, BBoxRecordType.status, "Opened Web Socket");
            }
            BoxWsHttpSessionListener.addDestroyListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnWebSocketClose
        public void onClose(org.eclipse.jetty.websocket.api.Session session, int closeCode, String closeReason) {
            String errorMsg;
            BoxWsHttpSessionListener.removeDestroyListener(this);
            Array<WebSocketInfo> array = this.webSockets;
            synchronized (array) {
                this.webSockets.remove((Object)this.info);
            }
            boolean isCloseError = closeCode != 1000 && closeCode != 1005 && 1001 != closeCode;
            String string = errorMsg = isCloseError ? "BOX WebSocket Closed due to error: " + closeReason : "";
            if (this.service.hasListeners()) {
                this.service.notifyListeners(this.acceptCx, BBoxRecordType.status, "Closed Web Socket");
                if (isCloseError) {
                    this.service.notifyListeners(this.acceptCx, BBoxRecordType.error, errorMsg);
                }
            }
            if (isCloseError) {
                BBoxService.log.severe(BBoxService.makeLogMsg(errorMsg, this.cx));
            }
        }

        @OnWebSocketMessage
        public void onBinaryMessage(org.eclipse.jetty.websocket.api.Session session, byte[] buf, int offset, int len) {
            ByteArrayInputStream in = new ByteArrayInputStream(buf, offset, len);
            this.handleWebSocketData(session, (BiConsumerCanThrowException<Writer, BoxOp, ? extends Exception>)((BiConsumerCanThrowException)(writer, op) -> this.service.handleRequest(in, (Writer)writer, (BoxOp)((Object)op))));
        }

        @OnWebSocketMessage
        public void onTextMessage(org.eclipse.jetty.websocket.api.Session session, String str) {
            ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
            this.handleWebSocketData(session, (BiConsumerCanThrowException<Writer, BoxOp, ? extends Exception>)((BiConsumerCanThrowException)(writer, op) -> this.service.handleRequest(in, (Writer)writer, (BoxOp)((Object)op))));
        }

        private void handleWebSocketData(org.eclipse.jetty.websocket.api.Session session, BiConsumerCanThrowException<Writer, BoxOp, ? extends Exception> consumer) {
            this.info.lastMessageTime = BAbsTime.now();
            if (this.httpSession instanceof Session) {
                Session s = (Session)this.httpSession;
                s.getSessionHandler().access((HttpSession)s, session.isSecure());
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 OutputStreamWriter writer = new OutputStreamWriter(baos);){
                BoxOp op = new BoxOp(this.acceptCx, session.isSecure(), this.remoteAddr);
                op.put("boxEventHandler", this.eventHandler);
                try {
                    AccessController.doPrivileged(() -> {
                        NiagaraWebSession nSession = WebSessionUtil.getSession((HttpSession)this.httpSession);
                        Subject subject = SessionManager.getAuthenticatedSubjectFromSession((String)nSession.getSuperId());
                        Subject.doAs(subject, () -> {
                            consumer.accept((Object)writer, (Object)op);
                            return null;
                        });
                        return null;
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                ((Writer)writer).flush();
                byte[] data = baos.toByteArray();
                if (data.length > 0) {
                    this.send(data);
                }
            }
            catch (Exception e) {
                if (this.service.hasListeners()) {
                    this.service.notifyListeners(this.cx, e);
                }
                BBoxService.log.log(Level.SEVERE, BBoxService.makeLogMsg("Processing Web Socket Message", this.cx), e);
            }
        }

        @OnWebSocketError
        public void onError(org.eclipse.jetty.websocket.api.Session session, Throwable cause) {
            BoxWsHttpSessionListener.removeDestroyListener(this);
            if (this.service.hasListeners()) {
                this.service.notifyListeners(this.acceptCx, cause);
            }
            BBoxService.log.log(Level.SEVERE, BBoxService.makeLogMsg("BOX Web Socket Error", this.cx), cause);
        }

        @Override
        public void onHttpSessionDestroyed(HttpSession destroyedSession) {
            if (this.isOpen() && this.httpSession != null && destroyedSession.getId().equals(this.httpSession.getId())) {
                BoxWsHttpSessionListener.removeDestroyListener(this);
                this.close();
            }
        }

        private boolean isOpen() {
            return this.session != null && this.session.isOpen();
        }

        private void send(byte[] data) throws IOException {
            if (this.session != null) {
                if (WebDev.get((String)"bajaScript").isEnabled()) {
                    this.session.getRemote().sendStringByFuture(new String(data, StandardCharsets.UTF_8));
                } else {
                    this.session.getRemote().sendBytesByFuture(ByteBuffer.wrap(data));
                }
            } else {
                throw new IOException("Invalid Box Web Socket!");
            }
        }

        private void close() {
            if (this.session != null) {
                this.session.close();
            }
        }

        private URI getRequestURI() {
            if (this.session == null) {
                throw new IllegalStateException();
            }
            return this.session.getUpgradeRequest().getRequestURI();
        }

        private boolean isCrossOrigin(HttpServletRequest httpReq, URI wsRequestURI) {
            boolean isCrossOriginWsRequest = false;
            try {
                URI wsOrigin;
                String wsHost = wsRequestURI.getHost();
                int wsPort = wsRequestURI.getPort();
                String originHeader = httpReq.getHeader("origin");
                if (null == originHeader || "null".equals(originHeader)) {
                    isCrossOriginWsRequest = true;
                }
                if (!BoxWebSocket.isSchemeValid((wsOrigin = new URI(originHeader)).getScheme(), httpReq) || !wsHost.equals(wsOrigin.getHost()) || wsPort != wsOrigin.getPort()) {
                    isCrossOriginWsRequest = true;
                }
            }
            catch (URISyntaxException uEx) {
                isCrossOriginWsRequest = true;
            }
            return isCrossOriginWsRequest;
        }

        private static boolean isSchemeValid(String wsScheme, HttpServletRequest request) {
            String secureSchemeMatcher = "^(wss|https)$";
            String inSecureSchemeMatcher = "^(ws|http)$";
            String reqScheme = request.getScheme();
            return wsScheme.matches("^(ws|http)$") && reqScheme.matches("^(ws|http)$") || wsScheme.matches("^(wss|https)$") && reqScheme.matches("^(wss|https)$");
        }
    }

    private static final class WebSocketInfo {
        private final BAbsTime acceptTime = BAbsTime.now();
        private BAbsTime openTime = BAbsTime.NULL;
        private BAbsTime lastMessageTime = BAbsTime.NULL;
        private final BoxWebSocket socket;
        private final boolean isEncrypted;

        private WebSocketInfo(BoxWebSocket socket, boolean isEncrypted) {
            this.socket = socket;
            this.isEncrypted = isEncrypted;
        }
    }
}

