/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.terminal.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.seriestransform.graph.BNodeContainer;
import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.terminal.BTerminalMap;
import com.tridium.seriestransform.terminal.BTerminalMapping;
import com.tridium.seriestransform.terminal.BTerminalNode;
import com.tridium.seriestransform.terminal.ui.BTerminalConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
public class BTerminalBuilder
extends BConfigEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BTerminalBuilder.class);
    public static final Lexicon lex = Lexicon.make(BTerminalBuilder.class);
    public static final String DISPLAY_HEADER = lex.getText("outputSchemaEditor.schema");
    public static final String LEGACY_DISPLAY_HEADER = lex.getText("outputSchemaEditor.schemaForLegacyVersions");
    private static final int FIRST = 0;
    private static final int LAST = 1;
    private final List<BTerminalConfig> rows = new ArrayList<BTerminalConfig>();
    private BTerminalNode srcNode;
    private BTerminalMap fieldMap;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTerminalBuilder() {
    }

    public BTerminalBuilder(BTerminalNode node) {
        BFoxSession foxSession;
        Version remoteVersion;
        this.srcNode = node;
        this.srcNode.lease(2);
        this.fieldMap = this.srcNode.getMappings();
        String displayHeader = DISPLAY_HEADER;
        boolean hasTerminalNodeMappings = true;
        BISession session = this.srcNode.getSession();
        if (session instanceof BFoxSession && (remoteVersion = (foxSession = (BFoxSession)session).getConnection().getRemoteVersion()).compareTo(BNodeContainer.MINIMUM_NODE_MAPPINGS) < 0) {
            displayHeader = LEGACY_DISPLAY_HEADER;
            hasTerminalNodeMappings = false;
        }
        BWidget display = this.buildTableDisplay(displayHeader, null);
        this.setCenter(display);
        this.loadTerminalMaps(hasTerminalNodeMappings);
    }

    private void loadTerminalMaps(boolean hasTerminalMappings) {
        this.fieldMap.lease();
        BTerminalMapping[] children = (BTerminalMapping[])this.fieldMap.getChildren(BTerminalMapping.class);
        this.srcNode.lease();
        BSeriesSchema schema = this.srcNode.getSchema();
        schema.lease();
        if (!hasTerminalMappings) {
            BTerminalMap map = new BTerminalMap(schema);
            BSeriesSchema copy = (BSeriesSchema)schema.newCopy(true);
            BTerminalMapping[] mappings = (BTerminalMapping[])map.getChildren(BTerminalMapping.class);
            if (mappings.length > 0) {
                int i;
                Property[] reorder = new Property[mappings.length];
                for (i = 0; i < mappings.length; ++i) {
                    String name = mappings[i].getElementName();
                    reorder[i] = copy.getProperty(name);
                }
                copy.reorder(reorder);
                for (i = 0; i < mappings.length; ++i) {
                    BTerminalMapping mapping = mappings[i];
                    this.makeNodeSchemaRows(schema, mapping, i, mappings.length);
                }
            }
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            BTerminalMapping mapping = children[i];
            this.makeNodeSchemaRows(schema, mapping, i, children.length);
        }
    }

    private void makeNodeSchemaRows(BSeriesSchema schema, BTerminalMapping mapping, int position, int terminalMapCount) {
        mapping.lease();
        String elementName = mapping.getElementName();
        String typeName = mapping.getTypeName();
        BFacets fieldFacets = schema.getFieldFacets(elementName);
        String facetStr = "";
        try {
            facetStr = fieldFacets.toString((Context)fieldFacets);
        }
        catch (RuntimeException re) {
            log.log(Level.SEVERE, "Failed to obtain facets String (" + re + ")", re);
        }
        if (position == 0) {
            this.makeConfig(elementName, typeName, facetStr, 0);
        } else if (position == terminalMapCount - 1) {
            this.makeConfig(elementName, typeName, facetStr, 1);
        } else {
            this.makeConfig(elementName, typeName, facetStr);
        }
    }

    private void makeConfig(String elementName, String typeName, String facetDesc) {
        this.makeConfig(elementName, typeName, facetDesc, -1);
    }

    private void makeConfig(String elementName, String typeName, String facetDesc, int position) {
        BTerminalConfig config = new BTerminalConfig(elementName, typeName, facetDesc);
        this.showConfig(config, position);
    }

    private void showConfig(BTerminalConfig config, int position) {
        this.rows.add(config);
        MoveElementDownCmd cmdDown = new MoveElementDownCmd((BWidget)this, config);
        MoveElementUpCmd cmdUp = new MoveElementUpCmd((BWidget)this, config);
        switch (position) {
            case 0: {
                cmdUp.setEnabled(false);
                break;
            }
            case 1: {
                cmdDown.setEnabled(false);
                break;
            }
        }
        this.addConfig(config, new Command[]{cmdDown, cmdUp});
    }

    public BTerminalMap getTerminalMappings() {
        this.fieldMap.removeAll();
        for (BTerminalConfig config : this.rows) {
            String elementName = config.getElementName();
            String typeName = config.getTypeName();
            BTerminalMapping mapping = new BTerminalMapping(elementName, typeName);
            this.fieldMap.add(null, (BValue)mapping);
        }
        return this.fieldMap;
    }

    private class MoveElementDownCmd
    extends Command {
        BTerminalConfig config;

        public MoveElementDownCmd(BWidget owner, BTerminalConfig config) {
            super(owner, "");
            this.config = config;
        }

        public CommandArtifact doInvoke() throws Exception {
            int targetIndex = BTerminalBuilder.this.rows.indexOf((Object)this.config);
            if (targetIndex == BTerminalBuilder.this.rows.size() - 1 || targetIndex == -1) {
                return null;
            }
            List<Object> mappings = Arrays.asList(BTerminalBuilder.this.fieldMap.getChildren(BTerminalMapping.class));
            if (targetIndex < 0 || targetIndex >= mappings.size()) {
                return null;
            }
            BTerminalMapping temp = (BTerminalMapping)mappings.get(targetIndex);
            mappings.set(targetIndex, mappings.get(targetIndex + 1));
            mappings.set(targetIndex + 1, temp);
            BTerminalBuilder.this.fieldMap.removeAll();
            BTerminalBuilder.this.fieldMap = new BTerminalMap(mappings);
            BTerminalConfig nextConfig = (BTerminalConfig)((Object)BTerminalBuilder.this.rows.get(targetIndex + 1));
            String elementName = this.config.getElementName();
            String typeName = this.config.getTypeName();
            String facetDesc = this.config.getFacetDesc();
            this.config.setLabels(nextConfig.getElementName(), nextConfig.getTypeName(), nextConfig.getFacetDesc());
            nextConfig.setLabels(elementName, typeName, facetDesc);
            BTerminalBuilder.this.setModified();
            return null;
        }

        public BImage getIcon() {
            return BConfigEditor.moveDownIcon;
        }
    }

    private class MoveElementUpCmd
    extends Command {
        BTerminalConfig config;

        public MoveElementUpCmd(BWidget owner, BTerminalConfig config) {
            super(owner, "");
            this.config = config;
        }

        public CommandArtifact doInvoke() throws Exception {
            int targetIndex = BTerminalBuilder.this.rows.indexOf((Object)this.config);
            if (targetIndex == 0 || targetIndex == -1) {
                return null;
            }
            List<Object> mappings = Arrays.asList(BTerminalBuilder.this.fieldMap.getChildren(BTerminalMapping.class));
            if (targetIndex >= mappings.size()) {
                return null;
            }
            BTerminalMapping temp = (BTerminalMapping)mappings.get(targetIndex);
            mappings.set(targetIndex, mappings.get(targetIndex - 1));
            mappings.set(targetIndex - 1, temp);
            BTerminalBuilder.this.fieldMap.removeAll();
            BTerminalBuilder.this.fieldMap = new BTerminalMap(mappings);
            BTerminalConfig nextConfig = (BTerminalConfig)((Object)BTerminalBuilder.this.rows.get(targetIndex - 1));
            String elementName = this.config.getElementName();
            String typeName = this.config.getTypeName();
            String facetDesc = this.config.getFacetDesc();
            this.config.setLabels(nextConfig.getElementName(), nextConfig.getTypeName(), nextConfig.getFacetDesc());
            nextConfig.setLabels(elementName, typeName, facetDesc);
            BTerminalBuilder.this.setModified();
            return null;
        }

        public BImage getIcon() {
            return BConfigEditor.moveUpIcon;
        }
    }
}

