/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.source.ui;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.graph.ui.BFormatOrdFE;
import com.tridium.seriestransform.interval.BSeriesInterval;
import com.tridium.seriestransform.interval.ui.BSeriesIntervalFE;
import com.tridium.seriestransform.schema.ui.BNodeSchemaFE;
import com.tridium.seriestransform.source.BHistorySourceNode;
import com.tridium.seriestransform.source.ui.BHistoryDateRangeFE;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.popup.BIPopupEditor;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:HistorySourceNode"})})
@NiagaraAction(name="sourceChanged")
public class BHistoryPE
extends BWbEditor
implements BIPopupEditor {
    @Generated
    public static final Action sourceChanged = BHistoryPE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryPE.class);
    private static final Lexicon lex = Lexicon.make(BHistoryPE.class);
    private static final String LBL_SRC = lex.getText("sourceIPE.datasource");
    private static final String LBL_INTERVAL = lex.getText("sourceIPE.intervalFE");
    private static final String LBL_RANGE = lex.getText("sourceIPE.range");
    private static final String TITLE_CONFIG = lex.getText("sourceIPE.title.config");
    private static final String TITLE_SCHEMA = lex.getText("sourceIPE.title.schema");
    private BHistorySourceNode src;
    private final BSeriesIntervalFE intervalFE = new BSeriesIntervalFE();
    private final BFormatOrdFE dataSrcFE = new BFormatOrdFE();
    private final BNodeSchemaFE schemaFE = new BNodeSchemaFE();
    private final BHistoryDateRangeFE timeRangeEd = new BHistoryDateRangeFE();

    @Generated
    public void sourceChanged() {
        this.invoke(sourceChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWbEditor getEditor() {
        return this;
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.src = (BHistorySourceNode)value;
        this.src.lease(3);
        BSeriesSchema srcSchema = this.src.getSrcSchema();
        this.schemaFE.loadValue((BObject)srcSchema, context);
        BFormat dataSource = this.src.getDataSource();
        this.dataSrcFE.loadValue((BObject)dataSource, context);
        BDynamicTimeRange dateRange = this.src.getDateRange();
        this.timeRangeEd.loadValue((BObject)dateRange, context);
        this.linkTo((BComponent)this.dataSrcFE, (Slot)BWbPlugin.setModified, (Slot)setModified);
        this.linkTo((BComponent)this.dataSrcFE, (Slot)BWbPlugin.setModified, (Slot)sourceChanged);
        this.linkTo((BComponent)this.intervalFE, (Slot)BWbPlugin.setModified, (Slot)setModified);
        this.linkTo((BComponent)this.timeRangeEd, (Slot)BWbPlugin.setModified, (Slot)setModified);
        BSeriesInterval quantInterval = this.src.getQuantInterval();
        this.intervalFE.loadValue((BObject)quantInterval);
        BPane configTitle = BConfigEditor.makeSubTitle(TITLE_CONFIG, null);
        BPane schemaTitle = BConfigEditor.makeSubTitle(TITLE_SCHEMA, null);
        BLabel dateRangeLbl = new BLabel(LBL_RANGE);
        dateRangeLbl.setValign(BValign.top);
        BGridPane configPane = new BGridPane(2);
        configPane.add(null, (BValue)new BLabel(LBL_SRC));
        configPane.add(null, (BValue)this.dataSrcFE);
        configPane.add(null, (BValue)new BLabel(LBL_INTERVAL));
        configPane.add(null, (BValue)this.intervalFE);
        configPane.add(null, (BValue)dateRangeLbl);
        configPane.add(null, (BValue)this.timeRangeEd);
        configPane.setRowGap(5.0);
        configPane.setColumnGap(10.0);
        BGridPane displayPane = new BGridPane(1);
        displayPane.add(null, (BValue)configTitle);
        displayPane.add(null, (BValue)configPane);
        displayPane.add(null, (BValue)schemaTitle);
        displayPane.add(null, (BValue)new BBorderPane((BWidget)this.schemaFE, 10.0, 20.0, 0.0, 70.0));
        displayPane.setStretchColumn(0);
        displayPane.setColumnAlign(BHalign.fill);
        BConstrainedPane cp = new BConstrainedPane((BWidget)displayPane);
        cp.setMaxWidth(350.0);
        this.setContent((BWidget)cp);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BFormat oldSrcFormat;
        BSeriesSchema oldSrcSchema;
        this.src.lease(3);
        BSeriesSchema newSrcSchema = (BSeriesSchema)this.schemaFE.saveValue(cx);
        BSeriesInterval quantInterval = this.src.getQuantInterval();
        BFormat format = (BFormat)this.dataSrcFE.saveValue();
        this.intervalFE.saveValue((BObject)quantInterval, cx);
        BDynamicTimeRange range = (BDynamicTimeRange)this.timeRangeEd.saveValue();
        BSeriesInterval oldInterval = this.src.getQuantInterval();
        if (!oldInterval.equivalent((Object)quantInterval)) {
            this.src.setQuantInterval((BSeriesInterval)quantInterval.newCopy(true));
        }
        if (!(oldSrcSchema = this.src.getSchema()).equivalent((Object)newSrcSchema)) {
            this.src.setSrcSchema((BSeriesSchema)newSrcSchema.newCopy(true));
        }
        if (!(oldSrcFormat = this.src.getDataSource()).equals((Object)format)) {
            this.src.setDataSource(format);
        }
        this.src.setDateRange(range);
        return this.src;
    }

    protected void doSetReadonly(boolean readonly) {
        this.dataSrcFE.setEnabled(!readonly);
        this.schemaFE.setEnabled(!readonly);
        this.intervalFE.setEnabled(!readonly);
        this.timeRangeEd.setEnabled(!readonly);
    }

    public void doSourceChanged() {
        try {
            BFormat format = (BFormat)this.dataSrcFE.saveValue();
            String ordStr = format.getFormat();
            try {
                BOrd dataOrd = BOrd.make((String)ordStr);
                this.schemaFE.loadFromSource(dataOrd);
            }
            catch (Exception e) {
                this.schemaFE.loadFromSource(BOrd.NULL);
            }
        }
        catch (CannotSaveException format) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

