/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.scale.ui;

import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.seriestransform.scale.BScaleFactor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.commands.InsertText;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="scaleFactor", type="BScaleFactor", defaultValue="new BScaleFactor()")
@NiagaraAction(name="setFactor")
public class BScaleFactorConfiguration
extends BConfigItem {
    @Generated
    public static final Property scaleFactor = BScaleFactorConfiguration.newProperty((int)0, (BValue)new BScaleFactor(), null);
    @Generated
    public static final Action setFactor = BScaleFactorConfiguration.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BScaleFactorConfiguration.class);
    private static final Lexicon lex = Lexicon.make(BScaleFactorConfiguration.class);
    private static final String KEY_NAN_DISPLAY = "scale.invalidfactor";
    private final BTextField factorField = new BTextField("1", 10);

    @Generated
    public BScaleFactor getScaleFactor() {
        return (BScaleFactor)this.get(scaleFactor);
    }

    @Generated
    public void setScaleFactor(BScaleFactor v) {
        this.set(scaleFactor, (BValue)v, null);
    }

    @Generated
    public void setFactor() {
        this.invoke(setFactor, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BScaleFactorConfiguration() {
    }

    public BScaleFactorConfiguration(BScaleFactor factor) {
        String colName = factor.getInputFieldName();
        double scaleFactor = factor.getFactor();
        this.setScaleFactor((BScaleFactor)factor.newCopy(true));
        Double check = scaleFactor;
        if (check.isNaN()) {
            this.factorField.setText(lex.get(KEY_NAN_DISPLAY));
        } else {
            this.factorField.setText(String.valueOf(scaleFactor));
        }
        this.factorField.setController((TextController)new NumericTextValidator());
        BConstrainedPane p = new BConstrainedPane((BWidget)new BLabel(colName));
        p.setMinWidth(200.0);
        this.setLeft((BWidget)p);
        this.setRight((BWidget)this.factorField);
        this.linkTo((BComponent)this.factorField, (Slot)BTextEditor.textModified, (Slot)modified);
        this.linkTo((BComponent)this.factorField, (Slot)BTextEditor.textModified, (Slot)setFactor);
    }

    public void setEnabled(boolean enabled) {
        this.factorField.setEnabled(enabled);
    }

    public void doSetFactor() {
        BScaleFactor scaleFactor = this.getScaleFactor();
        String text = this.factorField.getText();
        try {
            Double d = Double.valueOf(text);
            scaleFactor.setFactor(d.doubleValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static class NumericTextValidator
    extends TextController {
        private static final char BACKSPACE = '\b';
        private static final char TAB = '\t';
        private static final char NEWLINE = '\n';
        private static final char ESCAPE = '\u001b';
        private static final char DELETE = '\u007f';
        private static final char ZERO = '0';
        private static final char ONE = '1';
        private static final char TWO = '2';
        private static final char THREE = '3';
        private static final char FOUR = '4';
        private static final char FIVE = '5';
        private static final char SIX = '6';
        private static final char SEVEN = '7';
        private static final char EIGHT = '8';
        private static final char NINE = '9';
        private static final char PERIOD = '.';
        private static final char MINUS = '-';

        private NumericTextValidator() {
        }

        public void keyTyped(BKeyEvent event) {
            boolean valid;
            String text;
            char key = event.getKeyChar();
            if (event.isControlDown() || event.isAltDown()) {
                return;
            }
            event.consume();
            if (key == '\b' || key == '\t' || key == '\u001b' || key == '\u007f' || key == '\n') {
                return;
            }
            switch (key) {
                case '.': {
                    text = this.getEditor().getText();
                    int index = text.indexOf(46);
                    valid = index < 0;
                    break;
                }
                case '-': {
                    text = this.getEditor().getText();
                    valid = text.isEmpty();
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    valid = true;
                    break;
                }
                default: {
                    valid = false;
                }
            }
            if (valid) {
                text = String.valueOf(key);
                new InsertText(this.getEditor(), text).invoke();
            }
        }
    }
}

