/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.graph.ui;

import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.ui.BRoundedPopup;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.propsheet.BPropertySheet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="setModified"), @NiagaraAction(name="enableSave", parameterType="BBoolean", defaultValue="BBoolean.make(true)"), @NiagaraAction(name="validateConfig")})
@NiagaraTopic(name="validateEvent", eventType="BBoolean")
public abstract class BConfigEditor
extends BEdgePane {
    @Generated
    public static final Action setModified = BConfigEditor.newAction((int)0, null);
    @Generated
    public static final Action enableSave = BConfigEditor.newAction((int)0, (BValue)BBoolean.make((boolean)true), null);
    @Generated
    public static final Action validateConfig = BConfigEditor.newAction((int)0, null);
    @Generated
    public static final Topic validateEvent = BConfigEditor.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BConfigEditor.class);
    private static final Lexicon lex = Lexicon.make(BConfigEditor.class);
    public static final Logger log = Logger.getLogger("seriesTransformUI");
    private static final String ICON_REMOVE_CMD = "cmd.remove.icon";
    private static final String ICON_ADD_CMD = "cmd.add.icon";
    private static final String ICON_EDIT_CMD = "cmd.edit.icon";
    private static final String ICON_KEY_CMD = "cmd.setKey.icon";
    private static final String ICON_AUTO_CMD = "cmd.auto.icon";
    private static final String ICON_UP_CMD = "cmd.moveup.icon";
    private static final String ICON_DOWN_CMD = "cmd.movedown.icon";
    protected static final BImage addIcon = BImage.make((String)lex.getText("cmd.add.icon"));
    protected static final BImage keyIcon = BImage.make((String)lex.getText("cmd.setKey.icon"));
    protected static final BImage minusIcon = BImage.make((String)lex.getText("cmd.remove.icon"));
    public static final BImage populateDefaults = BImage.make((String)lex.getText("cmd.auto.icon"));
    public static final BImage editIcon = BImage.make((String)lex.getText("cmd.edit.icon"));
    public static final BImage moveUpIcon = BImage.make((String)lex.getText("cmd.moveup.icon"));
    public static final BImage moveDownIcon = BImage.make((String)lex.getText("cmd.movedown.icon"));
    protected static final BInsets insets = BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0);
    private static final int DISPLAY_TITLE_BG_COLOR = 0x666666;
    public static final BImage IMG_BLANK = BImage.make((BIcon)BIcon.std((String)"blank.png"));
    public static final BImage IMG_WARNING = BImage.make((BIcon)BIcon.std((String)"warning.png"));
    protected BGridPane configDisplayPane;
    private final BGridPane msgDisplayPane = new BGridPane(1);
    protected Map<BConfigItem, Property> configRows = new HashMap<BConfigItem, Property>();
    private Command[] cmds;

    @Generated
    public void setModified() {
        this.invoke(setModified, null, null);
    }

    @Generated
    public void enableSave(BBoolean parameter) {
        this.invoke(enableSave, (BValue)parameter, null);
    }

    @Generated
    public void validateConfig() {
        this.invoke(validateConfig, null, null);
    }

    @Generated
    public void fireValidateEvent(BBoolean event) {
        this.fire(validateEvent, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BConfigEditor() {
        this.linkTo((BComponent)this, (Slot)validateEvent, (Slot)enableSave);
        this.setBottom((BWidget)this.msgDisplayPane);
    }

    public void doSetReadonly(boolean readonly) {
        if (null != this.cmds && this.cmds.length > 0) {
            for (Command cmd : this.cmds) {
                cmd.setEnabled(!readonly);
            }
        }
        Set<BConfigItem> configs = this.configRows.keySet();
        for (BConfigItem config : configs) {
            config.setEnabled(!readonly);
        }
    }

    protected BWidget buildTableDisplay(String title, Command[] commands) {
        if (null == title) {
            title = "";
        }
        BPane subTitle = BConfigEditor.makeSubTitle(title, commands);
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowGap(0.0);
        grid.add(null, (BValue)subTitle);
        this.configDisplayPane = grid;
        BScrollPane scroll = new BScrollPane((BWidget)grid);
        scroll.setViewportBackground(Theme.pane().getControlBackground());
        return this.makeInset((BWidget)scroll);
    }

    public static BPane makeSubTitle(String title, Command[] commands) {
        BLabel label = new BLabel(title);
        label.setForeground(BColor.white.toBrush());
        label.setFont(Theme.widget().getBoldText());
        label.setHalign(BHalign.left);
        BGridPane g = new BGridPane(2);
        g.setColumnGap(5.0);
        g.add(null, (BValue)label);
        BEdgePane a = new BEdgePane();
        a.setLeft((BWidget)g);
        if (null != commands && commands.length > 0) {
            BGridPane buttons = new BGridPane(commands.length);
            for (Command command : commands) {
                buttons.add(null, (BValue)BConfigEditor.makeButton(command, BColor.make((int)0x666666)));
            }
            a.setRight((BWidget)buttons);
        }
        BBorderPane top = new BBorderPane((BWidget)a, BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
        top.setFill(BColor.make((int)0x666666).toBrush());
        return top;
    }

    public static BLabel makeNoteLabel(String text) {
        BFont facetFont = Theme.label().getBoldText();
        facetFont = BFont.make((BFont)facetFont, (int)2);
        BLabel label = new BLabel();
        label.setFont(facetFont);
        label.setStyleClasses("trace");
        label.setText(text);
        return label;
    }

    public void addConfig(BConfigItem conf, Command[] commands) {
        if (null == conf) {
            return;
        }
        this.linkTo((BComponent)conf, (Slot)BConfigItem.modified, (Slot)validateConfig);
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)conf);
        BEdgePane edge = new BEdgePane();
        edge.setLeft((BWidget)grid);
        BBorderPane pane = new BBorderPane((BWidget)edge, insets);
        pane.setBorder(BBorder.make((String)"top(groove)"));
        if (null != commands && commands.length > 0) {
            this.cmds = commands;
            BGridPane buttons = new BGridPane(commands.length);
            for (Command command : commands) {
                buttons.add(null, (BValue)BConfigEditor.makeButton(command, null));
            }
            edge.setRight((BWidget)buttons);
        }
        Property p = this.configDisplayPane.add(null, (BValue)pane);
        this.configRows.put(conf, p);
        this.resize();
    }

    public void removeAllConfigs() {
        BBorderPane[] confs;
        Set<BConfigItem> configs = this.configRows.keySet();
        for (BConfigItem configItem : configs) {
            BComponent parent = (BComponent)configItem.getParent();
            if (null == parent) continue;
            parent.remove((BComplex)configItem);
        }
        for (BBorderPane conf : confs = (BBorderPane[])this.configDisplayPane.getChildren(BBorderPane.class)) {
            if (!(conf.getContent() instanceof BConfigItem)) continue;
            this.configDisplayPane.remove((BComplex)conf);
        }
        this.configRows.clear();
    }

    public void removeConfig(BWidget conf) {
        Property p = this.configRows.get(conf);
        if (null != p) {
            this.configDisplayPane.remove(p);
            this.resize();
        }
    }

    public void computePreferredSize() {
        this.getCenter().computePreferredSize();
        double pw = this.getCenter().getPreferredWidth();
        double ph = this.getCenter().getPreferredHeight();
        this.setPreferredSize(pw, Math.min(ph, 450.0));
    }

    protected void resize() {
        if (this.getShell() instanceof BRoundedDialog) {
            BRoundedDialog dlg = (BRoundedDialog)this.getShell();
            Insets insets = UiEnv.get().getWindowInsets((BWindow)dlg);
            dlg.computePreferredSize();
            double h = dlg.getPreferredHeight() + insets.top + insets.bottom;
            double w = dlg.getPreferredWidth() + insets.left + insets.right;
            IRectGeom cur = dlg.getScreenBounds();
            dlg.setScreenBounds(cur.x(), cur.y(), w, h);
        }
    }

    public void setBottom(BWidget v) {
        if (v == this.msgDisplayPane) {
            super.setBottom(v);
        }
    }

    protected static BButton makeButton(Command cmd, BColor fill) {
        BButton b = new BButton(cmd);
        b.setButtonStyle(BButtonStyle.toolBar);
        if (fill != null) {
            b.setBackground(fill.toBrush());
        }
        return b;
    }

    protected BWidget makeInset(BWidget content) {
        BBorderPane pane = new BBorderPane(content, BBorder.make((String)"1px solid black"), BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        return new BBorderPane((BWidget)pane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
    }

    public void doSetModified() {
    }

    public void doEnableSave(BBoolean status) {
        if (null == status) {
            return;
        }
        for (BComponent parent = (BComponent)this.getParent(); null != parent; parent = (BComponent)parent.getParent()) {
            if (parent instanceof BPropertySheet) {
                BWbShell wbShell = BWbShell.getWbShell((BWidget)this);
                wbShell.getSaveCommand().setEnabled(status.getBoolean());
                break;
            }
            if (!(parent instanceof BRoundedPopup)) continue;
            BRoundedPopup d = (BRoundedPopup)parent;
            d.getOkButton().setEnabled(status.getBoolean());
            break;
        }
    }

    public final void doValidateConfig() {
        boolean isValid = this.doValidate();
        this.resize();
        this.fireValidateEvent(BBoolean.make((boolean)isValid));
    }

    public boolean doValidate() {
        return true;
    }
}

