/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions.ui;

import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.functions.ui.BFunctionList;
import com.tridium.seriestransform.graph.ui.BSchemaConfigItem;
import com.tridium.seriestransform.rollup.BRollupNode;
import java.util.HashMap;
import java.util.Map;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraAction(name="validate")
public class BFunctionMappingConf
extends BSchemaConfigItem {
    @Generated
    public static final Action validate = BFunctionMappingConf.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFunctionMappingConf.class);
    private static final String P_SELECTOR = "selector";
    private static final String P_FUNC = "function";
    private BFunctionList funcBox;
    private final Map<String, BSeriesSchema> schemaMap = new HashMap<String, BSeriesSchema>();
    private BGridPane pane;
    private BFunctionMapping mapping;
    private String keyField;

    @Generated
    public void validate() {
        this.invoke(validate, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFunctionMappingConf() {
    }

    public BFunctionMappingConf(BFunctionMapping mapping, BGraphNode src) {
        BGraphNode[] sources;
        boolean allowNonCumulativeFuncs = !(src instanceof BRollupNode);
        this.funcBox = new BFunctionList(allowNonCumulativeFuncs);
        this.linkTo((BComponent)this.funcBox, (Slot)BDropDown.valueModified, (Slot)modified);
        this.linkTo((BComponent)this.outputField, (Slot)BTextEditor.textModified, (Slot)modified);
        this.linkTo((BComponent)this, (Slot)modified, (Slot)validate);
        for (BGraphNode inputSrc : sources = src.getSources()) {
            BSeriesSchema schema = inputSrc.getSchema();
            this.schemaMap.put(inputSrc.getName(), schema);
        }
        BSeriesSchema schema = src.getSchema();
        schema.lease();
        this.keyField = schema.getKeyField();
        this.buildUI();
        this.updateDisplay(mapping);
    }

    private void buildUI() {
        this.pane = new BGridPane(4);
        this.pane.setHalign(BHalign.left);
        this.pane.add(null, (BValue)this.statusIcon);
        this.pane.add(P_SELECTOR, (BValue)this.outputField);
        this.pane.add(P_FUNC, (BValue)this.funcBox);
        this.setCenter((BWidget)this.pane);
    }

    private void updateDisplay(BFunctionMapping mapping) {
        this.mapping = mapping;
        mapping.lease();
        String name = mapping.getOutputField();
        String[] split = TextUtil.split((String)name, (char)'.');
        if (split.length > 0) {
            name = split[split.length - 1];
        }
        this.outputField.setText(SlotPath.unescape((String)name));
        BTypeSpec typeSpec = mapping.getFunctionTypeSpec();
        this.funcBox.setSelectedIndex(typeSpec);
        if (this.funcBox.getList().getSelectedIndex() == -1) {
            this.funcBox.getList().setSelectedIndex(0);
        }
    }

    public void doValidate() {
        String[] inputFields = this.mapping.getArgumentFields();
        if (inputFields.length == 0) {
            this.setDisplayWarningStatus(true);
            return;
        }
        BFacets facets = this.mapping.getFacets();
        BUnit outputUnits = (BUnit)facets.get("units", (BObject)BUnit.DEFAULT);
        BTypeSpec functionTypeSpec = this.mapping.getFunctionTypeSpec();
        BTransformFunction function = (BTransformFunction)functionTypeSpec.getInstance();
        Type[] argumentTypes = function.getArgumentTypes();
        for (String fieldName : inputFields) {
            if (fieldName.equals(this.keyField)) continue;
            String[] split = TextUtil.split((String)fieldName, (char)'.');
            String srcName = split[0];
            BSeriesSchema srcSchema = this.schemaMap.get(srcName);
            if (null == srcSchema) {
                this.setDisplayWarningStatus(true);
                return;
            }
            srcSchema.lease();
            BTypeSpec fieldType = srcSchema.getFieldType(split[1]);
            if (null == fieldType || !BFunctionMappingConf.isValidArgType(argumentTypes, fieldType.getResolvedType())) {
                this.setDisplayWarningStatus(true);
                return;
            }
            BFacets fieldFacets = srcSchema.getFieldFacets(split[1]);
            BUnit fieldUnits = (BUnit)fieldFacets.get("units", (BObject)BUnit.DEFAULT);
            if (fieldUnits.equals((Object)BUnit.DEFAULT) || !outputUnits.equals((Object)BUnit.DEFAULT)) continue;
            this.setDisplayWarningStatus(true);
            return;
        }
        this.setDisplayWarningStatus(false);
    }

    public static boolean isValidArgType(Type[] paramTypes, Type argType) {
        for (Type paramType : paramTypes) {
            if (!argType.is(paramType)) continue;
            return true;
        }
        return false;
    }

    public void setFunctionMapping(BFunctionMapping mapping) {
        this.updateDisplay(mapping);
    }

    public BFunctionMapping saveMapping() {
        this.mapping.setOutputField(this.getOutputField());
        this.mapping.setFunctionTypeSpec((BTypeSpec)this.funcBox.getSelectedItem());
        return this.mapping;
    }
}

