/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.composite.ui;

import com.tridium.seriestransform.composite.BCompositeMap;
import com.tridium.seriestransform.composite.BCompositeMapping;
import com.tridium.seriestransform.composite.BCompositeNode;
import com.tridium.seriestransform.composite.ui.BCompositeConfig;
import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.seriestransform.graph.ui.BSchemaConfigEditor;
import com.tridium.seriestransform.source.BHistorySourceNode;
import com.tridium.seriestransform.terminal.ui.BTerminalConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;

@NiagaraType
public class BCompositeBuilder
extends BSchemaConfigEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BCompositeBuilder.class);
    public static final Lexicon lex = Lexicon.make(BCompositeBuilder.class);
    public static final String DISPLAY_HEADER = lex.getText("outputSchemaEditor.schema");
    private static final String ERR_MISMATCHED_KEYS = lex.getText("fault.msg.schema.invalidkeys");
    private static final Command[] EMPTY_COMMANDS = new Command[0];
    private final Set<String> outputFields = new HashSet<String>();
    private BGraphNode srcNode;
    private String[] inputFields;
    private BCompositeMap compositeMap;
    private boolean readonly;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BCompositeMap open(BWidget owner, BCompositeNode node) {
        return BCompositeBuilder.open(owner, node, false);
    }

    public static BCompositeMap open(BWidget owner, BCompositeNode node, boolean readonly) {
        if (null == node) {
            return null;
        }
        BCompositeBuilder builder = new BCompositeBuilder(node);
        builder.setReadonly(readonly);
        int result = BRoundedDialog.open((BWidget)owner, (String)node.getDisplayName(null), (Object)((Object)builder), (int)3);
        if (result == 2) {
            return null;
        }
        return builder.getCompositeMappings();
    }

    public BCompositeBuilder() {
    }

    public BCompositeBuilder(BCompositeNode node) {
        this.srcNode = node;
        this.compositeMap = ((BCompositeNode)this.srcNode).getMappings();
        this.inputFields = this.getCompositeFields();
        BWidget display = this.buildTableDisplay(DISPLAY_HEADER, new Command[]{new PopulateDefaultsCmd((BWidget)this, this.srcNode), new AddMappingCmd((BWidget)this)});
        this.setCenter(display);
        this.createKeyDisplay();
        this.loadCompositeMaps();
    }

    private void createKeyDisplay() {
        BGraphNode[] sources = this.srcNode.getSources();
        String keyField = null;
        BFacets keyFacets = BFacets.DEFAULT;
        for (BGraphNode src : sources) {
            src.lease(3);
            BSeriesSchema srcSchema = src.getSchema();
            String schemaKey = srcSchema.getKeyField();
            BFacets schemaFacets = srcSchema.getFieldFacets(schemaKey);
            if (null == keyField) {
                keyField = schemaKey;
                keyFacets = schemaFacets;
                continue;
            }
            if (!keyField.equals(schemaKey)) {
                BGraphNode.log.severe(ERR_MISMATCHED_KEYS);
                continue;
            }
            keyFacets = BFacets.make((BFacets)keyFacets, (BFacets)schemaFacets);
        }
        if (keyField == null || this.outputFields.contains(keyField)) {
            return;
        }
        String note = "";
        if (null != keyFacets) {
            try {
                note = keyFacets.toString((Context)keyFacets);
            }
            catch (RuntimeException re) {
                log.log(Level.SEVERE, re.getMessage(), re);
            }
        }
        BTerminalConfig conf = new BTerminalConfig(keyField, keyField, note);
        this.outputFields.add(keyField);
        this.addConfig(conf, EMPTY_COMMANDS);
    }

    private void loadCompositeMaps() {
        BCompositeMapping[] children;
        this.compositeMap.lease(2);
        for (BCompositeMapping mapping : children = (BCompositeMapping[])this.compositeMap.getChildren(BCompositeMapping.class)) {
            String srcColumnName = mapping.getInputField();
            String inputCol = mapping.getSrcSeries() + "." + srcColumnName;
            String outputCol = SlotPath.unescape((String)mapping.getOutputField());
            BFacets fieldFacets = mapping.getFieldFacets();
            this.makeConfig(inputCol, outputCol, fieldFacets);
        }
        this.validateConfig();
    }

    private void makeConfig(String inputField, String outputField, BFacets fieldFacets) {
        BCompositeConfig config;
        if (null != outputField && this.outputFields.contains(outputField)) {
            return;
        }
        if (null != outputField && null != inputField) {
            config = new BCompositeConfig(this.inputFields, inputField, outputField, fieldFacets);
            this.outputFields.add(outputField);
        } else {
            config = new BCompositeConfig(this.inputFields);
        }
        this.linkTo((BComponent)config, (Slot)BConfigItem.modified, (Slot)setModified);
        this.showConfig(config);
    }

    private void showConfig(BCompositeConfig config) {
        this.rows.add(config);
        this.addConfig(config, new Command[]{new RemoveMappingCmd((BWidget)this, config)});
    }

    private String[] getCompositeFields() {
        BGraphNode[] sources;
        HashSet<String> srcFields = new HashSet<String>();
        for (BGraphNode src : sources = this.srcNode.getSources()) {
            String[] fieldNames;
            String srcNodeName = src.getName();
            BSeriesSchema nodeSchema = src.getSchema();
            String keyField = nodeSchema.getKeyField();
            for (String fieldName : fieldNames = nodeSchema.getFieldNames()) {
                if (fieldName.equals(keyField)) continue;
                String colName = srcNodeName + "." + fieldName;
                srcFields.add(colName);
            }
        }
        return srcFields.toArray(new String[0]);
    }

    public BCompositeMap getCompositeMappings() {
        BCompositeMap map = new BCompositeMap();
        for (BConfigItem item : this.rows) {
            BCompositeConfig config = (BCompositeConfig)item;
            String inputField = config.getInputField();
            String outputField = config.getOutputField();
            BFacets fieldFacets = config.getFieldFacets();
            String[] split = TextUtil.split((String)inputField, (char)'.');
            String srcNode = null;
            if (split.length > 1) {
                srcNode = split[0];
                inputField = split[1];
            }
            BCompositeMapping mapping = new BCompositeMapping();
            mapping.setInputField(inputField);
            mapping.setSrcSeries(srcNode);
            mapping.setOutputField(outputField);
            mapping.setFieldFacets(fieldFacets);
            map.add(null, (BValue)mapping);
        }
        return map;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        for (BConfigItem item : this.rows) {
            BCompositeConfig config = (BCompositeConfig)item;
            config.setReadonly(readonly);
        }
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    @Override
    public boolean doValidate() {
        boolean isValid = super.doValidate();
        if (isValid) {
            for (BConfigItem item : this.rows) {
                BCompositeConfig config = (BCompositeConfig)item;
                if (!config.getInvalidSrc()) continue;
                return false;
            }
        }
        return isValid;
    }

    private class PopulateDefaultsCmd
    extends Command {
        private final BGraphNode src;

        public PopulateDefaultsCmd(BWidget owner, BGraphNode src) {
            super(owner, "");
            this.src = src;
        }

        public CommandArtifact doInvoke() {
            String[] fields;
            BGraphNode[] inputSources;
            HashSet<String> selectedFields = new HashSet<String>();
            for (BConfigItem item : BCompositeBuilder.this.rows) {
                BGraphNode[] config = (BGraphNode[])item;
                String inputField = config.getInputField();
                selectedFields.add(inputField);
            }
            HashMap<String, BGraphNode> inputSrcNodes = new HashMap<String, BGraphNode>();
            for (BGraphNode node : inputSources = this.src.getSources()) {
                inputSrcNodes.put(node.getName(), node);
            }
            for (String field : fields = BCompositeBuilder.this.getCompositeFields()) {
                if (selectedFields.contains(field)) continue;
                String[] split = TextUtil.split((String)field, (char)'.');
                String srcName = split[0];
                String schemaField = split[1];
                BGraphNode srcNode = (BGraphNode)inputSrcNodes.get(srcName);
                srcNode.lease();
                BSeriesSchema schema = srcNode.getSchema();
                schema.lease();
                BFacets fieldFacets = schema.getFieldFacets(schemaField);
                String defaultFieldName = Optional.ofNullable(this.getOrigin(srcNode, schemaField)).orElse(srcName) + "_" + schemaField;
                BCompositeBuilder.this.makeConfig(field, defaultFieldName, fieldFacets);
                BCompositeBuilder.this.setModified();
            }
            return null;
        }

        private String getOrigin(BGraphNode src, String field) {
            while (true) {
                if (src instanceof BHistorySourceNode) {
                    BSeriesSchema schema = src.getSchema();
                    if (null == schema.get(field)) break;
                    return src.getName();
                }
                BGraphNode[] sources = src.getSources();
                if (sources.length != 1) break;
                src = sources[0];
            }
            return null;
        }

        public BImage getIcon() {
            return BConfigEditor.populateDefaults;
        }
    }

    private class RemoveMappingCmd
    extends Command {
        BCompositeConfig elem;

        public RemoveMappingCmd(BWidget owner, BCompositeConfig config) {
            super(owner, "");
            this.elem = config;
        }

        public BImage getIcon() {
            return minusIcon;
        }

        public CommandArtifact doInvoke() {
            BCompositeBuilder.this.rows.remove((Object)this.elem);
            BCompositeBuilder.this.removeConfig((BWidget)this.elem);
            BCompositeBuilder.this.setModified();
            String outputField = this.elem.getOutputField();
            BCompositeBuilder.this.outputFields.remove(outputField);
            BCompositeBuilder.this.validateConfig();
            return null;
        }
    }

    private class AddMappingCmd
    extends Command {
        public AddMappingCmd(BWidget owner) {
            super(owner, "");
        }

        public CommandArtifact doInvoke() throws Exception {
            BCompositeBuilder.this.makeConfig(null, null, BFacets.DEFAULT);
            BCompositeBuilder.this.setModified();
            return null;
        }

        public BImage getIcon() {
            return addIcon;
        }
    }
}

