/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.util;

import com.tridium.lonworks.xml.XEnumDef;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XNetVariable;
import com.tridium.lonworks.xml.XTypeDef;
import com.tridium.lonworks.xml.XUtil;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class SnvtUtil {
    public static BLonData getLonData(int snvtType, int size) {
        BLonData data = SnvtUtil.getLonData(snvtType);
        if (data != null) {
            return data;
        }
        return new BLonData(BLonByteArray.make(size), BLonElementQualifiers.make(BLonElementType.na, size), null);
    }

    public static BLonData getLonData(int snvtType) {
        return SnvtUtil.getLonData(snvtType, false);
    }

    public static BLonData getLonData(int snvtType, boolean diff) {
        XLonInterfaceFile standard = XUtil.getStandard();
        Vector<XTypeDef> types = standard.types;
        String typeScope = "0," + Integer.toString(snvtType);
        for (int i = 0; i < types.size(); ++i) {
            XTypeDef t = types.elementAt(i);
            if (t.isCpType() || !t.getTypeScope().equals(typeScope)) continue;
            BLonData ldata = t.getLonData(standard);
            if (diff) {
                SnvtUtil.makeDiff(ldata);
            }
            return ldata;
        }
        return null;
    }

    public static Object getStandard() {
        return XUtil.getStandard();
    }

    public static BLonData getLonData(Object xnv, Object root) {
        return XUtil.getLonDataNv((XNetVariable)xnv, (XLonInterfaceFile)root);
    }

    public static BLonEnum getStandardEnum(String enumType) {
        XLonInterfaceFile sxfile = XUtil.getStandard();
        XEnumDef ed = sxfile.resolveEnumDef(enumType);
        if (ed == null) {
            throw new RuntimeException("No enumType " + enumType);
        }
        return ed.getEnum();
    }

    private static void makeDiff(BLonData ld) {
        SlotCursor c = ld.getProperties();
        while (c.nextObject()) {
            Property p = c.property();
            Type typ = p.getType();
            if (typ.is(BLonPrimitive.TYPE)) {
                BFacets f = p.getFacets();
                BUnit u = (BUnit)f.get("units");
                if (!SnvtUtil.isTemp(u)) continue;
                ld.setFacets((Slot)p, SnvtUtil.makeNewUnits(f, SnvtUtil.makeTempDiff(u)));
                continue;
            }
            if (!typ.is(BLonData.TYPE)) continue;
            SnvtUtil.makeDiff((BLonData)c.get());
        }
    }

    private static final BUnit makeTempDiff(BUnit u) {
        return UnitDatabase.getUnit((String)(u.getUnitName() + " degrees"));
    }

    private static final boolean isTemp(BUnit u) {
        UnitDatabase.Quantity q = UnitDatabase.getDefault().getQuantity(u);
        return q.getName().equals("temperature");
    }

    private static final boolean isTempDiff(BUnit u) {
        UnitDatabase.Quantity q = UnitDatabase.getDefault().getQuantity(u);
        return q.getName().equals("temperature differential");
    }

    private static BFacets makeNewUnits(BFacets f, BUnit u) {
        BFacets newFacets = BFacets.makeRemove((BFacets)f, (String)"units");
        return BFacets.make((BFacets)newFacets, (String)"units", (BIDataValue)u);
    }
}

