/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BLonLong
extends BLonPrimitive
implements BINumeric {
    public static final BLonLong DEFAULT = new BLonLong(0L, false);
    public static final Type TYPE = Sys.loadType(BLonLong.class);
    private long value;
    private boolean invalid = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BLonLong make(long value, boolean b) {
        return new BLonLong(value, b);
    }

    private BLonLong(long value, boolean b) {
        this.value = value;
        this.invalid = b;
    }

    public long getLong() {
        return this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BLonLong) {
            return ((BLonLong)((Object)obj)).value == this.value;
        }
        return false;
    }

    public int compareTo(Object obj) {
        long a = this.value;
        long b = ((BNumber)obj).getLong();
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public String toString(Context context) {
        return this.encodeToString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeLong(this.value);
        out.writeBoolean(this.invalid);
    }

    public BObject decode(DataInput in) throws IOException {
        return BLonLong.make(in.readLong(), in.readBoolean());
    }

    public String encodeToString() {
        return BLonLong.encodeToString(this.value, this.invalid);
    }

    public static String encodeToString(long val, boolean invld) {
        return Long.toString(val) + (invld ? "/invalid" : "");
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            int pos = s.indexOf("/");
            if (pos < 0) {
                return BLonLong.make(Long.parseLong(s), false);
            }
            return BLonLong.make(Long.parseLong(s.substring(0, pos)), true);
        }
        catch (Throwable e) {
            throw new IOException("Invalid long: " + s);
        }
    }

    @Override
    public void toOutputStream(LonOutputStream out, BLonElementQualifiers e) {
        long val = this.value;
        if ((!e.hasInvalidValue() || this.value != e.getInvalidValueL()) && e.getOffset() > 0.0f) {
            val = (long)((float)val + e.getOffset());
        }
        switch (e.getElemtype().getOrdinal()) {
            case 5: {
                out.writeSigned32((int)val);
                break;
            }
            case 16: {
                out.writeUnsigned32(val);
                break;
            }
            case 18: {
                out.writeSigned64(val);
                break;
            }
            default: {
                throw new InvalidTypeException("Invalue id datatype for LonLong.");
            }
        }
    }

    @Override
    public BLonPrimitive fromInputStream(LonInputStream in, BLonElementQualifiers e) {
        long val;
        switch (e.getElemtype().getOrdinal()) {
            case 5: {
                val = in.readSigned32();
                break;
            }
            case 16: {
                val = in.readUnsigned32();
                break;
            }
            case 18: {
                val = in.readSigned64();
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonLong.");
            }
        }
        boolean invld = e.isInvalid(val);
        if (!invld && e.getOffset() > 0.0f) {
            val = (long)((float)val - e.getOffset());
        }
        if (this.value == val) {
            return this;
        }
        return BLonLong.make(val, invld);
    }

    @Override
    public double getDataAsDouble() {
        if (this.invalid) {
            return Double.NaN;
        }
        return this.value;
    }

    @Override
    public BLonPrimitive makeFromDouble(double value, BLonElementQualifiers e) {
        if (Double.isNaN(value) && e != null && e.hasInvalidValue()) {
            return BLonLong.make(e.getInvalidValueL(), true);
        }
        return BLonLong.make((long)value, false);
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public boolean getDataAsBoolean() {
        return this.value != 0L;
    }

    @Override
    public BLonPrimitive makeFromBoolean(boolean v) {
        return BLonLong.make(v ? 1L : 0L, false);
    }

    @Override
    public String getDataAsString() {
        return Long.toString(this.value);
    }

    @Override
    public BLonPrimitive makeFromString(String stringValue) {
        long i = 0L;
        try {
            i = Long.parseLong(stringValue);
        }
        catch (Throwable e) {
            return null;
        }
        return BLonLong.make(i, false);
    }

    public double getNumeric() {
        return this.getDataAsDouble();
    }

    public BFacets getNumericFacets() {
        return BFacets.NULL;
    }
}

