/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.datatypes;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAddressTable;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BExtAddressTable;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="neuronId", type="BNeuronId", defaultValue="BNeuronId.DEFAULT", flags=64), @NiagaraProperty(name="programId", type="BProgramId", defaultValue="BProgramId.DEFAULT", flags=8), @NiagaraProperty(name="nodeState", type="BLonNodeState", defaultValue="BLonNodeState.unknown", flags=64), @NiagaraProperty(name="subnetNodeId", type="BSubnetNode", defaultValue="BSubnetNode.DEFAULT", flags=65), @NiagaraProperty(name="location", type="String", defaultValue=""), @NiagaraProperty(name="authenticate", type="boolean", defaultValue="false"), @NiagaraProperty(name="channelId", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="workingDomain", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="bindingII", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="hosted", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="twoDomains", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="msgTagCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="addressCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="addressTable", type="BAddressTable", defaultValue="new BAddressTable()", flags=65), @NiagaraProperty(name="extAddressTable", type="BExtAddressTable", defaultValue="new BExtAddressTable()", flags=4), @NiagaraProperty(name="prioritySlot", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="aliasTable", type="BAliasTable", defaultValue="new BAliasTable()", flags=1), @NiagaraProperty(name="selfDoc", type="String", defaultValue=""), @NiagaraProperty(name="hasNodeObject", type="boolean", defaultValue="false"), @NiagaraProperty(name="freezeChannelPriorities", type="boolean", defaultValue="false"), @NiagaraProperty(name="lastHash", type="int", defaultValue="-1", flags=71), @NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.DEFAULT")})
public class BDeviceData
extends BComponent {
    @Generated
    public static final Property neuronId = BDeviceData.newProperty((int)64, (BValue)BNeuronId.DEFAULT, null);
    @Generated
    public static final Property programId = BDeviceData.newProperty((int)8, (BValue)BProgramId.DEFAULT, null);
    @Generated
    public static final Property nodeState = BDeviceData.newProperty((int)64, (BValue)BLonNodeState.unknown, null);
    @Generated
    public static final Property subnetNodeId = BDeviceData.newProperty((int)65, (BValue)BSubnetNode.DEFAULT, null);
    @Generated
    public static final Property location = BDeviceData.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property authenticate = BDeviceData.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property channelId = BDeviceData.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property workingDomain = BDeviceData.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property bindingII = BDeviceData.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property hosted = BDeviceData.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property twoDomains = BDeviceData.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property msgTagCount = BDeviceData.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property addressCount = BDeviceData.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property addressTable = BDeviceData.newProperty((int)65, (BValue)new BAddressTable(), null);
    @Generated
    public static final Property extAddressTable = BDeviceData.newProperty((int)4, (BValue)new BExtAddressTable(), null);
    @Generated
    public static final Property prioritySlot = BDeviceData.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property aliasTable = BDeviceData.newProperty((int)1, (BValue)new BAliasTable(), null);
    @Generated
    public static final Property selfDoc = BDeviceData.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property hasNodeObject = BDeviceData.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property freezeChannelPriorities = BDeviceData.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property lastHash = BDeviceData.newProperty((int)71, (int)-1, null);
    @Generated
    public static final Property facets = BDeviceData.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceData.class);
    private Object pickle = null;
    private static final BIcon icon = BIcon.std((String)"deviceData.png");
    public static final Context importChanges = new BasicContext();

    @Generated
    public BNeuronId getNeuronId() {
        return (BNeuronId)this.get(neuronId);
    }

    @Generated
    public void setNeuronId(BNeuronId v) {
        this.set(neuronId, (BValue)v, null);
    }

    @Generated
    public BProgramId getProgramId() {
        return (BProgramId)this.get(programId);
    }

    @Generated
    public void setProgramId(BProgramId v) {
        this.set(programId, (BValue)v, null);
    }

    @Generated
    public BLonNodeState getNodeState() {
        return (BLonNodeState)this.get(nodeState);
    }

    @Generated
    public void setNodeState(BLonNodeState v) {
        this.set(nodeState, (BValue)v, null);
    }

    @Generated
    public BSubnetNode getSubnetNodeId() {
        return (BSubnetNode)this.get(subnetNodeId);
    }

    @Generated
    public void setSubnetNodeId(BSubnetNode v) {
        this.set(subnetNodeId, (BValue)v, null);
    }

    @Generated
    public String getLocation() {
        return this.getString(location);
    }

    @Generated
    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    @Generated
    public boolean getAuthenticate() {
        return this.getBoolean(authenticate);
    }

    @Generated
    public void setAuthenticate(boolean v) {
        this.setBoolean(authenticate, v, null);
    }

    @Generated
    public int getChannelId() {
        return this.getInt(channelId);
    }

    @Generated
    public void setChannelId(int v) {
        this.setInt(channelId, v, null);
    }

    @Generated
    public int getWorkingDomain() {
        return this.getInt(workingDomain);
    }

    @Generated
    public void setWorkingDomain(int v) {
        this.setInt(workingDomain, v, null);
    }

    @Generated
    public boolean getBindingII() {
        return this.getBoolean(bindingII);
    }

    @Generated
    public void setBindingII(boolean v) {
        this.setBoolean(bindingII, v, null);
    }

    @Generated
    public boolean getHosted() {
        return this.getBoolean(hosted);
    }

    @Generated
    public void setHosted(boolean v) {
        this.setBoolean(hosted, v, null);
    }

    @Generated
    public boolean getTwoDomains() {
        return this.getBoolean(twoDomains);
    }

    @Generated
    public void setTwoDomains(boolean v) {
        this.setBoolean(twoDomains, v, null);
    }

    @Generated
    public int getMsgTagCount() {
        return this.getInt(msgTagCount);
    }

    @Generated
    public void setMsgTagCount(int v) {
        this.setInt(msgTagCount, v, null);
    }

    @Generated
    public int getAddressCount() {
        return this.getInt(addressCount);
    }

    @Generated
    public void setAddressCount(int v) {
        this.setInt(addressCount, v, null);
    }

    @Generated
    public BAddressTable getAddressTable() {
        return (BAddressTable)this.get(addressTable);
    }

    @Generated
    public void setAddressTable(BAddressTable v) {
        this.set(addressTable, (BValue)v, null);
    }

    @Generated
    public BExtAddressTable getExtAddressTable() {
        return (BExtAddressTable)this.get(extAddressTable);
    }

    @Generated
    public void setExtAddressTable(BExtAddressTable v) {
        this.set(extAddressTable, (BValue)v, null);
    }

    @Generated
    public int getPrioritySlot() {
        return this.getInt(prioritySlot);
    }

    @Generated
    public void setPrioritySlot(int v) {
        this.setInt(prioritySlot, v, null);
    }

    @Generated
    public BAliasTable getAliasTable() {
        return (BAliasTable)this.get(aliasTable);
    }

    @Generated
    public void setAliasTable(BAliasTable v) {
        this.set(aliasTable, (BValue)v, null);
    }

    @Generated
    public String getSelfDoc() {
        return this.getString(selfDoc);
    }

    @Generated
    public void setSelfDoc(String v) {
        this.setString(selfDoc, v, null);
    }

    @Generated
    public boolean getHasNodeObject() {
        return this.getBoolean(hasNodeObject);
    }

    @Generated
    public void setHasNodeObject(boolean v) {
        this.setBoolean(hasNodeObject, v, null);
    }

    @Generated
    public boolean getFreezeChannelPriorities() {
        return this.getBoolean(freezeChannelPriorities);
    }

    @Generated
    public void setFreezeChannelPriorities(boolean v) {
        this.setBoolean(freezeChannelPriorities, v, null);
    }

    @Generated
    public int getLastHash() {
        return this.getInt(lastHash);
    }

    @Generated
    public void setLastHash(int v) {
        this.setInt(lastHash, v, null);
    }

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDeviceData() {
    }

    public BDeviceData(BProgramId pid) {
        this.setProgramId(pid);
    }

    public BDeviceData(BProgramId pid, boolean bindingII, boolean hosted, boolean twoDomains, int msgTagCount, int addressCount, int aliasCount, boolean hasNodeObject) {
        this.setProgramId(pid);
        this.setBindingII(bindingII);
        this.setHosted(hosted);
        this.setTwoDomains(twoDomains);
        this.setMsgTagCount(msgTagCount);
        this.setAddressCount(addressCount);
        if (aliasCount > 0) {
            this.setAliasTable(new BAliasTable(aliasCount));
        }
        this.setHasNodeObject(hasNodeObject);
    }

    public void changed(Property prop, Context context) {
        BComplex p;
        super.changed(prop, context);
        if (!this.isRunning() || context == importChanges) {
            return;
        }
        if (prop == facets) {
            this.pickle = null;
        }
        if ((p = this.getParent()) instanceof BLonDevice) {
            ((BLonDevice)p).deviceDataChanged(prop, context);
        }
        if (prop == neuronId || prop == programId || prop == nodeState || prop == subnetNodeId || prop == channelId) {
            NmUtil.getLonNetwork(this).addressManager().deviceDataChanged(this, context);
        }
        if (context == AddressManager.noDeviceChange || context == NAddressManager.localChange) {
            return;
        }
        if (this.getNeuronId().isZero()) {
            return;
        }
        Runnable req = null;
        if (prop == nodeState) {
            req = new Runnable(){

                @Override
                public void run() {
                    BDeviceData.this.updateNodeState();
                }
            };
        } else if (prop == subnetNodeId || prop == workingDomain) {
            req = new Runnable(){

                @Override
                public void run() {
                    BDeviceData.this.updateSubnetNodeId();
                }
            };
        }
        if (req != null) {
            NmUtil.getLonNetwork(this).postAsync(req);
        }
    }

    private void updateSubnetNodeId() {
        BComplex o = this.getParent();
        if (o instanceof BLonDevice) {
            BLonDevice dev = (BLonDevice)o;
            dev.updateDomainTable();
        }
    }

    private void updateNodeState() {
        boolean err = false;
        BComplex o = this.getParent();
        BLonNodeState nState = this.getNodeState();
        LonException cause = null;
        if (o instanceof BLonDevice) {
            BLonDevice dev = (BLonDevice)o;
            dev.updateNodeState();
        } else if (o instanceof BLonRouter) {
            BLonRouter rtr = (BLonRouter)o;
            try {
                NmUtil.setDeviceState(rtr, nState, true);
                NmUtil.setDeviceState(rtr, nState, false);
            }
            catch (LonException e) {
                err = true;
                cause = e;
            }
            rtr.getNearDeviceData().set(nodeState, (BValue)nState, AddressManager.noDeviceChange);
            rtr.getFarDeviceData().set(nodeState, (BValue)nState, AddressManager.noDeviceChange);
        }
        if (err) {
            throw new BajaRuntimeException("Unable to update state change in " + o.getDisplayName(null), (Throwable)((Object)cause));
        }
    }

    public void setPickle(Object o) {
        if (o instanceof DeviceFacets) {
            this.pickle = o;
        }
    }

    public Object getPickle() {
        return this.pickle;
    }

    public boolean isExtended() {
        return false;
    }

    public void clearAddressTable() {
        this.getAddressTable().clearTable();
    }

    public BIAddressEntry getAddressEntry(int index) {
        return this.getAddressTable().getAddressEntry(index);
    }

    public void setAddressEntry(int index, BIAddressEntry e) {
        this.getAddressTable().setAddressEntry(index, e);
    }

    public void setAddressEntry(int index, BIAddressEntry e, Context c) {
        this.getAddressTable().setAddressEntry(index, e, c);
    }

    public BIcon getIcon() {
        return icon;
    }
}

