/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.selfdoc.SelfDocUtil;
import java.util.logging.Level;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.datatypes.BNcProps;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ncProps", type="BNcProps", defaultValue="new BNcProps()"), @NiagaraProperty(name="nvConfigData", type="BNvConfigData", defaultValue="new BNvConfigData()")})
@NiagaraTopic(name="receivedUpdate")
public class BNetworkConfig
extends BLonComponent
implements BINetworkVariable {
    @Generated
    public static final Property ncProps = BNetworkConfig.newProperty((int)0, (BValue)new BNcProps(), null);
    @Generated
    public static final Property nvConfigData = BNetworkConfig.newProperty((int)0, (BValue)new BNvConfigData(), null);
    @Generated
    public static final Topic receivedUpdate = BNetworkConfig.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNetworkConfig.class);
    private static final BIcon icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/nci.png");

    @Generated
    public BNcProps getNcProps() {
        return (BNcProps)this.get(ncProps);
    }

    @Generated
    public void setNcProps(BNcProps v) {
        this.set(ncProps, (BValue)v, null);
    }

    @Override
    @Generated
    public BNvConfigData getNvConfigData() {
        return (BNvConfigData)this.get(nvConfigData);
    }

    @Override
    @Generated
    public void setNvConfigData(BNvConfigData v) {
        this.set(nvConfigData, (BValue)v, null);
    }

    @Generated
    public void fireReceivedUpdate(BValue event) {
        this.fire(receivedUpdate, event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNetworkConfig() {
    }

    public BNetworkConfig(int nvIndex, int snvtType, int configIndex, BModifyFlags modifyFlag, BLonConfigScope scope, String select, float[] init) {
        this(nvIndex, snvtType, configIndex, modifyFlag, scope, select);
        this.initDataElements(init);
    }

    public BNetworkConfig(int nvIndex, int snvtType, int configIndex, BModifyFlags modifyFlag, BLonConfigScope scope, String select) {
        BNcProps ncProps = this.getNcProps();
        ncProps.setNvIndex(nvIndex);
        ncProps.setSnvtType(snvtType);
        ncProps.setConfigIndex(configIndex);
        ncProps.setModifyFlag(modifyFlag);
        ncProps.setScope(scope);
        ncProps.setSelect(select);
        this.setData(SnvtUtil.getLonData(snvtType));
    }

    public BNetworkConfig(int nvIndex, BLonData data, int configIndex, BModifyFlags modifyFlag, BLonConfigScope scope, String select) {
        BNcProps ncProps = this.getNcProps();
        ncProps.setNvIndex(nvIndex);
        ncProps.setConfigIndex(configIndex);
        ncProps.setModifyFlag(modifyFlag);
        ncProps.setScope(scope);
        ncProps.setSelect(select);
        this.setData(data);
    }

    @Override
    public boolean isNetworkConfig() {
        return true;
    }

    @Override
    public int getNvIndex() {
        return this.getNcProps().getNvIndex();
    }

    @Override
    public void setNvIndex(int nvIndex) {
        this.getNcProps().setNvIndex(nvIndex);
    }

    @Override
    public int getSnvtType() {
        return this.getNcProps().getSnvtType();
    }

    @Override
    public void setUnbound() {
        this.getNcProps().setUnbound();
        this.getNvConfigData().setUnbound(this.getNvIndex());
    }

    @Override
    public void receiveUpdate(byte[] nvData) {
        try {
            this.getData().fromNetBytes(nvData);
            this.getData().readOk();
            this.fireReceivedUpdate(null);
        }
        catch (Throwable e) {
            this.getData().readFail(e.toString());
            this.lonNetwork().log().log(Level.SEVERE, "Could not decode nv update data " + this.getParent().getDisplayName(null) + ":" + this.getDisplayName(null), e);
        }
    }

    @Override
    public final void lonComponentStarted() {
        if (this.getNvConfigData().getSelector() == -1) {
            this.getNvConfigData().setUnbound(this.getNcProps().getNvIndex());
        }
    }

    @Override
    public boolean isForeignPersistent() {
        return true;
    }

    @Override
    public boolean isWriteable() {
        return !this.getNcProps().getModifyFlag().isMfgOnly();
    }

    @Override
    protected void dataChanged(Context context) {
        if (BLonNetwork.lonNoWrite.equals(context)) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        this.forceWrite();
    }

    @Override
    public void doForceRead() {
        this.lonDevice().checkState();
        if (this.illegalLength) {
            throw new BajaRuntimeException(this.getDisplayName(null) + " data length > maxNvLength of " + Lon.maxNvLength() + " bytes");
        }
        BNcProps ncProps = this.getNcProps();
        try {
            if (Lon.d()) {
                byte[] nvData = NmUtil.fetchNv(this.lonDevice(), ncProps.getNvIndex());
                this.getData().fromNetBytes(nvData);
            }
            this.getData().readOk();
        }
        catch (Throwable e) {
            this.getData().readFail(e.toString());
            String errMsg = "Unable to read " + this.debugName();
            this.lonNetwork().log().log(Level.SEVERE, errMsg, e);
            throw new BajaRuntimeException(errMsg + " " + e.getMessage(), e);
        }
    }

    @Override
    public void doForceWrite() {
        if (!Lon.d()) {
            return;
        }
        BNvConfigData configData = this.getNvConfigData();
        if (!configData.isInput()) {
            return;
        }
        BNcProps ncProps = this.getNcProps();
        if (ncProps.getModifyFlag().isMfgOnly()) {
            throw new BajaRuntimeException("Can not write mfgOnly nci " + this.getDisplayName(null));
        }
        BLonDevice dev = this.lonDevice();
        dev.checkState();
        if (this.illegalLength) {
            throw new BajaRuntimeException(this.getDisplayName(null) + " data length > maxNvLength of " + Lon.maxNvLength() + " bytes");
        }
        boolean downloading = dev.isDownLoadInProgress();
        try {
            int[] sels = null;
            boolean[] objDis = null;
            boolean onlineReq = false;
            if (!downloading) {
                dev.beginConfigWrite();
                if (ncProps.getModifyFlag().isOffline()) {
                    try {
                        NmUtil.setDeviceState(dev, BLonNodeState.configOffline);
                    }
                    catch (LonException e) {
                        System.out.println((Object)e);
                    }
                    onlineReq = true;
                }
                if (ncProps.getModifyFlag().isDisabled() && ncProps.getScope() == BLonConfigScope.object) {
                    sels = SelfDocUtil.selectToIntArray(ncProps.getSelect());
                    objDis = new boolean[sels.length];
                    dev.disableObjectsForWrite(sels, objDis);
                }
            }
            NmUtil.setNvValue(this.lonDevice(), configData, this.getData().toNetBytes());
            if (!downloading) {
                if (onlineReq) {
                    try {
                        NmUtil.setDeviceState(dev, BLonNodeState.configOnline);
                    }
                    catch (LonException e) {
                        System.out.println((Object)e);
                    }
                }
                if (sels != null) {
                    dev.enableObjectsAfterWrite(sels, objDis);
                }
                if (ncProps.getModifyFlag().isReset()) {
                    dev.doReset();
                }
                dev.endConfigWrite();
            }
            this.getData().writeOk();
        }
        catch (Throwable e) {
            this.getData().writeFail(e.toString());
            String errMsg = "Unable to write " + this.debugName();
            this.lonNetwork().log().log(Level.SEVERE, errMsg, e);
            throw new BajaRuntimeException(errMsg + " " + e.getMessage(), e);
        }
    }

    @Override
    protected void lonComponentSubscribed() {
        BBoolean bb = (BBoolean)this.getPropertyInParent().getFacets().get("deviceSpecific");
        if (bb != null && bb.getBoolean()) {
            this.forceRead();
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

