/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.selfdoc;

import java.util.StringTokenizer;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.nre.util.Array;

public class NvSelfDoc {
    public String selfDoc;
    public NvSelfDocData nv = null;
    public ConfigNvSelfDocData nvConfig = null;
    public boolean empty = false;
    private int version;
    public int dimension = 1;
    public Exception ex = null;

    public NvSelfDoc(String selfDoc) {
        this(selfDoc, 1);
    }

    public NvSelfDoc(String selfDoc, int version) {
        this.selfDoc = selfDoc;
        this.version = version;
        this.parseNvSelfDocumentation(selfDoc);
    }

    private void parseNvSelfDocumentation(String line) {
        boolean error;
        block31: {
            error = false;
            try {
                if (line.startsWith("*")) {
                    this.empty = true;
                    return;
                }
                int locationOfComment = line.indexOf(";");
                if (locationOfComment >= 0) {
                    line = line.substring(0, locationOfComment);
                }
                if (line.startsWith("\"")) {
                    line = line.substring(1, line.length());
                }
                if (line.startsWith("@")) {
                    this.nv = new NvSelfDocData();
                    this.nv.description = null;
                    String s = line.substring(1, line.length());
                    int suffixIndex = s.indexOf(59);
                    if (suffixIndex != -1) {
                        this.nv.description = s.substring(suffixIndex + 1);
                        s = s.substring(0, suffixIndex);
                    }
                    if (s.length() == 0) {
                        this.nv = null;
                        return;
                    }
                    try {
                        this.nv.mfgMember = s.indexOf(35) != -1;
                        this.nv.changeableType = s.indexOf(63) != -1;
                        StringTokenizer st = new StringTokenizer(s, "|#-?.[]");
                        this.nv.firstObjIndex = this.intToken(st);
                        if (s.indexOf(45) != -1) {
                            this.nv.lastObjIndex = this.intToken(st);
                        }
                        this.nv.memberNumber = this.intToken(st);
                        if (s.indexOf(91) != -1) {
                            this.nv.memberArraySize = this.intToken(st);
                        }
                        break block31;
                    }
                    catch (Exception e) {
                        System.out.println("warning : unable to parse selfdoc string " + s);
                        this.ex = e;
                    }
                    break block31;
                }
                if (line.startsWith("&")) {
                    this.nvConfig = new ConfigNvSelfDocData();
                    String s = line.substring(1, line.length());
                    int suffixIndex = s.indexOf(59);
                    if (suffixIndex != -1) {
                        this.nvConfig.description = s.substring(suffixIndex + 1);
                        s = s.substring(0, suffixIndex);
                    }
                    String[] toks = this.getTokenArray(s);
                    this.nvConfig.hdr = Integer.parseInt(toks[0]);
                    this.nvConfig.select = this.nvConfig.hdr == 0 ? "" : toks[1];
                    String flagText = toks[2];
                    this.nvConfig.typeScope = Integer.parseInt(flagText.substring(0, 1));
                    int pos = flagText.indexOf("x");
                    if (pos > 0) {
                        this.nvConfig.flg = flagText.length() > 3 ? Integer.parseInt(flagText.substring(pos + 1), 16) & 0xFF : flagText.getBytes()[1] & 0xFF;
                    } else if (flagText.length() == 2) {
                        this.nvConfig.flg = flagText.charAt(1);
                    } else {
                        System.out.println("*****\nUnable to parse flag " + flagText);
                        for (int i = 0; i < flagText.length(); ++i) {
                            System.out.print(Integer.toString(flagText.charAt(i), 16) + " ");
                        }
                        System.out.println("\n" + line + "\n*****");
                    }
                    this.nvConfig.configIndex = Integer.parseInt(toks[3]);
                    int tokndx = 4;
                    if (this.version >= 3) {
                        try {
                            if (toks.length > 4 && toks[4] != null) {
                                this.dimension = Integer.parseInt(toks[4]);
                            }
                            ++tokndx;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (toks.length > tokndx && toks[tokndx] != null) {
                        String rngMod = toks[tokndx];
                        if (rngMod.indexOf(124) >= 0) {
                            System.out.println("\nDetected unsupported structured member range modifiers " + rngMod);
                        } else {
                            int colPos = rngMod.indexOf(58);
                            if (colPos > 0) {
                                this.nvConfig.min = rngMod.substring(0, colPos);
                                this.nvConfig.minSpecified = true;
                            }
                            if (colPos < rngMod.length() - 1) {
                                this.nvConfig.max = rngMod.substring(colPos + 1);
                                this.nvConfig.maxSpecified = true;
                            }
                        }
                    }
                    if (toks.length > ++tokndx && toks[tokndx] != null) {
                        this.nvConfig.changeType = toks[tokndx].indexOf(63) >= 0;
                    }
                    break block31;
                }
                error = true;
            }
            catch (NumberFormatException e) {
                System.err.println("Number format exception occurred while parsing nv self doc." + e);
                e.printStackTrace();
                error = true;
            }
            catch (Throwable e) {
                error = true;
            }
        }
        if (error) {
            System.out.println("\nUnable to parse nv self documentation \"" + line);
            this.nv = null;
            this.nvConfig = null;
            this.empty = true;
        }
    }

    private int intToken(StringTokenizer st) {
        return Integer.parseInt(st.nextToken().trim());
    }

    String[] getTokenArray(String s) {
        Array a = new Array(String.class);
        int ndx = 0;
        int delimit = s.indexOf(",");
        while (ndx < s.length()) {
            if (ndx < delimit) {
                a.add((Object)s.substring(ndx, delimit));
            } else {
                a.add(null);
            }
            if ((delimit = s.indexOf(",", ndx = delimit + 1)) >= 0) continue;
            delimit = s.length();
        }
        return (String[])a.trim();
    }

    public boolean isNvDoc() {
        return this.nv != null;
    }

    public boolean isNciDoc() {
        return this.nvConfig != null;
    }

    public int getObjectIndex(int ndx) {
        if (this.nvConfig != null) {
            return this.nvConfig.getObjectIndex(ndx);
        }
        if (this.nv != null) {
            return this.nv.getObjectIndex(ndx);
        }
        return -1;
    }

    public String getObjectIndexString() {
        if (this.nvConfig != null) {
            return this.nvConfig.getObjectIndexString();
        }
        if (this.nv != null) {
            return this.nv.getObjectIndexString();
        }
        return "";
    }

    public int getMemberIndex(int ndx) {
        if (this.nv != null) {
            return this.nv.getMemberIndex(ndx);
        }
        return -1;
    }

    public int getPerObjectNvCount() {
        if (this.nv != null) {
            return this.nv.getPerObjectNvCount();
        }
        return 1;
    }

    public boolean isChangeableType() {
        if (this.nv != null) {
            return this.nv.changeableType;
        }
        return false;
    }

    public boolean isObjectArrayed() {
        if (this.nv != null) {
            return this.nv.isObjectArrayed();
        }
        if (this.nvConfig != null) {
            return this.nvConfig.isObjectArrayed();
        }
        return false;
    }

    public boolean isMfrMember() {
        if (this.nv != null) {
            return this.nv.mfgMember;
        }
        return false;
    }

    public int getConfigIndex() {
        if (this.nvConfig != null) {
            return this.nvConfig.configIndex;
        }
        return -1;
    }

    public BModifyFlags getModifyFlag() {
        if (this.nvConfig != null) {
            return BModifyFlags.fromFlags(this.nvConfig.flg);
        }
        return BModifyFlags.DEFAULT;
    }

    public BLonConfigScope getScope() {
        if (this.nvConfig != null) {
            return BLonConfigScope.make(this.nvConfig.hdr);
        }
        return BLonConfigScope.node;
    }

    public String getSelect() {
        if (this.nvConfig != null) {
            return this.nvConfig.select;
        }
        return "";
    }

    public String toString() {
        if (this.nv != null) {
            return this.nv.toString();
        }
        if (this.nvConfig != null) {
            return this.nvConfig.toString();
        }
        return "Uninitialized";
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public static class ConfigNvSelfDocData {
        public int hdr;
        public String select;
        int firstObjIndex;
        int lastObjIndex = 0;
        public int typeScope;
        public int flg;
        public int configIndex;
        public String min = "";
        public String max = "";
        public boolean minSpecified = false;
        public boolean maxSpecified = false;
        public boolean changeType = false;
        String description;

        public String getObjectIndexString() {
            return Integer.toString(this.firstObjIndex) + (this.lastObjIndex != 0 ? "-" + this.lastObjIndex : "");
        }

        public int getObjectIndex(int ndx) {
            if (this.lastObjIndex == 0) {
                return this.firstObjIndex;
            }
            return this.firstObjIndex + ndx;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SCPT : " + !this.isMfrDefined() + " typeScope=" + this.typeScope + "\n");
            sb.append("configIndex : " + this.configIndex + "\n");
            return sb.toString();
        }

        public boolean isObjectArrayed() {
            return this.lastObjIndex > this.firstObjIndex;
        }

        public boolean isMfrDefined() {
            return this.typeScope > 0;
        }
    }

    public static class NvSelfDocData {
        public boolean changeableType;
        public int firstObjIndex;
        public int lastObjIndex = 0;
        public int memberNumber;
        public int memberArraySize = 1;
        public boolean mfgMember;
        public String description;

        public int getObjectIndex(int ndx) {
            if (this.lastObjIndex == 0) {
                return this.firstObjIndex;
            }
            if (this.memberArraySize <= 1) {
                return this.firstObjIndex + ndx;
            }
            return this.firstObjIndex + ndx / this.memberArraySize;
        }

        public int getMemberIndex(int ndx) {
            if (this.memberArraySize <= 1) {
                return this.memberNumber;
            }
            if (this.lastObjIndex == 0) {
                return this.memberNumber + ndx;
            }
            int objArraySize = this.lastObjIndex - this.firstObjIndex + 1;
            return this.memberNumber + ndx % objArraySize;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ObjIndex : " + this.firstObjIndex);
            if (this.lastObjIndex != 0) {
                sb.append(" - " + this.lastObjIndex);
            }
            sb.append("\nmemberNumber : " + this.memberNumber + "\n");
            if (this.memberArraySize != 0) {
                sb.append("memberArraySize : " + this.memberArraySize + "\n");
            }
            sb.append("mfgMember : " + this.mfgMember + "\n");
            sb.append("description : " + this.description + "\n");
            return sb.toString();
        }

        public String getObjectIndexString() {
            return Integer.toString(this.firstObjIndex) + (this.lastObjIndex != 0 ? "-" + this.lastObjIndex : "");
        }

        public boolean isObjectArrayed() {
            return this.lastObjIndex > this.firstObjIndex;
        }

        public int getPerObjectNvCount() {
            return this.memberArraySize;
        }
    }
}

