/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.xml.XEnumDef;
import com.tridium.lonworks.xml.XTypeDef;
import java.io.InputStream;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class Conversion {
    UnitPrompt unitPrompt = null;
    public static final String UNMODIFIED = "???";
    private IntHashMap map = new IntHashMap(256);
    Vector<TypeClass> typeVect = new Vector();
    Vector<BooleanEnum> boolEnumVect = new Vector();
    Vector<Rename> enumDefRenameVect = new Vector();
    Vector<Rename> typeDefRenameVect = new Vector();
    BIFile ifile = null;
    private boolean modified = false;

    public Conversion(String fileName) {
        BOrd ord = BOrd.make((String)("file:" + fileName));
        this.ifile = (BIFile)ord.resolve().get();
        try {
            XParser p = XParser.make((InputStream)this.ifile.getInputStream());
            this.load(p);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Conversion(BIFile f) {
        this.ifile = f;
        try {
            XParser p = XParser.make((InputStream)this.ifile.getInputStream());
            this.load(p);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void flush() {
        if (!this.modified) {
            return;
        }
        try {
            this.doFlush(new XWriter(this.ifile.getOutputStream()));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String getConversionString(int scope, int index, String original) {
        int hashCode = this.getHash(scope, index);
        StringRec rec = (StringRec)this.map.get(hashCode);
        if (rec != null && rec.original.equals(original)) {
            if (!rec.newString.equals(UNMODIFIED)) {
                return rec.newString;
            }
        } else {
            rec = new StringRec();
            rec.scope = scope;
            rec.index = index;
            rec.original = original;
            rec.newString = this.unitPrompt != null ? this.unitPrompt.getUserString(scope, index, original) : UNMODIFIED;
            this.map.put(hashCode, (Object)rec);
            this.modified = true;
            return rec.newString;
        }
        return original;
    }

    public boolean isBooleanEnum(String name) {
        String ename = NameUtil.toJavaName(name, true);
        for (int i = 0; i < this.boolEnumVect.size(); ++i) {
            if (!this.boolEnumVect.elementAt((int)i).enumName.equals(ename)) continue;
            return true;
        }
        return false;
    }

    public void renameEnumDef(XEnumDef xenum) {
        String ename = xenum.getName();
        for (int i = 0; i < this.enumDefRenameVect.size(); ++i) {
            Rename ren = this.enumDefRenameVect.elementAt(i);
            if (!ren.name.equals(ename)) continue;
            int cnt = ren.origName.length;
            for (int j = 0; j < cnt; ++j) {
                xenum.rename(ren.origName[j], ren.newName[j]);
            }
        }
    }

    public void renameTypeDef(XTypeDef xtype) {
        String tname = xtype.getName();
        for (int i = 0; i < this.typeDefRenameVect.size(); ++i) {
            Rename ren = this.typeDefRenameVect.elementAt(i);
            if (!ren.name.equals(tname)) continue;
            int cnt = ren.origName.length;
            for (int j = 0; j < cnt; ++j) {
                xtype.rename(ren.origName[j], ren.newName[j]);
            }
        }
    }

    private void load(XParser p) throws Exception {
        Object rec;
        int i;
        XElem root = p.parse();
        XElem[] q = root.elems("resString");
        for (i = 0; i < q.length; ++i) {
            rec = new StringRec();
            ((StringRec)rec).scope = Integer.decode(q[i].get("scp"));
            ((StringRec)rec).index = Integer.decode(q[i].get("ndx"));
            ((StringRec)rec).original = q[i].get("org");
            ((StringRec)rec).newString = q[i].get("new");
            this.map.put(this.getHash(((StringRec)rec).scope, ((StringRec)rec).index), rec);
        }
        q = root.elems("typeSpec");
        for (i = 0; i < q.length; ++i) {
            rec = new TypeClass();
            ((TypeClass)rec).typeDef = q[i].get("typeDef");
            ((TypeClass)rec).bajaModule = q[i].get("bajaModule", null);
            ((TypeClass)rec).className = q[i].get("class");
            this.typeVect.addElement((TypeClass)rec);
        }
        q = root.elems("booleanEnum");
        for (i = 0; i < q.length; ++i) {
            rec = new BooleanEnum();
            ((BooleanEnum)rec).enumName = q[i].get("ename");
            this.boolEnumVect.addElement((BooleanEnum)rec);
        }
        q = root.elems("rename");
        for (i = 0; i < q.length; ++i) {
            String type = q[i].attrName(0);
            Rename ren = new Rename();
            ren.name = q[i].attrValue(0);
            if (type.equals("enumDef")) {
                this.enumDefRenameVect.addElement(ren);
            } else if (type.equals("typeDef")) {
                this.typeDefRenameVect.addElement(ren);
            } else {
                throw new RuntimeException("rename entry must have \"enumDef\" or \"typeDef\" attribute.");
            }
            int cnt = q[i].contentSize();
            ren.origName = new String[cnt];
            ren.newName = new String[cnt];
            for (int j = 0; j < cnt; ++j) {
                XElem xe = (XElem)q[i].content(j);
                ren.origName[j] = xe.name();
                ren.newName[j] = xe.get("newName");
            }
        }
    }

    private void doFlush(XWriter writer) {
        try {
            Rename ren;
            Object rec;
            int i;
            writer.prolog().nl().w((Object)"<conversion>\n");
            StringRec[] recs = this.getOrderedList();
            for (i = 0; i < recs.length; ++i) {
                rec = recs[i];
                writer.w((Object)"  <resString").attr(" scp", Integer.toString(((StringRec)rec).scope)).attr(" ndx", Integer.toString(((StringRec)rec).index)).attr(" org", ((StringRec)rec).original).attr(" new", ((StringRec)rec).newString).w((Object)"/>\n");
            }
            for (i = 0; i < this.typeVect.size(); ++i) {
                rec = this.typeVect.elementAt(i);
                writer.w((Object)"  <typeSpec").attr(" typeDef", ((TypeClass)rec).typeDef).attr(" bajaModule", ((TypeClass)rec).bajaModule).attr(" class", ((TypeClass)rec).className).w((Object)"/>\n");
            }
            for (i = 0; i < this.boolEnumVect.size(); ++i) {
                rec = this.boolEnumVect.elementAt(i);
                writer.w((Object)"  <booleanEnum").attr(" ename", ((BooleanEnum)rec).enumName).w((Object)"/>\n");
            }
            for (i = 0; i < this.enumDefRenameVect.size(); ++i) {
                ren = this.enumDefRenameVect.elementAt(i);
                this.writeRenames(" enumDef", writer, ren);
            }
            for (i = 0; i < this.typeDefRenameVect.size(); ++i) {
                ren = this.typeDefRenameVect.elementAt(i);
                this.writeRenames(" typeDef", writer, ren);
            }
            writer.w((Object)"</conversion>\n");
            writer.flush();
            writer.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void writeRenames(String type, XWriter writer, Rename ren) {
        writer.w((Object)"  <rename").attr(type, ren.name).w((Object)">\n");
        int cnt = ren.origName.length;
        for (int i = 0; i < cnt; ++i) {
            writer.w((Object)"    <").w((Object)ren.origName[i]).attr(" newName", ren.newName[i]).w((Object)"/>\n");
        }
        writer.w((Object)"  </rename>\n");
    }

    private StringRec[] getOrderedList() {
        try {
            Object[] recs = new StringRec[this.map.size()];
            recs = (StringRec[])this.map.toArray(recs);
            int i = 0;
            while (i < recs.length - 1) {
                Object rec = recs[i];
                if (((StringRec)rec).isGreaterThan((StringRec)recs[i + 1])) {
                    recs[i] = recs[i + 1];
                    recs[i + 1] = rec;
                    i = i == 0 ? ++i : --i;
                    continue;
                }
                ++i;
            }
            return recs;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new StringRec[0];
        }
    }

    private int getHash(int scope, int index) {
        return (scope << 16) + index;
    }

    public void setUnitPrompt(UnitPrompt u) {
        this.unitPrompt = u;
    }

    public static abstract class UnitPrompt {
        public abstract String getUserString(int var1, int var2, String var3);
    }

    static class Rename {
        String name;
        String[] origName;
        String[] newName;

        Rename() {
        }
    }

    static class BooleanEnum {
        String enumName;

        BooleanEnum() {
        }
    }

    static class TypeClass {
        String typeDef = "";
        String bajaModule;
        String className;

        TypeClass() {
        }
    }

    static class StringRec {
        int scope;
        int index;
        String original;
        String newString;

        StringRec() {
        }

        boolean isGreaterThan(StringRec r) {
            if (this.scope > r.scope) {
                return true;
            }
            if (this.scope < r.scope) {
                return false;
            }
            return this.index > r.index;
        }
    }
}

