/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.NoDataResponse;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class GroupForward
extends LonMessage
implements NetMessages {
    private int domain;
    private int ramOrEeprom;
    private int group;

    public GroupForward() {
        this.code = 119;
    }

    public GroupForward(int domain, int ramOrEeprom, int group) {
        this.code = 119;
        this.domain = domain;
        this.ramOrEeprom = ramOrEeprom;
        this.group = group;
    }

    public int getDomain() {
        return this.domain;
    }

    public int getRamOrEeprom() {
        return this.ramOrEeprom;
    }

    public int getGroup() {
        return this.group;
    }

    public void setDomain(int domain) {
        this.domain = domain;
    }

    public void setRamOrEeprom(int ramOrEeprom) {
        this.ramOrEeprom = ramOrEeprom;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    @Override
    public void toOutputStream(LonOutputStream out) {
        out.writeUnsigned8(this.code);
        out.write(this.group);
    }

    @Override
    public LonMessage toResponse(LonInputStream in) throws LonException {
        int code = in.readUnsigned8();
        if (code == 23) {
            throw new FailedResponseException();
        }
        if (code != 55) {
            throw new InvalidResponseException(code);
        }
        return new NoDataResponse(55);
    }
}

