/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.util.NmUtil;
import java.util.Vector;
import javax.baja.lonworks.BLonNetwork;

public class LonLinkListenerRegistry {
    private Vector<LinkListener> linkL = null;
    BLonNetwork lonworks;

    public LonLinkListenerRegistry(BLonNetwork l) {
        this.lonworks = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLinkListener(LinkListener l) {
        if (this.linkL == null) {
            this.linkL = new Vector();
        }
        Vector<LinkListener> vector = this.linkL;
        synchronized (vector) {
            this.linkL.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLinkListener(LinkListener l) {
        if (this.linkL == null) {
            return;
        }
        Vector<LinkListener> vector = this.linkL;
        synchronized (vector) {
            this.linkL.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listenerReceive(NAppBuffer msg) {
        if (this.linkL == null) {
            return;
        }
        Vector<LinkListener> vector = this.linkL;
        synchronized (vector) {
            for (int i = 0; i < this.linkL.size(); ++i) {
                LinkListener ll = this.linkL.elementAt(i);
                try {
                    ll.receive(msg);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listenerSend(NAppBuffer msg) {
        if (this.linkL == null) {
            return;
        }
        Vector<LinkListener> vector = this.linkL;
        synchronized (vector) {
            for (int i = 0; i < this.linkL.size(); ++i) {
                LinkListener ll = this.linkL.elementAt(i);
                try {
                    ll.send(msg);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void writeLinkDebug(String prefix, byte[] a, int len) {
        if ((a[0] & 0xF) != 6 && (a[3] & 1) != 1) {
            System.out.println();
        }
        StringBuilder sb = new StringBuilder(30 + len * 3);
        sb.append('[').append(this.lonworks.getLogName()).append(']');
        sb.append(prefix).append(NmUtil.timeStamp());
        sb.append("|");
        if (len > a.length) {
            len = a.length;
        }
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (i == 2 || i == 5 || i == 16) {
                    sb.append(' ');
                }
                if ((a[i] & 0xFF) < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toString(a[i] & 0xFF, 16)).append(' ');
            }
        }
        System.out.println(sb.toString());
    }

    public static interface LinkListener {
        public void receive(NAppBuffer var1);

        public void send(NAppBuffer var1);
    }
}

