/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

public class LinkedQueue {
    Linkable head;
    Linkable tail;
    int size;

    public synchronized Linkable dequeue() {
        try {
            if (this.size == 0) {
                this.wait();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getNext();
    }

    public synchronized Linkable dequeue(int timeout) {
        try {
            if (this.size == 0 && timeout > 0) {
                this.wait(timeout);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getNext();
    }

    private Linkable getNext() {
        Linkable lnkable = this.head;
        if (lnkable == null) {
            return null;
        }
        this.head = lnkable.getNext();
        if (this.head == null) {
            this.tail = null;
        }
        lnkable.setNext(null);
        lnkable.setInQueue(false);
        --this.size;
        return lnkable;
    }

    public synchronized void enqueue(Linkable value) {
        if (value.getInQueue()) {
            return;
        }
        value.setNext(null);
        value.setInQueue(true);
        if (this.tail == null) {
            this.head = this.tail = value;
        } else {
            this.tail.setNext(value);
            this.tail = value;
        }
        ++this.size;
        this.notifyAll();
    }

    public synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    public static interface Linkable {
        public Linkable getNext();

        public void setNext(Linkable var1);

        default public void setInQueue(boolean v) {
        }

        default public boolean getInQueue() {
            return false;
        }
    }
}

