/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

import com.tridium.lonworks.datatypes.BLinkFilterEntry;
import com.tridium.lonworks.datatypes.BLinkFilterTable;
import com.tridium.lonworks.loncomm.ListenerSupport;
import com.tridium.lonworks.loncomm.LonLinkListenerRegistry;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.io.LonLinkLayer;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enableSubnetNode", type="boolean", defaultValue="false"), @NiagaraProperty(name="subnetNode", type="BSubnetNode", defaultValue="BSubnetNode.DEFAULT"), @NiagaraProperty(name="enableDevice", type="boolean", defaultValue="false"), @NiagaraProperty(name="deviceName", type="String", defaultValue=""), @NiagaraProperty(name="enableSelector", type="boolean", defaultValue="false"), @NiagaraProperty(name="selector", type="int", defaultValue="0", facets={@Facet(value="BFacets.make(BFacets.MIN,BInteger.make(0),BFacets.MAX,BInteger.make(0x3fff))")}), @NiagaraProperty(name="maxEntries", type="int", defaultValue="1000"), @NiagaraProperty(name="entries", type="BLinkFilterTable", defaultValue="new BLinkFilterTable()", flags=7), @NiagaraProperty(name="toStandardOut", type="boolean", defaultValue="false"), @NiagaraProperty(name="includeCompletionEvents", type="boolean", defaultValue="false")})
@NiagaraAction(name="clearTable")
public class BLinkFilter
extends BComponent
implements LonLinkListenerRegistry.LinkListener {
    @Generated
    public static final Property enableSubnetNode = BLinkFilter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property subnetNode = BLinkFilter.newProperty((int)0, (BValue)BSubnetNode.DEFAULT, null);
    @Generated
    public static final Property enableDevice = BLinkFilter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property deviceName = BLinkFilter.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property enableSelector = BLinkFilter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property selector = BLinkFilter.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)16383)));
    @Generated
    public static final Property maxEntries = BLinkFilter.newProperty((int)0, (int)1000, null);
    @Generated
    public static final Property entries = BLinkFilter.newProperty((int)7, (BValue)new BLinkFilterTable(), null);
    @Generated
    public static final Property toStandardOut = BLinkFilter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property includeCompletionEvents = BLinkFilter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action clearTable = BLinkFilter.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLinkFilter.class);
    LonLinkListenerRegistry llink = null;
    BLonDevice dev = null;
    private static final BIcon icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/linkFilter.png");

    @Generated
    public boolean getEnableSubnetNode() {
        return this.getBoolean(enableSubnetNode);
    }

    @Generated
    public void setEnableSubnetNode(boolean v) {
        this.setBoolean(enableSubnetNode, v, null);
    }

    @Generated
    public BSubnetNode getSubnetNode() {
        return (BSubnetNode)this.get(subnetNode);
    }

    @Generated
    public void setSubnetNode(BSubnetNode v) {
        this.set(subnetNode, (BValue)v, null);
    }

    @Generated
    public boolean getEnableDevice() {
        return this.getBoolean(enableDevice);
    }

    @Generated
    public void setEnableDevice(boolean v) {
        this.setBoolean(enableDevice, v, null);
    }

    @Generated
    public String getDeviceName() {
        return this.getString(deviceName);
    }

    @Generated
    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    @Generated
    public boolean getEnableSelector() {
        return this.getBoolean(enableSelector);
    }

    @Generated
    public void setEnableSelector(boolean v) {
        this.setBoolean(enableSelector, v, null);
    }

    @Generated
    public int getSelector() {
        return this.getInt(selector);
    }

    @Generated
    public void setSelector(int v) {
        this.setInt(selector, v, null);
    }

    @Generated
    public int getMaxEntries() {
        return this.getInt(maxEntries);
    }

    @Generated
    public void setMaxEntries(int v) {
        this.setInt(maxEntries, v, null);
    }

    @Generated
    public BLinkFilterTable getEntries() {
        return (BLinkFilterTable)this.get(entries);
    }

    @Generated
    public void setEntries(BLinkFilterTable v) {
        this.set(entries, (BValue)v, null);
    }

    @Generated
    public boolean getToStandardOut() {
        return this.getBoolean(toStandardOut);
    }

    @Generated
    public void setToStandardOut(boolean v) {
        this.setBoolean(toStandardOut, v, null);
    }

    @Generated
    public boolean getIncludeCompletionEvents() {
        return this.getBoolean(includeCompletionEvents);
    }

    @Generated
    public void setIncludeCompletionEvents(boolean v) {
        this.setBoolean(includeCompletionEvents, v, null);
    }

    @Generated
    public void clearTable() {
        this.invoke(clearTable, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getLinkLayer().registerLinkListener(this);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getLinkLayer().unregisterLinkListener(this);
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        this.dev = null;
    }

    public void doClearTable() {
        this.getEntries().clearEntries();
    }

    @Override
    public void receive(NAppBuffer msg) {
        if (this.passFilter(msg, true)) {
            this.display(msg, true);
        }
    }

    @Override
    public void send(NAppBuffer msg) {
        if (this.passFilter(msg, false)) {
            this.display(msg, false);
        }
    }

    private boolean passFilter(NAppBuffer msg, boolean rcv) {
        if (this.isCompletionEvent(msg) && !this.getIncludeCompletionEvents()) {
            return false;
        }
        boolean pass = false;
        if (this.getEnableSubnetNode()) {
            if (this.dev == null) {
                this.dev = NmUtil.getLonNetwork(this).addressManager().getDeviceByAddress(this.getSubnetNode());
            }
            if (!this.passDeviceFilter(this.dev, msg, rcv)) {
                return false;
            }
            pass = true;
        }
        if (this.getEnableDevice()) {
            if (this.dev == null) {
                this.dev = NmUtil.getLonNetwork(this).addressManager().getDeviceByName(this.getDeviceName());
            }
            if (!this.passDeviceFilter(this.dev, msg, rcv)) {
                return false;
            }
            pass = true;
        }
        if (this.getEnableSelector()) {
            if (msg.getMessageCode() < 128) {
                return false;
            }
            byte[] a = msg.getWriteBuffer();
            int sel = (a[16] & 0x3F) << 8 | a[17] & 0xFF;
            if (sel != this.getSelector()) {
                return false;
            }
            pass = true;
        }
        return pass;
    }

    private boolean isCompletionEvent(NAppBuffer msg) {
        return msg.isCompletionEvent() && !msg.isResp();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean passDeviceFilter(BLonDevice dev, NAppBuffer msg, boolean rcv) {
        if (dev == null) {
            return false;
        }
        if (!rcv || this.isCompletionEvent(msg)) {
            byte[] buf = msg.getReadBuffer();
            byte typ = buf[5];
            if (typ == 1) {
                BSubnetNode sn = BSubnetNode.make(buf[9], buf[6] & 0x7F);
                if (sn.equals(dev.getSubnetNodeAddress())) return true;
                return false;
            }
            if (typ != 2) return false;
            byte[] na = new byte[6];
            System.arraycopy(buf, 10, na, 0, 6);
            BNeuronId nid = BNeuronId.make(na);
            if (nid.equals(dev.getNeuronIdAddress())) return true;
            return false;
        }
        BSubnetNode sn = msg.getSourceAddress();
        if (sn.equals(dev.getSubnetNodeAddress())) return true;
        return false;
    }

    private void display(NAppBuffer msg, boolean rcv) {
        if (this.getToStandardOut()) {
            this.toStandardOut(msg, rcv);
            return;
        }
        BLinkFilterTable et = this.getEntries();
        if (et.getMaxIndex() >= this.getMaxEntries()) {
            return;
        }
        BAbsTime ts = BAbsTime.make((long)System.currentTimeMillis());
        BBlob bl = BBlob.make((byte[])msg.getReadBuffer(), (int)0, (int)msg.getWriteBufferLen());
        this.getEntries().addEntry(new BLinkFilterEntry(rcv, ts, bl));
    }

    private void toStandardOut(NAppBuffer msg, boolean rcv) {
        byte[] a = msg.getWriteBuffer();
        if (rcv) {
            this.getLinkLayer().writeLinkDebug("recv: ", a, a[1] + 2);
        } else {
            this.getLinkLayer().writeLinkDebug("send: ", a, a[1] + 2);
        }
    }

    LonLinkListenerRegistry getLinkLayer() {
        LonLinkLayer lnk;
        if (this.llink == null && (lnk = ((NLonComm)NmUtil.getLonNetwork((BComponent)this).lonComm()).linkLayer) instanceof ListenerSupport) {
            this.llink = ((ListenerSupport)((Object)lnk)).getLonLinkListenerRegistry();
        }
        return this.llink;
    }

    public BIcon getIcon() {
        return icon;
    }
}

