/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.local;

import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.local.BPseudoNvContainer;
import com.tridium.lonworks.util.NmUtil;
import java.util.logging.Level;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonLink;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BImplicit;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="nvConfigData", type="BNvConfigData", defaultValue="new BNvConfigData()", flags=1, override=true), @NiagaraProperty(name="nvProps", type="BNvProps", defaultValue="new BNvProps()", flags=1, override=true), @NiagaraProperty(name="tuningPolicyName", type="String", defaultValue="defaultPolicy", flags=7, facets={@Facet(value="TUNING_POLICY_NAME_FACETS")}, override=true)})
public class BPseudoNV
extends BNetworkVariable {
    @Generated
    public static final Property nvConfigData = BPseudoNV.newProperty((int)1, (BValue)new BNvConfigData(), null);
    @Generated
    public static final Property nvProps = BPseudoNV.newProperty((int)1, (BValue)new BNvProps(), null);
    @Generated
    public static final Property tuningPolicyName = BPseudoNV.newProperty((int)7, (String)"defaultPolicy", (BFacets)TUNING_POLICY_NAME_FACETS);
    @Generated
    public static final Type TYPE = Sys.loadType(BPseudoNV.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPseudoNV() {
    }

    public BPseudoNV(int snvtType, BLonNvDirection direction) {
        this.getNvProps().setSnvtType(snvtType);
        this.getNvConfigData().setDirection(direction);
        BLonData dat = SnvtUtil.getLonData(snvtType);
        DynaDev.setNonCritical(dat);
        this.setData(dat);
    }

    @Override
    public void setData(BLonData v) {
        int i;
        if (v == null) {
            return;
        }
        Property[] a = this.getPropertiesArray();
        for (i = 0; i < a.length; ++i) {
            if (!BPseudoNV.isDataProp(a[i])) continue;
            this.remove(a[i]);
        }
        a = v.getPropertiesArray();
        for (i = 0; i < a.length; ++i) {
            Property prop = a[i];
            if (!BPseudoNV.isDataProp(prop)) continue;
            this.add(prop.getName(), v.get(prop), v.getFlags((Slot)prop), prop.getFacets(), null);
        }
    }

    @Override
    public void lonComponentStarted() {
        if (!this.getPseudoNvContainer().isOk()) {
            return;
        }
        if (this.getNvConfigData().getSelector() == -1) {
            this.getNvConfigData().setUnbound(this.getNvProps().getNvIndex());
        }
        this.getTuning().transition();
        this.evaluateLinkedState();
    }

    @Override
    public void lonComponentStopped() {
        if (!this.getPseudoNvContainer().isOk()) {
            return;
        }
        this.getTuning().transition();
    }

    @Override
    public void atSteadyState() {
        if (!this.getPseudoNvContainer().isOk()) {
            return;
        }
        this.getTuning().transition();
    }

    @Override
    public boolean isWriteable() {
        return this.getNvConfigData().isOutput();
    }

    @Override
    public void subscribed() {
    }

    @Override
    public void unsubscribed() {
    }

    @Override
    public void doForceRead() {
    }

    @Override
    protected void dataChanged(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (cx == null || !BLonNetwork.lonNoPropagate.equals(cx)) {
            this.propagateLinks();
        }
    }

    @Override
    public boolean write(Context cx) {
        boolean stateWrite;
        if (!this.getPseudoNvContainer().isOk()) {
            return false;
        }
        boolean bl = stateWrite = cx == BTuningPolicy.maxWriteTimeContext || cx == BTuningPolicy.writeOnStartContext || cx == BTuningPolicy.writeOnUpContext || cx == BTuningPolicy.writeOnEnabledContext;
        if (!(!stateWrite || this.isLinked() && this.getNvConfigData().isBoundNv())) {
            this.getTuning().writeOk();
            return false;
        }
        this.forceWrite();
        return false;
    }

    @Override
    public void doForceWrite() {
        if (!this.getPseudoNvContainer().isOk()) {
            return;
        }
        BNvConfigData configData = this.getNvConfigData();
        try {
            if (configData.isOutput() && configData.getAddrIndex() != -1) {
                NmUtil.setNvValue(BImplicit.make(configData.getAddrIndex()), NmUtil.getLonNetwork((BComponent)this).lonComm(), configData.getDirection().reverse(), configData.getSelector(), configData.getServiceType(), configData.getAuthenticated(), this.getData().toNetBytes());
                this.getData().writeOk();
                this.getTuning().writeOk();
            }
        }
        catch (Throwable e) {
            this.getData().writeFail(e.toString());
            this.getTuning().writeFail();
            String errMsg = "Unable to write " + this.debugName();
            this.lonNetwork().log().log(Level.SEVERE, errMsg, e);
            throw new BajaRuntimeException(errMsg + " " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isFatalFault() {
        return false;
    }

    @Override
    public BStatus getStatus() {
        return BStatus.ok;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BPseudoNvContainer;
    }

    public BPseudoNvContainer getPseudoNvContainer() {
        return (BPseudoNvContainer)this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lonKnobAdded(Knob knob) {
        Array<BLonLink> a;
        Array<BLonLink> array = a = this.getLinksToPropagate(true);
        synchronized (array) {
            a.add((Object)((BLonLink)knob.getLink()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lonKnobRemove(Knob knob) {
        Array<BLonLink> a = this.getLinksToPropagate(false);
        if (a != null) {
            Array<BLonLink> array = a;
            synchronized (array) {
                a.remove((Object)((BLonLink)knob.getLink()));
            }
        }
    }

    @Override
    public BLonDevice getDevice() {
        return this.lonNetwork().getLocalLonDevice();
    }
}

