/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.datatypes;

import com.tridium.lonworks.datatypes.BDeviceEntry;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDeviceEntryTable
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceEntryTable.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDeviceEntry[] getDeviceEntries() {
        BDeviceEntry[] temp = new BDeviceEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDeviceEntry.class)) {
            BValue kid = c.get();
            temp[count++] = (BDeviceEntry)kid;
        }
        BDeviceEntry[] result = new BDeviceEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public void addEntry(BLonDevice dev) {
        BDeviceData devDat = dev.getDeviceData();
        this.addEntry(dev.getDisplayName(null), devDat.getNodeState(), devDat.getSubnetNodeId().getSubnetId(), devDat.getSubnetNodeId().getNodeId(), devDat.getNeuronId(), devDat.getProgramId(), devDat.getChannelId(), devDat.getAuthenticate(), devDat.getWorkingDomain());
    }

    public void addEntry(String devName, BLonNodeState state, int subnet, int node, BNeuronId neuronId, BProgramId programId, int channelId, boolean auth, int wrkDmn) {
        String entryName = devName == null || devName.length() == 0 ? null : devName;
        this.add(entryName, (BValue)new BDeviceEntry(devName, state, subnet, node, neuronId, programId, channelId, auth, wrkDmn));
    }

    public void clearEntries() {
        this.removeAll(null);
    }

    public void removeEntry(BDeviceEntry e) {
        this.remove(e.getPropertyInParent(), null);
    }

    public BDeviceEntry findEntry(BNeuronId nid) {
        SlotCursor c = this.getProperties();
        while (c.next(BDeviceEntry.class)) {
            BDeviceEntry e = (BDeviceEntry)c.get();
            if (!e.getNeuronId().equals(nid)) continue;
            return e;
        }
        return null;
    }
}

