/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.ui.point;

import com.tridiumemea.micros.message.MicrosDictionary;
import com.tridiumemea.micros.point.BMicrosProxyExt;
import com.tridiumemea.micros.ui.point.BMicrosPointManager;
import com.tridiumemea.micros.ui.point.MicrosPointManagerSyncDialog;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.IllegalNameException;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

final class MicrosPointManagerNewDialog {
    private static final Lexicon lex = BMicrosPointManager.lex;
    private static final String EMPTY_STRING = "";
    private static final String CANNOT_CONSTRUCT_ROOM = "Could not construct a new room number from supplied arguments: ";
    private static final int IDX_POINT_PREFIX = 0;
    private static final int IDX_RN_PREFIX = 1;
    private static final int IDX_ST_RN = 2;
    private static final int IDX_COUNT = 3;
    private static final String WORD_ROOM = lex.getText("pmc.room");

    private MicrosPointManagerNewDialog() {
    }

    static MgrEdit promptForNew(BMicrosPointManager mgr, MgrEdit edit) throws Exception {
        String startRn;
        String pointPrefix;
        BEdgePane edge = new BEdgePane();
        BTextField[] fields = MicrosPointManagerNewDialog.buildInputPane(mgr, edge);
        int count = 0;
        boolean keepDisplayingNewDialog = true;
        do {
            int r;
            if ((r = BDialog.open((BWidget)mgr, (String)edit.getTitle(), (Object)edge, (int)3)) == 2) {
                return null;
            }
            pointPrefix = fields[0].getText();
            startRn = fields[2].getText();
            String countTxt = fields[3].getText();
            try {
                count = MicrosPointManagerNewDialog.validateCount(countTxt);
                MicrosPointManagerNewDialog.validateStartingRoomNumber(startRn);
                pointPrefix = MicrosPointManagerNewDialog.validatePointPrefix(pointPrefix);
                keepDisplayingNewDialog = false;
            }
            catch (IllegalArgumentException ie) {
                BDialog.error((BWidget)mgr, (Object)ie);
            }
        } while (keepDisplayingNewDialog);
        MicrosPointManagerNewDialog.buildEditList(edit, mgr.getModel().getNewTypes(), count, fields[1].getText(), startRn, pointPrefix);
        return edit;
    }

    private static void buildEditList(MgrEdit edit, MgrTypeInfo[] newTypes, int count, String rnPrefix, String startRn, String pointPrefix) throws Exception {
        for (int i = 0; i < count; ++i) {
            try {
                BControlPoint comp = MicrosPointManagerNewDialog.newInstance(newTypes[0], rnPrefix, startRn, i);
                BMicrosProxyExt ext = (BMicrosProxyExt)comp.getProxyExt();
                String rowSuffix = ext.getRoomNumber();
                MgrEditRow row = new MgrEditRow((BComponent)comp, null, newTypes);
                edit.addRow(row);
                row.setDefaultName(SlotPath.escape((String)(pointPrefix + rowSuffix)));
                continue;
            }
            catch (Exception e) {
                BMicrosPointManager.LOG.log(Level.WARNING, "Creating row ", e);
                throw e;
            }
        }
    }

    public static int validateCount(String countField) {
        try {
            int count = Integer.parseInt(countField);
            if (count < 1) {
                throw new NumberFormatException("Cannot add less than one room " + countField);
            }
            return count;
        }
        catch (NumberFormatException nfe) {
            IllegalArgumentException detailed = new IllegalArgumentException(lex.getText("pmc.countInvalid"), nfe);
            BMicrosPointManager.LOG.log(Level.WARNING, "Setting count ", detailed);
            throw detailed;
        }
    }

    public static void validateStartingRoomNumber(String rn) {
        if (rn.equals(MicrosDictionary.UNSET_ROOM_NUMBER)) {
            throw new IllegalArgumentException(lex.getText("pmc.startRn.invalid") + rn);
        }
    }

    public static String validatePointPrefix(String pointPrefix) {
        if (!pointPrefix.isEmpty() && !SlotPath.isValidName((String)pointPrefix)) {
            pointPrefix = SlotPath.escape((String)pointPrefix);
            try {
                SlotPath.verifyValidName((String)pointPrefix);
            }
            catch (IllegalNameException illegalName) {
                BMicrosPointManager.LOG.log(Level.WARNING, lex.getText("pmc.nameInvalid") + pointPrefix, illegalName);
                throw illegalName;
            }
        }
        return pointPrefix;
    }

    private static BTextField[] buildInputPane(BMicrosPointManager mgr, BEdgePane edge) {
        BGridPane grid = new BGridPane(2);
        BButton help = new BButton((Command)new ReflectCommand((BWidget)mgr, null, MicrosPointManagerSyncDialog.HELP_ICON, lex.getText("pmc.help")));
        help.setFocusTraversable(false);
        BToolBar toolbar = new BToolBar();
        toolbar.setOrientation(BOrientation.vertical);
        toolbar.add(null, (BValue)help);
        edge.setCenter((BWidget)grid);
        edge.setRight((BWidget)toolbar);
        BTextField pointNamePrefixField = new BTextField(WORD_ROOM, 12);
        BTextField roomNumberPrefixField = new BTextField(EMPTY_STRING, 12);
        BTextField startingRoomNumberField = new BTextField(MicrosDictionary.UNSET_ROOM_NUMBER, 10);
        BTextField countField = new BTextField("1", 6);
        grid.add(null, (BValue)new BLabel(lex.getText("pmc.add.pointPrefix")));
        grid.add(null, (BValue)pointNamePrefixField);
        grid.add(null, (BValue)new BLabel(lex.getText("pmc.add.roomPrefix")));
        grid.add(null, (BValue)roomNumberPrefixField);
        grid.add(null, (BValue)new BLabel(lex.getText("pmc.add.startRn")));
        grid.add(null, (BValue)startingRoomNumberField);
        grid.add(null, (BValue)new BLabel(lex.getText("pmc.add.count")));
        grid.add(null, (BValue)countField);
        return new BTextField[]{pointNamePrefixField, roomNumberPrefixField, startingRoomNumberField, countField};
    }

    private static BControlPoint newInstance(MgrTypeInfo type, String roomNumberPrefix, String startAddress, int offset) throws Exception {
        BControlPoint pt = (BControlPoint)type.newInstance();
        BMicrosProxyExt ext = (BMicrosProxyExt)BMicrosProxyExt.TYPE.getInstance();
        try {
            int start = Integer.parseInt(startAddress);
            int calculatedRN = start + offset;
            ext.setRoomNumber(roomNumberPrefix + Integer.toString(calculatedRN));
        }
        catch (NumberFormatException e) {
            ext.setRoomNumber(roomNumberPrefix + startAddress);
            String argErr = CANNOT_CONSTRUCT_ROOM + roomNumberPrefix + " " + startAddress + " " + offset;
            BMicrosPointManager.LOG.log(Level.WARNING, argErr, e);
        }
        pt.setProxyExt((BAbstractProxyExt)ext);
        return pt;
    }
}

