/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.util;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BFoxComponentSpace;
import com.tridium.json.JSONArray;
import com.tridium.util.NiagaraRpcUtil;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.rpc.TransportType;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public final class FoxRpcUtil {
    private static final Logger log = Logger.getLogger("fox.rpc");

    private FoxRpcUtil() {
    }

    public static <R> Optional<R> doRpcProperty(BComponent c, Property p, String methodName, Object ... args) throws Exception {
        if (!c.isMounted()) {
            return Optional.empty();
        }
        try {
            JSONArray argsArray;
            BISession session = c.getSession();
            if (session instanceof BFoxSession) {
                BFoxSession foxSession = (BFoxSession)session;
                Version remoteVersion = foxSession.getConnection().getRemoteVersion();
                if (remoteVersion.compareTo(FoxSession.VERSION_4_2) < 0 && NiagaraRpcUtil.isWhitelistedLegacyRpc((BTypeSpec)p.getType().getTypeSpec(), (String)methodName)) {
                    try {
                        return Optional.ofNullable(FoxRpcUtil.doOldRpc((BISpaceNode)c, p, methodName, args));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return foxSession.rpc(BOrd.make((BOrd)c.getAbsoluteOrd(), (String)("slot:" + p.getName())), methodName, args);
            }
            if (NiagaraRpcUtil.isWhitelistedLegacyRpc((BTypeSpec)p.getType().getTypeSpec(), (String)methodName)) {
                argsArray = NiagaraRpcUtil.encodeLegacyArgs((Object[])args);
            } else {
                argsArray = new JSONArray();
                for (Object o : args) {
                    argsArray.put(NiagaraRpcUtil.convertFromCollection((Object)o));
                }
            }
            return NiagaraRpcUtil.rpc((TransportType)TransportType.fox, (boolean)true, (String)"127.0.0.1", (BOrd)BOrd.make((BOrd)c.getOrdInSession(), (String)("slot:" + p.getName())), (String)methodName, (JSONArray)argsArray, (Context)c.getSession().getSessionContext());
        }
        catch (Exception e) {
            log.log(Level.INFO, "RPC failed for " + c.getType().getTypeName() + '#' + methodName, e);
            if (e instanceof SecurityException || e.getCause() instanceof SecurityException) {
                throw new Exception(Lexicon.make((String)"baja").getText("niagaraRpc.securityMessage"));
            }
            throw e;
        }
    }

    public static <R> Optional<R> doRpc(BISpaceNode node, String methodName, Object ... args) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Attempting rpc call to %s#%s", node.getNavOrd(), methodName));
        }
        if (!node.isMounted()) {
            return Optional.empty();
        }
        BISession session = node.getSession();
        try {
            JSONArray argsArray;
            if (session instanceof BFoxSession) {
                BFoxSession foxSession = (BFoxSession)session;
                Version remoteVersion = foxSession.getConnection().getRemoteVersion();
                if (remoteVersion.compareTo(FoxSession.VERSION_4_2) < 0 && NiagaraRpcUtil.isWhitelistedLegacyRpc((BTypeSpec)node.getType().getTypeSpec(), (String)methodName)) {
                    try {
                        return Optional.ofNullable(FoxRpcUtil.doOldRpc(node, methodName, args));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return foxSession.rpc(node.getAbsoluteOrd(), methodName, args);
            }
            if (NiagaraRpcUtil.isWhitelistedLegacyRpc((BTypeSpec)node.getType().getTypeSpec(), (String)methodName)) {
                argsArray = NiagaraRpcUtil.encodeLegacyArgs((Object[])args);
            } else {
                argsArray = new JSONArray();
                for (Object o : args) {
                    argsArray.put(NiagaraRpcUtil.convertFromCollection((Object)o));
                }
            }
            return NiagaraRpcUtil.rpc((TransportType)TransportType.fox, (boolean)true, (String)"127.0.0.1", (BOrd)node.getOrdInSession(), (String)methodName, (JSONArray)argsArray, (Context)session.getSessionContext());
        }
        catch (Exception e) {
            log.log(Level.INFO, "RPC failed for " + node.getType().getTypeName() + '#' + methodName, e);
            if (e instanceof SecurityException || e.getCause() instanceof SecurityException) {
                throw new Exception(Lexicon.make((String)"baja").getText("niagaraRpc.securityMessage"));
            }
            throw e;
        }
    }

    public static <R> Optional<R> doSilentRpc(BISpaceNode node, String methodName, Object ... args) {
        try {
            return FoxRpcUtil.doRpc(node, methodName, args);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static <R> R doOldRpc(BISpaceNode node, String methodName, Object ... args) throws Exception {
        return FoxRpcUtil.doOldRpc(node, null, methodName, args);
    }

    private static <R> R doOldRpc(BISpaceNode node, Property p, String methodName, Object ... args) throws Exception {
        BSpace space = node.getSpace();
        if (!(space instanceof BFoxComponentSpace)) {
            throw new IllegalArgumentException("Node is not mounted in a Fox Component Space");
        }
        if (p != null && !(node instanceof BComponent)) {
            throw new IllegalArgumentException("Cannot reflect property on non-BComponent");
        }
        Object arg = null;
        switch (args.length) {
            case 1: {
                arg = args[0];
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Fw.RPC call can only have one argument");
            }
        }
        try {
            return (R)space.fw(109, (Object)node, (Object)(p == null ? "reflect:" + methodName : "reflectProperty:" + p.getName() + ":" + methodName), arg, Optional.ofNullable(node.getSession()).map(BISession::getSessionContext).orElse(null));
        }
        catch (Exception e) {
            log.log(Level.INFO, "Fw.RPC failed for " + node.getType().getTypeName() + '#' + methodName, e);
            throw e;
        }
    }
}

