/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.LocalizableServerException;
import javax.baja.naming.BHost;
import javax.baja.naming.BStationSessionScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="foxs")
@NiagaraSingleton
public class BFoxsScheme
extends BStationSessionScheme {
    @Generated
    public static final BFoxsScheme INSTANCE = new BFoxsScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxsScheme.class);
    public static final int DEFAULT_PORT = 4911;
    public static final String SCHEME_NAME = "foxs";

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BFoxsScheme() {
        super(SCHEME_NAME);
    }

    public OrdQuery parse(String queryBody) {
        return new FoxQuery(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        return this.resolve(base, query, null);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query, AuthenticationClient client) throws SyntaxException, UnresolvedException {
        BHost host = null;
        BObject obj = base.get();
        host = obj instanceof BHost ? (BHost)obj : ((BComponent)obj).getHost();
        FoxQuery foxQuery = (FoxQuery)query;
        int port = foxQuery.port;
        BFoxSession session = BFoxSession.make(null, host, port, true);
        session.getConnection().setAuthenticationClient(client);
        try {
            session = BFoxSession.connect(session);
            return new OrdTarget(base, (BObject)session);
        }
        catch (LocalizableServerException e) {
            if (e.getLexiconModule().equals("fox") && e.getLexiconKey().equals("error.NoPermissionForStation")) {
                session.disconnect();
            }
            throw e;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UnresolvedException(query.toString(), e);
        }
    }

    public int getDefaultPort() {
        return 4911;
    }

    public static class FoxQuery
    implements OrdQuery {
        int port;

        FoxQuery(String body) {
            body = body.trim();
            this.port = body.length() == 0 ? 4911 : Integer.parseInt(body);
        }

        FoxQuery(int port) {
            this.port = port;
        }

        public boolean isHost() {
            return false;
        }

        public boolean isSession() {
            return true;
        }

        public void normalize(OrdQueryList list, int index) {
            list.shiftToHost(index);
        }

        public String getScheme() {
            return BFoxsScheme.SCHEME_NAME;
        }

        public String getBody() {
            StringBuilder sb = new StringBuilder();
            if (this.port != 4911) {
                sb.append(String.valueOf(this.port));
            }
            return sb.toString();
        }

        public String toString() {
            return "foxs:" + this.getBody();
        }

        public int getPort() {
            return this.port;
        }
    }
}

