/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.authn.LoginFailureCause;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FoxsRedirectException;
import com.tridium.fox.sys.ActivityMonitor;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxScheme;
import com.tridium.fox.sys.BFoxsScheme;
import com.tridium.fox.sys.BIFoxProxySpace;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.fox.sys.FatalAuthenticationException;
import com.tridium.fox.sys.LocalizableExceptionTranslator;
import com.tridium.fox.sys.LocalizableServerException;
import com.tridium.fox.sys.ModuleNotFoundLocalException;
import com.tridium.fox.sys.ModuleNotFoundRemoteException;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.util.ArrayUtil;
import com.tridium.util.BSessionInfo;
import com.tridium.util.CustomThemeModuleManager;
import com.tridium.util.IFoxSession;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BServiceScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.nav.NavFileDecoder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.CancelledAuthenticationException;
import javax.baja.security.ChangeUserAuthenticationException;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Version;

@NiagaraType
public class BFoxSession
extends BFoxProxySession
implements BServiceScheme.ServiceSession,
IFoxSession,
BFoxClientConnection.Interest {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxSession.class);
    private static final BIcon iconConnected = BIcon.std((String)"fox.png");
    private static final BIcon iconDisconnected = BIcon.std((String)"foxDisconnected.png");
    private static final BIcon secureBadgeConnected = BIcon.std((String)"badges/lock.png");
    private static final BIcon secureBadgeDisconnected = BIcon.std((String)"badges/lockDisconnected.png");
    private static final BIcon fipsBadgeConnected = BIcon.std((String)"badges/fips.png");
    private static final ThreadLocal<String> threadSessionId = new ThreadLocal();
    private static final String validRemoteTypeInfos = "validRemoteTypeInfos";
    private static final String invalidRemoteTypeInfos = "invalidRemoteTypeInfos";
    private static final long resetTimeoutInterval = 60000L;
    private static final long timeoutNotificationInterval = 30000L;
    private final BHost host;
    private boolean useFoxs;
    private int port;
    private final BFoxClientConnection connection;
    private boolean connected;
    private BOrd absOrd;
    private BOrd ordInHost;
    private String stationName;
    private BIUserCredentials credentials;
    private BIUserCredentials usernameCredential;
    private String authenticationScheme = "Fox";
    private String[] availableSchemes;
    private String defaultScheme;
    private Context sessionContext;
    private LoginFailureCause cause;
    private ActivityMonitor monitor;
    String stationFault;
    public Object uiCache = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BFoxSession[] list() {
        ArrayList<BFoxSession> list = new ArrayList<BFoxSession>();
        for (BHost host : BHost.getAllHosts()) {
            for (BINavNode kid : host.getNavChildren()) {
                if (!(kid instanceof BFoxSession)) continue;
                list.add((BFoxSession)kid);
            }
        }
        return list.toArray(new BFoxSession[0]);
    }

    public static BFoxSession make(BHost host, int port) {
        return BFoxSession.make(null, host, port, false);
    }

    public static BFoxSession make(BHost host, int port, boolean useFoxs) {
        return BFoxSession.make(null, host, port, useFoxs);
    }

    public static BFoxSession make(String stationName, BHost host, int port, boolean useFoxs) {
        String name = BFoxSession.buildNavName(port, useFoxs);
        BFoxSession session = (BFoxSession)host.getNavChild(name);
        if (session == null) {
            session = new BFoxSession(name, stationName, host, port, useFoxs);
            host.addNavChild((BINavNode)session);
        }
        return session;
    }

    protected static String buildNavName(int port, boolean useFoxs) {
        int defaultPort;
        String name = useFoxs ? "foxs" : "fox";
        int n = defaultPort = useFoxs ? 4911 : 1911;
        if (port != defaultPort) {
            name = name + ":" + port;
        }
        return name;
    }

    private BFoxSession(String name, String stationName, BHost host, int port, boolean useFoxs) {
        super(name);
        this.stationName = stationName;
        this.host = host;
        this.port = port;
        this.useFoxs = useFoxs;
        this.ordInHost = useFoxs ? BOrd.make((OrdQuery)new BFoxsScheme.FoxQuery(port)) : BOrd.make((OrdQuery)new BFoxScheme.FoxQuery(port));
        this.absOrd = BOrd.make((BOrd)host.getAbsoluteOrd(), (BOrd)this.ordInHost);
        this.connection = new BFoxClientConnection(this);
        if (Fox.appVersion.equals("unknown")) {
            try {
                Fox.appVersion = "" + Sys.getBajaVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Fox.hostName = Sys.getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Fox.hostAddress = Sys.getLocalHost(null).getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BHost getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean getUseFoxs() {
        return this.useFoxs;
    }

    public void setUseFoxs(boolean useFoxs) {
        this.useFoxs = useFoxs;
    }

    public BFoxClientConnection getConnection() {
        return this.connection;
    }

    @Override
    public String getStationName() {
        return this.stationName;
    }

    public BSessionInfo getSessionInfo() {
        BSessionInfo info;
        FoxSession session = this.connection.session();
        BAbsTime connectedAt = BAbsTime.make((long)session.getConnectTime());
        Type type = BSessionInfo.TYPE;
        if (this.useFoxs) {
            type = Sys.getType((String)"platCrypto:SslSessionInfo");
        }
        Class cls = type.getTypeClass();
        String username = this.getUsername();
        try {
            Method mthd = cls.getMethod("make", String.class, BAbsTime.class, Socket.class, String.class, String.class, Boolean.TYPE);
            Socket socket = session.getSocket();
            String hostName = this.connection.getRemoteHost().getHostname();
            info = (BSessionInfo)mthd.invoke(null, this.stationName, connectedAt, socket, username, hostName, session.getRemoteWelcome().getBoolean("fips", false));
        }
        catch (Exception e) {
            e.printStackTrace();
            info = null;
        }
        return info;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public synchronized void connect() throws Exception {
        if (this.connected) {
            return;
        }
        if (this.credentials != null) {
            this.connection.setCredentials(this.credentials);
        }
        try {
            this.connection.connect();
            BOrd tordInHost = this.useFoxs ? BOrd.make((OrdQuery)new BFoxsScheme.FoxQuery(this.port)) : BOrd.make((OrdQuery)new BFoxScheme.FoxQuery(this.port));
            if (!tordInHost.equivalent((Object)this.ordInHost)) {
                this.ordInHost = tordInHost;
                this.absOrd = BOrd.make((BOrd)this.host.getAbsoluteOrd(), (BOrd)this.ordInHost);
            }
            if (!this.connection.hasInterests()) {
                this.connection.engageNoRetry(this, 0L);
            }
        }
        catch (ChangeUserAuthenticationException e) {
            this.authenticationScheme = "Fox";
            throw e;
        }
        catch (FoxAuthenticationException e) {
            if (e.fatal != null) {
                throw new FatalAuthenticationException(e.fatal);
            }
            if ("Cancelled".equals(e.getMessage())) {
                this.authenticationScheme = "Fox";
                throw new CancelledAuthenticationException();
            }
            this.authenticationScheme = e.method == null ? "Fox" : "Fox (" + e.method + ")";
            throw new AuthenticationException((AuthenticationRealm)this, (Throwable)e);
        }
    }

    public static BFoxSession connect(BFoxSession session) throws Exception {
        try {
            session.connect();
        }
        catch (FoxsRedirectException e) {
            session = BFoxSession.recreateSession(session, e.getPort(), true);
            session.connect();
        }
        return session;
    }

    private static BFoxSession recreateSession(BFoxSession old, int port, boolean useFoxs) {
        BFoxSession session = BFoxSession.make(old.getStationName(), old.getHost(), port, useFoxs);
        session.getConnection().setAuthenticationClient(old.getConnection().getAuthenticationClient());
        if (old.getCredentials() != null) {
            session.setCredentials(old.getCredentials());
        }
        old.close();
        return session;
    }

    void postConnect() throws Exception {
        FoxMessage hello = this.connection.session().getRemoteHello();
        this.stationName = null;
        try {
            this.stationName = hello.getString("station.name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection.getChannels().getUserChannel().fetchPrefs();
        this.connection.getChannels().getSysChannel().subscribeNavEvents();
        this.loadSubSpaces();
        this.loadNavFileSpace();
        BTimeZone timeZone = BTimeZone.getLocal();
        try {
            timeZone = (BTimeZone)BTimeZone.DEFAULT.decodeFromString(hello.getString("timeZone"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionContext = BFacets.make((String)"TimeZone", (BIDataValue)timeZone, (String)"username", (BIDataValue)BString.make((String)this.getUsername()));
        this.connected = true;
        if (this.monitor != null) {
            this.monitor.start();
        }
    }

    @Override
    public synchronized void disconnect() {
        this.authenticationScheme = "Fox";
        this.connection.disengage(this);
        this.connection.close();
    }

    @Override
    public void close() {
        this.disconnect();
        this.host.removeNavChild((BINavNode)this);
    }

    public String getStationFault() {
        return this.stationFault;
    }

    public Context getSessionContext() {
        return this.sessionContext;
    }

    public LoginFailureCause getFailureCause() {
        return this.cause;
    }

    @Override
    public String getUsername() {
        if (this.credentials != null) {
            return this.credentials.getUsername();
        }
        if (this.usernameCredential != null) {
            return this.usernameCredential.getUsername();
        }
        return this.connection.getCredentials().getUsername();
    }

    @Override
    public BAbsTime getLastFailureTime() {
        return this.connection.getLastFailureTime();
    }

    @Override
    public String getLastFailureCause() {
        return this.connection.getLastFailureCause();
    }

    @Override
    public BRelTime getRetryPeriod() {
        return this.connection.getRetryPeriod();
    }

    @Override
    public void setRetryPeriod(BRelTime period) {
        this.connection.setRetryPeriod(period);
    }

    @Override
    public BAbsTime getNextAttemptTime() {
        return this.connection.getNextAttemptTime();
    }

    @Override
    public boolean isEngaged(String interest) {
        return this.connection.isEngaged(this.toInterest(interest));
    }

    @Override
    public void engageNoRetry(String interest) throws Exception {
        this.connection.engageNoRetry(this.toInterest(interest));
    }

    public static BFoxSession engageNoRetry(BFoxSession session, String interest) throws Exception {
        try {
            session.engageNoRetry(interest);
        }
        catch (FoxsRedirectException e) {
            session = BFoxSession.recreateSession(session, e.getPort(), true);
            session.engageNoRetry(interest);
        }
        return session;
    }

    @Override
    public void engageNoRetry(String interest, long failFastPeriod) throws Exception {
        this.connection.engageNoRetry(this.toInterest(interest), failFastPeriod);
    }

    public static BFoxSession engageNoRetry(BFoxSession session, String interest, long failFastPeriod) throws Exception {
        try {
            session.engageNoRetry(interest, failFastPeriod);
        }
        catch (FoxsRedirectException e) {
            session.engageNoRetry(interest, failFastPeriod);
            session.connect();
        }
        return session;
    }

    @Override
    public void engageRetry(String interest) throws Exception {
        this.connection.engageRetry(this.toInterest(interest));
    }

    public static BFoxSession engageRetry(BFoxSession session, String interest) throws Exception {
        try {
            session.engageRetry(interest);
        }
        catch (FoxsRedirectException e) {
            session = BFoxSession.recreateSession(session, e.getPort(), true);
            session.engageRetry(interest);
        }
        return session;
    }

    @Override
    public void disengage(String interest) {
        this.connection.disengage(this.toInterest(interest));
    }

    private BFoxClientConnection.Interest toInterest(String s) {
        return new BFoxClientConnection.StringInterest(s);
    }

    synchronized void sessionOpened() {
    }

    synchronized void sessionClosed() {
        this.sessionClosed(null);
    }

    synchronized void sessionClosed(LoginFailureCause cause) {
        if (this.monitor != null) {
            this.monitor.stop();
        }
        this.connected = false;
        this.stationFault = null;
        this.cause = cause;
        this.unloadSubSpaces();
        this.credentials = null;
        this.connection.setCredentials((BIUserCredentials)new BUsernameAndPassword());
    }

    public long resetSessionTimeout() throws Exception {
        return this.resetSessionTimeout(0L);
    }

    public long resetSessionTimeout(long offset) throws Exception {
        return this.getConnection().getChannels().getUserChannel().resetSessionTimeout(offset);
    }

    public long getSessionTimeRemaining() throws Exception {
        return this.getConnection().getChannels().getUserChannel().getSessionTimeRemaining();
    }

    @Override
    public void userActivity() {
        if (this.isConnected()) {
            if (this.monitor == null) {
                this.monitor = new ActivityMonitor(60000L, 30000L, this, ExecutorServiceHolder.EXECUTOR);
                this.monitor.start();
            }
            this.monitor.activity();
        }
    }

    @Override
    public void addNotifyListener(BFoxProxySession.NotifyListener listener) {
        if (this.isConnected()) {
            if (this.monitor == null) {
                this.monitor = new ActivityMonitor(60000L, 30000L, this, ExecutorServiceHolder.EXECUTOR);
                this.monitor.start();
            }
            this.monitor.addNotifyListener(listener);
        }
    }

    @Override
    public void removeNotifyListener(BFoxProxySession.NotifyListener listener) {
        if (this.isConnected()) {
            if (this.monitor == null) {
                this.monitor = new ActivityMonitor(60000L, 30000L, this, ExecutorServiceHolder.EXECUTOR);
                this.monitor.start();
            }
            this.monitor.removeNotifyListener(listener);
        }
    }

    @Override
    public Object pauseActivityMonitor() {
        if (this.isConnected()) {
            if (this.monitor == null) {
                this.monitor = new ActivityMonitor(60000L, 30000L, this, ExecutorServiceHolder.EXECUTOR);
                this.monitor.start();
            }
            return this.monitor.pause();
        }
        return null;
    }

    @Override
    public void resumeActivityMonitor(Object token) {
        if (this.isConnected()) {
            if (this.monitor == null) {
                this.monitor = new ActivityMonitor(60000L, 30000L, this, ExecutorServiceHolder.EXECUTOR);
                this.monitor.start();
            }
            this.monitor.resume(token);
        }
    }

    public ActivityMonitor getActivityMonitor() {
        if (this.isConnected() && this.monitor == null) {
            this.monitor = new ActivityMonitor(60000L, 30000L, this, ExecutorServiceHolder.EXECUTOR);
            this.monitor.start();
        }
        return this.monitor;
    }

    @Override
    public String getAuthenticationRealmName() {
        return this.absOrd.toString();
    }

    @Override
    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public void setAuthenticationScheme(String schemeName) {
        this.authenticationScheme = "Fox (" + schemeName + ")";
    }

    @Override
    public String[] getAvailableAuthenticationSchemes() {
        if (this.availableSchemes == null) {
            return null;
        }
        return (String[])this.availableSchemes.clone();
    }

    public void setAvailableAuthenticationSchemes(String[] availableSchemes) {
        this.availableSchemes = availableSchemes == null ? null : (String[])availableSchemes.clone();
    }

    @Override
    public String getDefaultAuthenticationScheme() {
        return this.defaultScheme;
    }

    public void setDefaultAuthenticationScheme(String scheme) {
        this.defaultScheme = scheme;
    }

    @Override
    public BICredentials makeCredentials() {
        return new BUsernameAndPassword();
    }

    @Override
    public BICredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(BICredentials credentials) {
        if (!(credentials instanceof BIUserCredentials)) {
            throw new IllegalArgumentException();
        }
        this.credentials = (BIUserCredentials)credentials;
    }

    public void setUsernameCredential(BIUserCredentials credentials) {
        this.usernameCredential = credentials;
    }

    public void loadSubSpaces() {
        try {
            BSysChannel sysChannel = this.getConnection().getChannels().getSysChannel();
            HashMap<String, String> schemeIds = sysChannel.listLocalSpaces();
            for (TypeInfo type : Sys.getRegistry().getTypes(BIFoxProxySpace.TYPE.getTypeInfo())) {
                if (type.isInterface() || type.isAbstract()) continue;
                try {
                    BSpace space = (BSpace)type.getInstance();
                    if (!schemeIds.containsKey(space.getNavName()) || this.getNavChild(space.getNavName()) != null) continue;
                    ((BIFoxProxySpace)space).init(this);
                    this.addNavChild((BINavNode)space);
                }
                catch (Exception e) {
                    try {
                        Class<?> cls = type.getClass();
                        Constructor<?> cons = cls.getConstructor(new Class[0]);
                        if (!Modifier.isPublic(cons.getModifiers())) {
                            continue;
                        }
                    }
                    catch (NoSuchMethodException nsme) {
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    e.printStackTrace();
                }
            }
        }
        catch (LocalizableServerException e) {
            if (e.getLexiconModule().equals("fox") && e.getLexiconKey().equals("error.NoPermissionForStation")) {
                throw e;
            }
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void loadNavFileSpace() {
        BOrd navFileOrd = null;
        try {
            for (BINavNode kid : this.getNavChildren()) {
                if (!(kid instanceof BNavFileSpace)) continue;
                this.removeNavChild(kid);
                break;
            }
            if ((navFileOrd = this.connection.getChannels().getUserChannel().getNavFile()).isNull()) {
                return;
            }
            BIFile file = (BIFile)navFileOrd.get((BObject)this);
            BNavFileSpace space = new NavFileDecoder(file).decodeDocument();
            this.addNavChild((BINavNode)space);
            Object[] kids = this.getNavChildren();
            kids = (BINavNode[])ArrayUtil.toTop((Object[])kids, (int)(kids.length - 1));
            this.reorderNavChildren((BINavNode[])kids);
        }
        catch (Throwable e) {
            System.out.println("ERROR:  Cannot load nav file \"" + navFileOrd + "\": " + e);
        }
    }

    public void unloadSubSpaces() {
        try {
            for (BINavNode sub : this.getNavChildren()) {
                try {
                    if (sub instanceof BIFoxProxySpace) {
                        BIFoxProxySpace foxSpace = (BIFoxProxySpace)sub;
                        foxSpace.cleanup(this);
                    }
                    this.removeNavChild(sub);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public BOrd getAbsoluteOrd() {
        return this.absOrd;
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public String getNavDisplayName(Context cx) {
        String s = super.getNavDisplayName(cx);
        if (!this.useFoxs) {
            if (this.connection.getPort() != 1911) {
                s = s + ":" + this.connection.getPort();
            }
        } else if (this.connection.getPort() != 4911) {
            s = s + ":" + this.connection.getPort();
        }
        if (this.stationName != null) {
            return s + " (" + this.stationName + ")";
        }
        return s;
    }

    public BOrd getNavOrd() {
        return this.absOrd;
    }

    public BComponent getService(Type type) {
        try {
            BBrokerChannel broker = (BBrokerChannel)this.connection.getChannels().get("station", BBrokerChannel.TYPE);
            SlotPath path = broker.serviceToPath(type.toString());
            BOrd ord = BOrd.make((String)("station:|" + path));
            return (BComponent)ord.get((BObject)this);
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(type.toString(), (Throwable)e);
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("workbench:FoxSessionAgent");
        agents.toTop("workbench:StationSummary");
        agents.remove("workbench:NavContainerView");
        return agents;
    }

    public BIcon getIcon() {
        BIcon icon;
        if (this.isConnected()) {
            icon = iconConnected;
            if (this.useFoxs) {
                icon = BIcon.make((BIcon)icon, (BIcon)secureBadgeConnected);
            }
            try {
                if (this.getConnection().session().getRemoteWelcome().getBoolean("fips", false)) {
                    icon = BIcon.make((BIcon)icon, (BIcon)fipsBadgeConnected);
                }
            }
            catch (Exception exception) {}
        } else {
            icon = iconDisconnected;
            if (this.useFoxs) {
                icon = BIcon.make((BIcon)icon, (BIcon)secureBadgeDisconnected);
            }
        }
        return icon;
    }

    public static RuntimeException toException(Throwable e) {
        if (e instanceof ModuleNotFoundLocalException) {
            return (RuntimeException)e;
        }
        if (e instanceof ModuleNotFoundRemoteException) {
            return (RuntimeException)e;
        }
        ModuleNotFoundException x = LocalizableExceptionTranslator.getModuleNotFoundException(e);
        if (x != null) {
            return new ModuleNotFoundLocalException(x.getModuleName(), e);
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new BajaRuntimeException(e);
    }

    public void setThreadLocalSessionId() {
        try {
            threadSessionId.set(this.getConnection().session().getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearThreadLocalSessionId() {
        try {
            threadSessionId.remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BDynamicEnum getDefaultThemeEnumForSession() {
        BDynamicEnum themeEnum = CustomThemeModuleManager.getDefaultThemeEnum();
        try {
            String sessionId = threadSessionId.get();
            if (sessionId != null) {
                FoxSession session = Fox.getSession(sessionId);
                BFoxSession foxSession = ((BFoxClientConnection)session.conn()).getFoxSession();
                BEnumRange range = themeEnum.getRange();
                int[] ordinals = range.getOrdinals();
                String selectedTheme = themeEnum.getTag();
                ArrayList<Integer> newOrdinals = new ArrayList<Integer>(ordinals.length);
                ArrayList<String> newTags = new ArrayList<String>(ordinals.length);
                boolean missingTheme = false;
                for (int ordinal : ordinals) {
                    String tag = range.getTag(ordinal);
                    String themeModuleName = "theme" + tag + ":ux";
                    Version themeModuleVersion = session.getFromCache(themeModuleName, key -> (Version)foxSession.fw(404, themeModuleName, null, null, null));
                    if (themeModuleVersion != null && !themeModuleVersion.isNull()) {
                        newOrdinals.add(ordinal);
                        newTags.add(tag);
                        continue;
                    }
                    missingTheme = true;
                }
                if (missingTheme) {
                    BEnumRange newRange = BEnumRange.make((int[])newOrdinals.stream().mapToInt(i -> i).toArray(), (String[])newTags.toArray(new String[0]));
                    try {
                        return BDynamicEnum.make((BEnum)newRange.get(selectedTheme));
                    }
                    catch (InvalidEnumException ignore) {
                        if (newOrdinals.size() > 0) {
                            return BDynamicEnum.make((BEnum)newRange.get(ordinals[0]));
                        }
                        return BDynamicEnum.DEFAULT;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return themeEnum;
    }

    public static Collection<TypeInfo> getRemoteTypesForSession(Collection<TypeInfo> localTypes) {
        try {
            BBrokerChannel brokerChannel;
            FoxSession session;
            BFoxSession foxSession;
            BFoxClientConnection connection;
            String sessionId = threadSessionId.get();
            if (sessionId != null && (connection = (foxSession = ((BFoxClientConnection)(session = Fox.getSession(sessionId)).conn()).getFoxSession()).getConnection()) != null && connection.isConnected() && connection.getRemoteVersion().compareTo(FoxSession.VERSION_4) >= 0 && (brokerChannel = (BBrokerChannel)connection.getChannels().get("station")) != null && session != null) {
                Map validCache = session.getFromCache(validRemoteTypeInfos, key -> new HashMap());
                Collection invalidCache = session.getFromCache(invalidRemoteTypeInfos, key -> new HashSet());
                Map<String, Version> filteredTypeInfos = brokerChannel.checkTypes(localTypes.stream().filter(type -> !validCache.containsKey(type.toString()) && !invalidCache.contains(type.toString())).collect(Collectors.toList()));
                filteredTypeInfos.forEach((type, version) -> validCache.merge(type, version, (t, v) -> v));
                invalidCache.addAll(localTypes.stream().filter(type -> !filteredTypeInfos.containsKey(type.toString())).map(TypeInfo::toString).collect(Collectors.toList()));
                return localTypes.stream().filter(type -> validCache.containsKey(type.toString())).collect(Collectors.toList());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return localTypes;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        boolean useSecureFox = false;
        switch (x) {
            case 805: 
            case 806: {
                useSecureFox = true;
            }
            case 801: 
            case 802: {
                int port;
                String stationName = (String)a;
                BHost host = (BHost)b;
                String name = useSecureFox ? "fwFoxs-" + host.getHostname() : "fwFox-" + host.getHostname();
                int defaultPort = useSecureFox ? 4911 : 1911;
                int n = port = c != null ? (Integer)c : defaultPort;
                if (port != defaultPort) {
                    name = name + ":" + port;
                }
                BFoxSession result = new BFoxSession(name, stationName, host, port, useSecureFox);
                Integer fwConnType = x == 801 || x == 805 ? FoxSession.FW_FOX_SESSION : FoxSession.FW_STATION_FOX_SESSION;
                result.connection.fw(803, fwConnType, null, null, null);
                return result;
            }
            case 404: {
                if (a == null || ((String)a).equalsIgnoreCase("baja")) {
                    return this.getConnection().getRemoteVersion();
                }
                if (this.getConnection().getRemoteVersion().compareTo(new Version(new int[]{3, 6, 13})) != -1) {
                    BSysChannel sysChannel = this.getConnection().getChannels().getSysChannel();
                    try {
                        String key = b == null ? (String)a : String.format("%s:%s", a, b);
                        byte[] versionBytes = sysChannel.stationCall("module.version", key.getBytes(), new String[0]);
                        return new Version(new String(versionBytes));
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private static class ExecutorServiceHolder {
        private static final ThreadFactory daemonThreadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setName("ActivityMonitor");
                return t;
            }
        };
        private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor(daemonThreadFactory);

        private ExecutorServiceHolder() {
        }
    }
}

