/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.MulticastServer;
import com.tridium.fox.session.Tuner;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.firewall.BServerPort;
import javax.net.ssl.SSLException;
import org.bouncycastle.tls.TlsException;

public abstract class FoxServer {
    private static final String FOX = "fox";
    private static final String FOXS = "foxs";
    static Logger log = Logger.getLogger("fox");
    protected BServerPort foxPort;
    protected BServerPort foxsPort;
    private boolean alive = true;
    private Thread foxThread;
    private ServerSocket foxServerSocket;
    private boolean foxRunning = false;
    private Thread foxsThread;
    private ServerSocket foxsServerSocket;
    private boolean foxsRunning = false;
    private MulticastServer multicastServer;

    public FoxServer(BServerPort foxPort, BServerPort foxsPort) {
        this.foxPort = foxPort;
        this.foxsPort = foxsPort;
    }

    public MulticastServer getMulticastServer() {
        return this.multicastServer;
    }

    public void run() throws Exception {
        if (this.foxThread != null || this.foxsThread != null) {
            throw new IllegalStateException("Server already running");
        }
        this.alive = true;
        if (this.foxPort != null) {
            this.foxThread = new Thread((Runnable)new MainLoop(FOX), "Fox:Server");
            this.foxThread.start();
        }
        if (this.foxsPort != null) {
            this.foxsThread = new Thread((Runnable)new MainLoop(FOXS), "Foxs:Server");
            this.foxsThread.start();
        }
        try {
            if (!Fox.ipv6Enabled && !Fox.ipv4Enabled) {
                System.err.println("WARNING: Disabling Fox multicast, no local addresses detected");
                Fox.multicastEnabled = false;
            }
            if (Fox.multicastEnabled) {
                this.multicastServer = new MulticastServer(this);
                this.multicastServer.start();
            } else {
                log.info("Multicast disabled (no station discovery supported)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR: Cannot open Fox multicast socket: " + e);
        }
    }

    private void runFox() {
        this.foxRunning = true;
        this.run(FOX);
        this.foxRunning = false;
    }

    private void runFoxs() {
        this.foxsRunning = true;
        this.run(FOXS);
        this.foxsRunning = false;
    }

    public boolean isServing() {
        return this.foxServerSocket != null || this.foxsServerSocket != null;
    }

    public boolean isRunning() {
        return this.foxRunning || this.foxsRunning;
    }

    public boolean isFoxRunning() {
        return this.foxRunning;
    }

    public boolean isFoxsRunning() {
        return this.foxsRunning;
    }

    public ServerSocket getFoxServerSocket() throws IOException {
        if (this.foxPort.getBindToLoopback()) {
            return new ServerSocket(this.foxPort.getBindingPort(), 10, InetAddress.getByName(null));
        }
        return new ServerSocket(this.foxPort.getBindingPort(), 10);
    }

    public ServerSocket getFoxsServerSocket() throws IOException {
        throw new UnsupportedOperationException("FOXS not supported.");
    }

    private void run(String scheme) {
        ServerSocket server = null;
        BServerPort port = null;
        block13: while (this.alive) {
            try {
                if (scheme.equalsIgnoreCase(FOX)) {
                    port = this.foxPort;
                    server = this.foxServerSocket = this.getFoxServerSocket();
                } else {
                    port = this.foxsPort;
                    server = this.foxsServerSocket = this.getFoxsServerSocket();
                }
            }
            catch (BindException be) {
                log.severe(scheme.toUpperCase() + " server failed to bind to port [" + port.getPublicServerPort() + "] " + be);
                server = null;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IllegalArgumentException iae) {
                log.severe(scheme.toUpperCase() + " server failed to start on port [" + port.getPublicServerPort() + "]\n " + iae);
                return;
            }
            catch (IOException ioe) {
                log.severe(scheme.toUpperCase() + " server failed to start on port. [" + port.getPublicServerPort() + "]\n " + ioe);
                return;
            }
            if (server == null) continue;
            try {
                log.info(scheme.toUpperCase() + " server started on port [" + port.getPublicServerPort() + "]");
                Socket s = null;
                while (this.alive) {
                    try {
                        s = server.accept();
                        if (!this.alive) continue block13;
                        Tuner.openServer(this, s, scheme);
                    }
                    catch (IOException ssl) {
                        if (this.alive && (ssl instanceof SSLException || ssl instanceof TlsException)) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.WARNING, "Server accept SSLHandshakeException: " + ssl.getLocalizedMessage(), s);
                                continue;
                            }
                            log.warning("Server accept SSLHandshakeException: " + ssl.getLocalizedMessage());
                            continue;
                        }
                        if (!this.alive) continue;
                        log.info("Server accept acception: " + ssl.getLocalizedMessage());
                    }
                    catch (Throwable e) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.WARNING, "Server accept exception:" + e.getLocalizedMessage(), e);
                    }
                }
            }
            catch (Throwable e) {
                if (!this.alive) continue;
                log.log(Level.SEVERE, scheme + ": Error in main loop.", e);
            }
        }
        log.info(scheme.toUpperCase() + " server stopped on port [" + port.getPublicServerPort() + "]");
        if (server != null) {
            try {
                server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop() {
        if (this.foxThread != null) {
            this.alive = false;
            this.foxThread.interrupt();
            this.foxThread = null;
            if (this.foxServerSocket != null) {
                try {
                    this.foxServerSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.foxServerSocket = null;
            }
        }
        if (this.foxsThread != null) {
            this.alive = false;
            this.foxsThread.interrupt();
            this.foxsThread = null;
            if (this.foxsServerSocket != null) {
                try {
                    this.foxsServerSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.foxsServerSocket = null;
            }
        }
        if (this.multicastServer != null) {
            this.multicastServer.kill();
            this.multicastServer = null;
        }
    }

    public abstract FoxConnection makeConnection(FoxSession var1, FoxMessage var2) throws Exception;

    public abstract FoxMessage getAnnouncement(FoxMessage var1);

    public abstract boolean authenticateBasic(FoxSession var1, String var2, String var3) throws Exception;

    public abstract boolean authenticateDigest(FoxSession var1, String var2, byte[] var3, byte[] var4) throws Exception;

    public void connectionAuthenticated(FoxConnection conn, FoxSession session, FoxMessage remoteHello) throws Exception {
    }

    private class MainLoop
    implements Runnable {
        private final String scheme;

        public MainLoop(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public void run() {
            if (this.scheme.equals(FoxServer.FOX)) {
                FoxServer.this.runFox();
            } else {
                FoxServer.this.runFoxs();
            }
        }
    }
}

