/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.encoding;

import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.xml.XException;

public final class BogCodec {
    public static void add(FoxMessage msg, String name, BValue object, Context context) throws IOException {
        ByteBuffer buf = BogCodec.encode(object, context);
        msg.add(name, "bog", buf.getBytes(), buf.getLength());
    }

    public static ByteBuffer encode(BValue object, Context context) throws IOException {
        ByteBuffer buf = new ByteBuffer(1024);
        ValueDocEncoder.BogEncoderPlugin plugin = new ValueDocEncoder.BogEncoderPlugin(buf.getOutputStream(), context);
        ValueDocEncoder out = new ValueDocEncoder((ValueDocEncoder.IEncoderPlugin)plugin, context);
        plugin.start("bog").attr("version", "1.0");
        if (object != null) {
            plugin.endAttr().newLine();
            out.setEncodeTransients(true);
            out.setEncodeComments(false);
            out.encode(object);
            plugin.end("bog").newLine();
        } else {
            plugin.end().newLine();
        }
        out.close();
        return buf;
    }

    static class Provider
    implements DecoderFactory.Provider {
        Provider() {
        }

        @Override
        public Object decode(byte[] buf, Object arg, Context cx) throws Exception {
            ValueDocDecoder.BogDecoderPlugin plugin = new ValueDocDecoder.BogDecoderPlugin((InputStream)new ByteArrayInputStream(buf), cx);
            ValueDocDecoder in = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)plugin, cx);
            in.next();
            if (!in.elem().name().equals("bog")) {
                throw new XException("Expected <bog>, not " + in.elem(), ((ValueDocDecoder.BogDecoderPlugin)in.getPlugin()).getXmlParser());
            }
            in.next();
            if (in.type() == 2) {
                return null;
            }
            return in.decode();
        }
    }
}

