/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class EmstpStats {
    InputStream in;
    String trunk;
    String portName;
    int port;
    int mstpBaudRate;
    int this_Station;
    int nMaxinfoframes;
    int nMaxMaster;
    int usageTimeOut;
    int forty_bit_delay;
    int txThrottle;
    int Master_State;
    int Receive_State;
    int NextStation;
    int PollStation;
    int SoleMaster;
    int FrameCount;
    int tokencount;
    int silenceTimer;
    int validFrameCount;
    int invalidFrameCount;
    int receivedTokens;
    int generatedTokens;
    int DeclareSoleMaster;
    int appRxCount;
    int appTxCount;
    int appRxPerMin;
    int appTxPerMin;
    int skipFrameCount;
    int unwantedFrameCount;
    int unexpectedFrameCount;
    int testRequest_rx;
    int testRequest_tx;
    int testResponse_rx;
    int testResponse_tx;
    int extFrames_rx;
    int extFrames_tx;
    int BadHeaderCrc;
    int BadDataCrc;
    int BadExtDataCrc;
    int appRxExtPerMin;
    int appTxExtPerMin;
    int appTxQ_fullCount;
    int appTxQ_overflowCount;
    int appTxQ_invalidStateCount;
    int emstpInvalidProtocol;
    int emstpInvalidCmd;
    int emstpInvalidLength;
    int usbTxFailures;
    int serialRxFramingErrors;
    int rxRingBufferOverflows;
    int emstpKeepAliveTimeouts;
    int retryTokenCnt;
    int tusage_cnt_err;
    int tusage_cnt_0_5;
    int tusage_cnt_5_10;
    int tusage_cnt_10_15;
    int tusage_cnt_15_20;
    int tusage_cnt_20_35;
    int tusage_cnt_35_85;
    int tusage_cnt_85_plus;
    int rxBytesTotal;
    int txBytesTotal;
    int rxBytesPerSec;
    int txBytesPerSec;
    String version;
    int serialTxTimeout;
    int usbTxBusy;
    String additionalStats;

    public EmstpStats(String port, String trunk) {
        this.trunk = trunk;
        this.portName = port;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void decodeStats() throws IOException {
        DataInputStream statsStream = new DataInputStream(this.in);
        byte[] versionBytes = new byte[64];
        this.port = statsStream.readInt();
        this.mstpBaudRate = statsStream.readInt();
        this.this_Station = statsStream.readInt();
        this.nMaxinfoframes = statsStream.readInt();
        this.nMaxMaster = statsStream.readInt();
        this.usageTimeOut = statsStream.readInt();
        this.forty_bit_delay = statsStream.readInt();
        this.txThrottle = statsStream.readInt();
        this.Master_State = statsStream.readInt();
        this.Receive_State = statsStream.readInt();
        this.NextStation = statsStream.readInt();
        this.PollStation = statsStream.readInt();
        this.SoleMaster = statsStream.readInt();
        this.FrameCount = statsStream.readInt();
        this.tokencount = statsStream.readInt();
        this.silenceTimer = statsStream.readInt();
        this.validFrameCount = statsStream.readInt();
        this.invalidFrameCount = statsStream.readInt();
        this.receivedTokens = statsStream.readInt();
        this.generatedTokens = statsStream.readInt();
        this.DeclareSoleMaster = statsStream.readInt();
        this.appRxCount = statsStream.readInt();
        this.appTxCount = statsStream.readInt();
        this.appRxPerMin = statsStream.readInt();
        this.appTxPerMin = statsStream.readInt();
        this.skipFrameCount = statsStream.readInt();
        this.unwantedFrameCount = statsStream.readInt();
        this.unexpectedFrameCount = statsStream.readInt();
        this.testRequest_rx = statsStream.readInt();
        this.testRequest_tx = statsStream.readInt();
        this.testResponse_rx = statsStream.readInt();
        this.testResponse_tx = statsStream.readInt();
        this.extFrames_rx = statsStream.readInt();
        this.extFrames_tx = statsStream.readInt();
        this.appRxExtPerMin = statsStream.readInt();
        this.appTxExtPerMin = statsStream.readInt();
        this.BadHeaderCrc = statsStream.readInt();
        this.BadDataCrc = statsStream.readInt();
        this.BadExtDataCrc = statsStream.readInt();
        this.appTxQ_fullCount = statsStream.readInt();
        this.appTxQ_overflowCount = statsStream.readInt();
        this.appTxQ_invalidStateCount = statsStream.readInt();
        this.emstpInvalidProtocol = statsStream.readInt();
        this.emstpInvalidCmd = statsStream.readInt();
        this.emstpInvalidLength = statsStream.readInt();
        this.usbTxFailures = statsStream.readInt();
        this.serialRxFramingErrors = statsStream.readInt();
        this.rxRingBufferOverflows = statsStream.readInt();
        this.emstpKeepAliveTimeouts = statsStream.readInt();
        this.retryTokenCnt = statsStream.readInt();
        this.tusage_cnt_err = statsStream.readInt();
        this.tusage_cnt_0_5 = statsStream.readInt();
        this.tusage_cnt_5_10 = statsStream.readInt();
        this.tusage_cnt_10_15 = statsStream.readInt();
        this.tusage_cnt_15_20 = statsStream.readInt();
        this.tusage_cnt_20_35 = statsStream.readInt();
        this.tusage_cnt_35_85 = statsStream.readInt();
        this.tusage_cnt_85_plus = statsStream.readInt();
        this.rxBytesTotal = statsStream.readInt();
        this.txBytesTotal = statsStream.readInt();
        this.rxBytesPerSec = statsStream.readInt();
        this.txBytesPerSec = statsStream.readInt();
        int len = statsStream.read(versionBytes, 0, versionBytes.length);
        if (len == -1) {
            this.version = "Unable to detect version";
        } else {
            versionBytes[63] = 0;
            this.version = new String(versionBytes, StandardCharsets.US_ASCII).trim();
        }
        if (statsStream.available() >= 8) {
            this.serialTxTimeout = statsStream.readInt();
            this.usbTxBusy = statsStream.readInt();
        } else {
            this.serialTxTimeout = 0;
            this.usbTxBusy = 0;
        }
    }

    public void addClientSideStats(String clientStats) {
        this.additionalStats = clientStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("------MSTP Config for " + this.trunk + "------\n");
        sb.append("serial port      : ").append(this.portName).append("\n");
        sb.append("trunk            : ").append(this.trunk).append("\n");
        sb.append("usart index      : ").append(this.port).append("\n");
        sb.append("baud rate        : ").append(this.mstpBaudRate).append("\n");
        sb.append("MAC address      : ").append(this.this_Station).append("\n");
        sb.append("max info frames  : ").append(this.nMaxinfoframes).append("\n");
        sb.append("max master       : ").append(this.nMaxMaster).append("\n");
        sb.append("usage timeout    : ").append(this.usageTimeOut).append("\n");
        sb.append("40 bit delay     : ").append(this.forty_bit_delay).append("\n");
        sb.append("txThrottle       : ").append(this.txThrottle).append("\n");
        sb.append("------MSTP state--------\n");
        sb.append("Master_State     : ").append(this.Master_State).append("\n");
        sb.append("Receive_State    : ").append(this.Receive_State).append("\n");
        sb.append("Next Station     : ").append(this.NextStation).append("\n");
        sb.append("Poll Station     : ").append(this.PollStation).append("\n");
        sb.append("SoleMaster       : ").append(this.SoleMaster).append("\n");
        sb.append("Frame Count      : ").append(this.FrameCount).append("\n");
        sb.append("Token Count      : ").append(this.tokencount).append("\n");
        sb.append("SilenceTimer     : ").append(this.silenceTimer).append("\n");
        sb.append("------Msg Counts--------\n");
        sb.append("valid frames     : ").append(this.validFrameCount).append("\n");
        sb.append("invalid frames   : ").append(this.invalidFrameCount).append("\n");
        sb.append("ReceivedTokens   : ").append(this.receivedTokens).append("\n");
        sb.append("GeneratedTokens  : ").append(this.generatedTokens).append("\n");
        sb.append("DeclareSoleMaster: ").append(this.DeclareSoleMaster).append("\n");
        sb.append("app rx           : ").append(this.appRxCount).append("\n");
        sb.append("app tx           : ").append(this.appTxCount).append("\n");
        sb.append("app rx per min   : ").append(this.appRxPerMin).append("\n");
        sb.append("app tx per min   : ").append(this.appTxPerMin).append("\n");
        sb.append("skipped frames   : ").append(this.skipFrameCount).append("\n");
        sb.append("unwanted frames  : ").append(this.unwantedFrameCount).append("\n");
        sb.append("unexpected frames: ").append(this.unexpectedFrameCount).append("\n");
        sb.append("testRequest_rx   : ").append(this.testRequest_rx).append("\n");
        sb.append("testRequest_tx   : ").append(this.testRequest_tx).append("\n");
        sb.append("testResponse_rx  : ").append(this.testResponse_rx).append("\n");
        sb.append("testResponse_tx  : ").append(this.testResponse_tx).append("\n");
        sb.append("extFrames_rx     : ").append(this.extFrames_rx).append("\n");
        sb.append("extFrames_tx     : ").append(this.extFrames_tx).append("\n");
        sb.append("ext rx per min   : ").append(this.appRxExtPerMin).append("\n");
        sb.append("ext tx per min   : ").append(this.appTxExtPerMin).append("\n");
        sb.append("bad header CRC   : ").append(this.BadHeaderCrc).append("\n");
        sb.append("bad data CRC16   : ").append(this.BadDataCrc).append("\n");
        sb.append("bad data CRC32   : ").append(this.BadExtDataCrc).append("\n");
        sb.append("appTxQ_full      : ").append(this.appTxQ_fullCount).append("\n");
        sb.append("appTxQ_overflow  : ").append(this.appTxQ_overflowCount).append("\n");
        sb.append("appTxQ_invalid   : ").append(this.appTxQ_invalidStateCount).append("\n");
        sb.append("emstpInvalProto  : ").append(this.emstpInvalidProtocol).append("\n");
        sb.append("emstpInvalCmd    : ").append(this.emstpInvalidCmd).append("\n");
        sb.append("emstpInvalLen    : ").append(this.emstpInvalidLength).append("\n");
        sb.append("usbTxFailures    : ").append(this.usbTxFailures).append("\n");
        sb.append("serRxFramingErr  : ").append(this.serialRxFramingErrors).append("\n");
        sb.append("ringBufOverflow  : ").append(this.rxRingBufferOverflows).append("\n");
        sb.append("emstpKeepAliveTO : ").append(this.emstpKeepAliveTimeouts).append("\n");
        sb.append("retry token cnt  : ").append(this.retryTokenCnt).append("\n");
        sb.append("t_usage_err      : ").append(this.tusage_cnt_err).append("\n");
        sb.append("t_usage_0_5ms    : ").append(this.tusage_cnt_0_5).append("\n");
        sb.append("t_usage_5_10ms   : ").append(this.tusage_cnt_5_10).append("\n");
        sb.append("t_usage_10_15ms  : ").append(this.tusage_cnt_10_15).append("\n");
        sb.append("t_usage_15_20ms  : ").append(this.tusage_cnt_15_20).append("\n");
        sb.append("t_usage_20_35ms  : ").append(this.tusage_cnt_20_35).append("\n");
        sb.append("t_usage_35_85ms  : ").append(this.tusage_cnt_35_85).append("\n");
        sb.append("t_usage_85_plus  : ").append(this.tusage_cnt_85_plus).append("\n");
        sb.append("rxBytesTotal     : ").append(this.rxBytesTotal).append("\n");
        sb.append("txBytesTotal     : ").append(this.txBytesTotal).append("\n");
        sb.append("rxBytesPerSec    : ").append(this.rxBytesPerSec).append("\n");
        sb.append("txBytesPerSec    : ").append(this.txBytesPerSec).append("\n");
        sb.append("serialTxTimeout  : ").append(this.serialTxTimeout).append("\n");
        sb.append("usbTxBusy        : ").append(this.usbTxBusy).append("\n");
        if (this.additionalStats != null) {
            sb.append(this.additionalStats);
        }
        sb.append("version          : ").append(this.version).append("\n");
        return sb.toString();
    }
}

