/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.platMstp.BBacnetMstpBaudRate;
import com.tridium.platMstp.BBacnetMstpSpecialBaudRate;
import com.tridium.platMstp.EmstpCommandEnum;
import com.tridium.platMstp.EmstpCommandPrefixEnum;
import com.tridium.platMstp.EmstpFrame;
import com.tridium.platMstp.EmstpStateEnum;
import com.tridium.platMstp.EmstpStats;
import com.tridium.platMstp.MstpFrame;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.sys.Clock;

public class EmstpStateMachine
implements Runnable {
    private final BISerialPort serialPort;
    private final String trunkName;
    private final EmstpStats statistics;
    private String osPortName;
    private boolean portDown;
    private BBaudRate baud = BBacnetMstpBaudRate.DEFAULT;
    private final LinkedBlockingDeque<MstpFrame> rxqueue;
    private final LinkedBlockingDeque<EmstpFrame> txqueue;
    private BufferedInputStream bufferedInputStream;
    private OutputStream serialOutputStream;
    Thread myThread;
    volatile boolean done = false;
    int bytesPerSec = 0;
    EmstpStateEnum state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
    boolean bufferAvailable = false;
    private int newAddress = -1;
    private int newMaxMaster = -1;
    private int newMaxInfoFrames = -1;
    private int newUsageTimeout = -1;
    private int newTxThrottle = -1;
    private int address = -1;
    private int maxMaster = -1;
    private int maxInfoFrames = -1;
    private int usageTimeout = -1;
    private int txThrottle = -1;
    private boolean commandPending;
    private boolean needToSetAddress;
    private boolean needToSetMaxMaster;
    private boolean needToSetMaxInfoFrames;
    private boolean needToSetUsageTimeout;
    private boolean needToSetTxThrottle;
    private boolean needToGetStatistics;
    private boolean needToResetStatistics;
    private boolean needToStartTokenPassing;
    private boolean needToStopTokenPassing;
    private boolean needToExitProcessorMode;
    private boolean needToRestartCoprocessorMode;
    private long keepAliveTicks;
    private int unknownEmstpMessages = 0;
    private int keepAliveSent = 0;
    private int txQ_fullCount = 0;
    private int ioErrorAvail = 0;
    public static Logger log = Logger.getLogger("platmstp");
    private static final int WAIT_RESPONSE_TIME = 10;
    private static final int KEEP_ALIVE_TIME = 3000;
    private static final int HOLD_TIME = 100;
    private static final int CONFIG_RESPONSE_TIME = 100;
    private static final String TMP_DIR = AccessController.doPrivileged(() -> System.getProperty("java.io.tmpdir"));

    public EmstpStateMachine(BISerialPort port, LinkedBlockingDeque<MstpFrame> rxq, LinkedBlockingDeque<EmstpFrame> txq, String trunk, EmstpStats stats) {
        this.serialPort = port;
        this.rxqueue = rxq;
        this.txqueue = txq;
        this.trunkName = trunk;
        this.statistics = stats;
        this.osPortName = this.serialPort.getOsPortName();
        try {
            this.serialOutputStream = this.serialPort.getOutputStream();
            this.bufferedInputStream = new BufferedInputStream(this.serialPort.getInputStream());
        }
        catch (IOException e) {
            log.severe("EmstpStateMachine " + this.osPortName + ": Unable to get i/o stream");
            this.done = true;
        }
    }

    public void setBytesPerSec(int bps) {
        this.bytesPerSec = bps;
    }

    public void setAddress(int address) {
        this.newAddress = address;
        this.needToSetAddress = true;
        this.commandPending = true;
    }

    public int getAddress() {
        return this.address;
    }

    public void setMaxMaster(int maxMaster) {
        this.newMaxMaster = maxMaster;
        this.needToSetMaxMaster = true;
        this.commandPending = true;
    }

    public void setMaxInfoFrames(int maxInfoFrames) {
        this.newMaxInfoFrames = maxInfoFrames;
        this.needToSetMaxInfoFrames = true;
        this.commandPending = true;
    }

    public void setUsageTimeout(int usageTimeout) {
        this.newUsageTimeout = usageTimeout;
        this.needToSetUsageTimeout = true;
        this.commandPending = true;
    }

    public void setTxThrottle(int txThrottle) {
        this.newTxThrottle = txThrottle;
        this.needToSetTxThrottle = true;
        this.commandPending = true;
    }

    public void pollStatistics() {
        this.needToGetStatistics = true;
        this.commandPending = true;
    }

    public void resetCounters() {
        this.needToResetStatistics = true;
        this.commandPending = true;
    }

    public void startTokenPassing() {
        this.needToStartTokenPassing = true;
        this.commandPending = true;
    }

    public void stopTokenPassing() {
        this.needToStopTokenPassing = true;
        this.commandPending = true;
    }

    public void exitCoprocessorMode() {
        this.needToExitProcessorMode = true;
        this.commandPending = true;
    }

    public void restartCoprocessorMode() {
        this.needToRestartCoprocessorMode = true;
        this.commandPending = true;
    }

    public void incrementQueueFullCount() {
        ++this.txQ_fullCount;
    }

    public void setBaudRate(BBacnetMstpBaudRate baudRate) {
        this.baud = baudRate;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.needToStartTokenPassing = false;
        this.needToStopTokenPassing = false;
        this.needToGetStatistics = false;
        this.needToResetStatistics = false;
        if (EmstpStateMachine.log.isLoggable(Level.FINE)) {
            EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": starting");
        }
        inframe = new EmstpFrame(this.bufferedInputStream);
        this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
lbl9:
        // 52 sources

        try {
            block46: while (!this.done) {
                if (this.portDown) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException var2_2) {
                        // empty catch block
                    }
                }
                try {
                    switch (1.$SwitchMap$com$tridium$platMstp$EmstpStateEnum[this.state.ordinal()]) {
                        case 1: {
                            try {
                                this.serialPort.doResetPort();
                                Thread.sleep(2000L);
                                this.serialPort.setSerialPortParams((BBaudRate)BBacnetMstpSpecialBaudRate.cdcEmstp, BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
                                Thread.sleep(100L);
                                this.serialPort.enableReceiveTimeout(100);
                                this.serialPort.enableReceiveThreshold(1);
                                this.serialPort.setSerialPortParams(this.baud, BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
                                Thread.sleep(100L);
                                this.needToSetAddress = true;
                                this.needToSetMaxMaster = true;
                                this.needToSetMaxInfoFrames = true;
                                this.needToSetUsageTimeout = true;
                                this.needToSetTxThrottle = true;
                                this.needToResetStatistics = true;
                                this.needToStartTokenPassing = true;
                                this.commandPending = true;
                                EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": Coprocessor mode");
                                this.state = EmstpStateEnum.SET_ADDR;
                            }
                            catch (InterruptedException var2_3) {}
                            continue block46;
                        }
                        case 2: {
                            try {
                                if (this.newAddress != -1) ** GOTO lbl47
                                Thread.sleep(100L);
                                ** GOTO lbl9
lbl47:
                                // 1 sources

                                inframe.flushInputStream();
                                this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_ADDR, this.newAddress);
                                Thread.sleep(100L);
                                inframe.readResponse();
                                this.portDown = false;
                                if (inframe.prefix != EmstpCommandPrefixEnum.ACK || inframe.command != EmstpCommandEnum.MSTP_SET_ADDR || inframe.statusByte != this.newAddress) ** GOTO lbl59
                                this.address = this.newAddress;
                                this.needToSetAddress = false;
                                if (EmstpStateMachine.log.isLoggable(Level.FINE)) {
                                    EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": MAC address is now " + this.address);
                                }
                                this.state = EmstpStateEnum.SET_MAX_MASTER;
                                ** GOTO lbl9
lbl59:
                                // 1 sources

                                if (inframe.command != EmstpCommandEnum.MSTP_COMMAND_UNKNOWN) ** GOTO lbl63
                                EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": No response to MSTP_SET_ADDR, resetting port");
                                this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                ** GOTO lbl9
lbl63:
                                // 1 sources

                                EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": Received " + (Object)inframe.command + " while expecting " + (Object)EmstpCommandEnum.MSTP_SET_ADDR + ", retrying");
                            }
                            catch (InterruptedException var2_4) {}
                            continue block46;
                        }
                        case 3: {
                            try {
                                if (this.newMaxMaster != -1) ** GOTO lbl72
                                Thread.sleep(100L);
                                ** GOTO lbl9
lbl72:
                                // 1 sources

                                inframe.flushInputStream();
                                this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_MAX_MASTER, this.newMaxMaster);
                                Thread.sleep(100L);
                                inframe.readResponse();
                                this.portDown = false;
                                if (inframe.prefix != EmstpCommandPrefixEnum.ACK || inframe.command != EmstpCommandEnum.MSTP_SET_MAX_MASTER || inframe.statusByte != this.newMaxMaster) ** GOTO lbl84
                                this.maxMaster = this.newMaxMaster;
                                this.needToSetMaxMaster = false;
                                if (EmstpStateMachine.log.isLoggable(Level.FINE)) {
                                    EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": MaxMaster is now " + this.maxMaster);
                                }
                                this.state = EmstpStateEnum.SET_MAX_INFO;
                                ** GOTO lbl9
lbl84:
                                // 1 sources

                                if (inframe.command == EmstpCommandEnum.MSTP_COMMAND_UNKNOWN) {
                                    EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": No response to MSTP_SET_MAX_MASTER, resetting port");
                                    this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                    continue block46;
                                }
                                EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": Received " + (Object)inframe.command + " while expecting " + (Object)EmstpCommandEnum.MSTP_SET_MAX_MASTER + ", retrying");
                            }
                            catch (InterruptedException var2_5) {}
                            continue block46;
                        }
                        case 4: {
                            try {
                                if (this.newMaxInfoFrames != -1) ** GOTO lbl97
                                Thread.sleep(100L);
                                ** GOTO lbl9
lbl97:
                                // 1 sources

                                inframe.flushInputStream();
                                this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_INFO_FRAMES, this.newMaxInfoFrames);
                                Thread.sleep(100L);
                                inframe.readResponse();
                                this.portDown = false;
                                if (inframe.prefix != EmstpCommandPrefixEnum.ACK || inframe.command != EmstpCommandEnum.MSTP_SET_INFO_FRAMES || inframe.statusByte != this.newMaxInfoFrames) ** GOTO lbl109
                                this.maxInfoFrames = this.newMaxInfoFrames;
                                this.needToSetMaxInfoFrames = false;
                                if (EmstpStateMachine.log.isLoggable(Level.FINE)) {
                                    EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": MaxInfoFrames is now " + this.maxInfoFrames);
                                }
                                this.state = EmstpStateEnum.SET_USAGE_TIMEOUT;
                                ** GOTO lbl9
lbl109:
                                // 1 sources

                                if (inframe.command == EmstpCommandEnum.MSTP_COMMAND_UNKNOWN) {
                                    EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": No response to MSTP_SET_INFO_FRAMES, resetting port");
                                    this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                    continue block46;
                                }
                                EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": Received " + (Object)inframe.command + " while expecting " + (Object)EmstpCommandEnum.MSTP_SET_INFO_FRAMES + ", retrying");
                            }
                            catch (InterruptedException var2_6) {}
                            continue block46;
                        }
                        case 5: {
                            try {
                                if (this.newUsageTimeout != -1) ** GOTO lbl122
                                Thread.sleep(100L);
                                ** GOTO lbl9
lbl122:
                                // 1 sources

                                inframe.flushInputStream();
                                this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_USAGE, this.newUsageTimeout);
                                Thread.sleep(100L);
                                inframe.readResponse();
                                this.portDown = false;
                                if (inframe.prefix != EmstpCommandPrefixEnum.ACK || inframe.command != EmstpCommandEnum.MSTP_SET_USAGE || inframe.statusByte != this.newUsageTimeout) ** GOTO lbl134
                                this.usageTimeout = this.newUsageTimeout;
                                this.needToSetUsageTimeout = false;
                                if (EmstpStateMachine.log.isLoggable(Level.FINE)) {
                                    EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": UsageTimeout is now " + this.usageTimeout);
                                }
                                this.state = EmstpStateEnum.SET_TX_THROTTLE;
                                ** GOTO lbl9
lbl134:
                                // 1 sources

                                if (inframe.command == EmstpCommandEnum.MSTP_COMMAND_UNKNOWN) {
                                    EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": No response to MSTP_SET_USAGE, resetting port");
                                    this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                    continue block46;
                                }
                                EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": Received " + (Object)inframe.command + " while expecting " + (Object)EmstpCommandEnum.MSTP_SET_USAGE + ", retrying");
                            }
                            catch (InterruptedException var2_7) {}
                            continue block46;
                        }
                        case 6: {
                            try {
                                if (this.newTxThrottle != -1) ** GOTO lbl147
                                Thread.sleep(100L);
                                ** GOTO lbl9
lbl147:
                                // 1 sources

                                inframe.flushInputStream();
                                this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_TX_THROTTLE, this.newTxThrottle);
                                Thread.sleep(100L);
                                inframe.readResponse();
                                this.portDown = false;
                                if (inframe.prefix != EmstpCommandPrefixEnum.ACK || inframe.command != EmstpCommandEnum.MSTP_SET_TX_THROTTLE || inframe.statusByte != this.newTxThrottle) ** GOTO lbl159
                                this.txThrottle = this.newTxThrottle;
                                this.needToSetTxThrottle = false;
                                if (EmstpStateMachine.log.isLoggable(Level.FINE)) {
                                    EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": TxThrottle is now " + this.txThrottle);
                                }
                                this.state = EmstpStateEnum.START_TOKEN_PASSING;
                                ** GOTO lbl9
lbl159:
                                // 1 sources

                                if (inframe.command == EmstpCommandEnum.MSTP_COMMAND_UNKNOWN) {
                                    EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": No response to MSTP_SET_TX_THROTTLE, resetting port");
                                    this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                    continue block46;
                                }
                                EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": Received " + (Object)inframe.command + " while expecting " + (Object)EmstpCommandEnum.MSTP_SET_TX_THROTTLE + ", retrying");
                            }
                            catch (InterruptedException var2_8) {}
                            continue block46;
                        }
                        case 7: {
                            try {
                                inframe.flushInputStream();
                                this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_START, 0);
                                Thread.sleep(100L);
                                inframe.readResponse();
                                this.portDown = false;
                                if (inframe.prefix != EmstpCommandPrefixEnum.ACK || inframe.command != EmstpCommandEnum.MSTP_START) ** GOTO lbl181
                                EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": Token passing started on " + this.trunkName);
                                this.bufferAvailable = inframe.isBufferAvailable();
                                this.state = EmstpStateEnum.CHECK_TRANSMIT;
                                this.keepAliveTicks = Clock.ticks();
                                this.needToStartTokenPassing = false;
                                ** GOTO lbl9
lbl181:
                                // 1 sources

                                if (inframe.command == EmstpCommandEnum.MSTP_COMMAND_UNKNOWN) {
                                    EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": No response to MSTP_START, resetting port");
                                    this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                                    continue block46;
                                }
                                EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": Received " + (Object)inframe.command + " while expecting " + (Object)EmstpCommandEnum.MSTP_START + ", retrying");
                            }
                            catch (InterruptedException var2_9) {}
                            continue block46;
                        }
                        case 8: {
                            if (!this.commandPending) ** GOTO lbl242
                            if (!this.needToSetAddress) ** GOTO lbl195
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_ADDR, this.newAddress);
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            ** GOTO lbl9
lbl195:
                            // 1 sources

                            if (!this.needToSetMaxMaster) ** GOTO lbl199
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_MAX_MASTER, this.newMaxMaster);
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            ** GOTO lbl9
lbl199:
                            // 1 sources

                            if (!this.needToSetMaxInfoFrames) ** GOTO lbl203
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_INFO_FRAMES, this.newMaxInfoFrames);
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            ** GOTO lbl9
lbl203:
                            // 1 sources

                            if (!this.needToSetUsageTimeout) ** GOTO lbl207
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_USAGE, this.newUsageTimeout);
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            ** GOTO lbl9
lbl207:
                            // 1 sources

                            if (!this.needToSetTxThrottle) ** GOTO lbl211
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_SET_TX_THROTTLE, this.newTxThrottle);
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            ** GOTO lbl9
lbl211:
                            // 1 sources

                            if (!this.needToGetStatistics) ** GOTO lbl216
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_GET_STATS, 0);
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            this.needToGetStatistics = false;
                            ** GOTO lbl9
lbl216:
                            // 1 sources

                            if (!this.needToResetStatistics) ** GOTO lbl221
                            this.resetHostStatistics();
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_RESET_STATS, 0);
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            ** GOTO lbl9
lbl221:
                            // 1 sources

                            if (!this.needToStartTokenPassing) ** GOTO lbl225
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_START, 0);
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            ** GOTO lbl9
lbl225:
                            // 1 sources

                            if (!this.needToStopTokenPassing) ** GOTO lbl229
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_STOP, 0);
                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            ** GOTO lbl9
lbl229:
                            // 1 sources

                            if (!this.needToExitProcessorMode) ** GOTO lbl237
                            this.serialPort.setSerialPortParams((BBaudRate)BBacnetMstpSpecialBaudRate.cdcNormal, BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
                            this.serialPort.disableReceiveThreshold();
                            this.serialPort.disableReceiveTimeout();
                            this.serialPort.setSerialPortParams(this.baud, BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
                            this.needToExitProcessorMode = false;
                            this.commandPending = false;
                            ** GOTO lbl9
lbl237:
                            // 1 sources

                            if (!this.needToRestartCoprocessorMode) ** GOTO lbl241
                            this.needToRestartCoprocessorMode = false;
                            this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                            ** GOTO lbl9
lbl241:
                            // 1 sources

                            this.commandPending = false;
lbl242:
                            // 2 sources

                            if (!this.bufferAvailable) ** GOTO lbl261
                            txFrame = this.txqueue.poll();
                            if (txFrame != null) {
                                if (txFrame.command == EmstpCommandEnum.MSTP_APP_TX) {
                                    if (!this.txqueue.isEmpty()) {
                                        txFrame.setMoreMessagesToSend(true);
                                    }
                                    transmitBytes = txFrame.encodeToTransmit().toByteArray();
                                    this.serialOutputStream.write(transmitBytes, 0, transmitBytes.length);
                                    try {
                                        sleepTime = transmitBytes.length * 1000 / this.bytesPerSec + 1;
                                        Thread.sleep(sleepTime);
                                    }
                                    catch (InterruptedException sleepTime) {
                                        // empty catch block
                                    }
                                    if (EmstpStateMachine.log.isLoggable(Level.FINE)) {
                                        EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": Sent " + (Object)txFrame.command + " to " + txFrame.mstpFrame.getAddr() + " len:" + txFrame.payloadLength);
                                    }
                                } else {
                                    EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": Unexpected msg type in txqueue: " + (Object)txFrame.command);
                                }
                            }
                            ** GOTO lbl268
lbl261:
                            // 1 sources

                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException txFrame) {
                                // empty catch block
                            }
                            if (this.txqueue.size() > 0 && EmstpStateMachine.log.isLoggable(Level.FINE)) {
                                EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": " + this.txqueue.size() + " msgs are waiting for buffer available");
                            }
lbl268:
                            // 5 sources

                            this.state = EmstpStateEnum.CHECK_RECEIVE;
                            ** GOTO lbl9
                        }
                        case 9: {
                            bytesAvailable = this.bufferedInputStream.available();
                            if (bytesAvailable >= 0) ** GOTO lbl283
                            ++this.ioErrorAvail;
                            EmstpStateMachine.log.log(Level.SEVERE, "EmstpStateMachine " + this.osPortName + ": error getting num bytes available");
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                this.done = true;
                                ** GOTO lbl9
                            }
                            this.state = EmstpStateEnum.ENTER_COPROCESSOR_MODE;
                            ** GOTO lbl9
lbl283:
                            // 1 sources

                            if (bytesAvailable != 0) ** GOTO lbl299
                            ticks = Clock.ticks();
                            if (ticks - this.keepAliveTicks <= 3000L) ** GOTO lbl292
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_KEEP_ALIVE, 0);
                            if (EmstpStateMachine.log.isLoggable(Level.FINE)) {
                                EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": Send MSTP_KEEP_ALIVE");
                            }
                            ++this.keepAliveSent;
                            this.keepAliveTicks = ticks;
                            ** GOTO lbl9
lbl292:
                            // 1 sources

                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException var5_27) {
                                // empty catch block
                            }
                            this.state = EmstpStateEnum.CHECK_TRANSMIT;
                            ** GOTO lbl9
lbl299:
                            // 1 sources

                            this.serialPort.enableReceiveThreshold(bytesAvailable);
                            inframe.readResponse();
                            this.portDown = false;
                            this.keepAliveTicks = Clock.ticks();
                            if (EmstpCommandEnum.MSTP_COMMAND_UNKNOWN != inframe.command) ** GOTO lbl307
                            EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": Received " + (Object)inframe.command);
                            ++this.unknownEmstpMessages;
                            ** GOTO lbl9
lbl307:
                            // 1 sources

                            if (inframe.prefix != EmstpCommandPrefixEnum.ACK) ** GOTO lbl374
                            this.bufferAvailable = inframe.isBufferAvailable();
                            if (EmstpStateMachine.log.isLoggable(Level.FINE)) {
                                EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": Received ACK to " + (Object)inframe.command + " bufferAvail:" + this.bufferAvailable);
                            }
                            if (inframe.command != EmstpCommandEnum.MSTP_APP_TX) ** GOTO lbl314
                            this.state = EmstpStateEnum.CHECK_TRANSMIT;
                            ** GOTO lbl9
lbl314:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_SET_ADDR) ** GOTO lbl318
                            this.needToSetAddress = false;
                            this.address = inframe.getStatusByte();
                            ** GOTO lbl9
lbl318:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_SET_MAX_MASTER) ** GOTO lbl322
                            this.needToSetMaxMaster = false;
                            this.maxMaster = inframe.getStatusByte();
                            ** GOTO lbl9
lbl322:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_SET_INFO_FRAMES) ** GOTO lbl326
                            this.needToSetMaxInfoFrames = false;
                            this.maxInfoFrames = inframe.getStatusByte();
                            ** GOTO lbl9
lbl326:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_SET_USAGE) ** GOTO lbl330
                            this.needToSetUsageTimeout = false;
                            this.usageTimeout = inframe.getStatusByte();
                            ** GOTO lbl9
lbl330:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_RESET_STATS) ** GOTO lbl333
                            this.needToResetStatistics = false;
                            ** GOTO lbl9
lbl333:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_START) ** GOTO lbl336
                            this.needToStartTokenPassing = false;
                            ** GOTO lbl9
lbl336:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_STOP) ** GOTO lbl339
                            this.needToStopTokenPassing = false;
                            ** GOTO lbl9
lbl339:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_SET_TX_THROTTLE) ** GOTO lbl343
                            this.needToSetTxThrottle = false;
                            this.txThrottle = inframe.statusByte;
                            ** GOTO lbl9
lbl343:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_GET_STATS) continue block46;
                            this.needToGetStatistics = false;
                            in = new ByteArrayInputStream(inframe.getPayload());
                            this.statistics.setInputStream(in);
                            try {
                                this.statistics.decodeStats();
                                sb = new StringBuilder();
                                sb.append("keepAliveSent    : ").append(this.keepAliveSent).append('\n');
                                sb.append("txMsgBufferFull  : ").append(this.txQ_fullCount).append('\n');
                                sb.append("unknownEmstpMsgs : ").append(this.unknownEmstpMessages).append('\n');
                                sb.append("ioErrorGetAvail  : ").append(this.ioErrorAvail).append('\n');
                                sb.append("emstpTxqSize     : ").append(this.txqueue.size()).append('\n');
                                sb.append("emstpRxqSize     : ").append(this.rxqueue.size()).append('\n');
                                this.statistics.addClientSideStats(sb.toString());
                            }
                            catch (IOException e) {
                                EmstpStateMachine.log.log(Level.WARNING, "EmstpStateMachine " + this.osPortName + ": Error decoding statistics", e);
                            }
                            statsFile = EmstpStateMachine.TMP_DIR + File.separatorChar + this.trunkName;
                            try {
                                AccessController.doPrivileged((PrivilegedExceptionAction<Void>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$run$0(java.lang.String ), ()Ljava/lang/Void;)((EmstpStateMachine)this, (String)statsFile));
                            }
                            catch (PrivilegedActionException ioException) {
                                EmstpStateMachine.log.log(Level.WARNING, "EmstpStateMachine " + this.osPortName + ": Unable to create or use mstp statistics file " + statsFile, ioException);
                            }
                            continue block46;
lbl374:
                            // 1 sources

                            if (inframe.prefix != EmstpCommandPrefixEnum.USOL) ** GOTO lbl410
                            this.bufferAvailable = inframe.isBufferAvailable();
                            if (inframe.command != EmstpCommandEnum.MSTP_APP_RX) ** GOTO lbl393
                            srcbuf = inframe.getPayload();
                            if (srcbuf == null) ** GOTO lbl391
                            appFrame = new MstpFrame();
                            appFrame.setSrcAddr(srcbuf[0]);
                            appFrame.setDataExpectingReply(srcbuf[1] == 1);
                            data = new byte[srcbuf.length - 2];
                            System.arraycopy(srcbuf, 2, data, 0, data.length);
                            appFrame.setData(data);
                            if (this.rxqueue.offerLast(appFrame)) ** GOTO lbl388
                            EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": rxqueue full trying to post app message received from " + appFrame.getAddr() + ", length=" + data.length);
                            ** GOTO lbl9
lbl388:
                            // 1 sources

                            if (!EmstpStateMachine.log.isLoggable(Level.FINE)) continue block46;
                            EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": app message received from " + appFrame.getAddr() + ", length=" + data.length);
                            ** GOTO lbl9
lbl391:
                            // 1 sources

                            EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": invalid data payload");
                            ** GOTO lbl9
lbl393:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_OK_TO_SEND) ** GOTO lbl398
                            this.state = EmstpStateEnum.CHECK_TRANSMIT;
                            if (!EmstpStateMachine.log.isLoggable(Level.FINE)) continue block46;
                            EmstpStateMachine.log.fine("EmstpStateMachine " + this.osPortName + ": Received " + (Object)inframe.command + " bufferAvail:" + inframe.isBufferAvailable());
                            ** GOTO lbl9
lbl398:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_KEEP_ALIVE_EXPIRED) ** GOTO lbl403
                            EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": Received " + (Object)inframe.command);
                            this.sendCommand(this.serialOutputStream, EmstpCommandEnum.MSTP_KEEP_ALIVE, 0);
                            ++this.keepAliveSent;
                            ** GOTO lbl9
lbl403:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_DEVICE_DOWN) ** GOTO lbl408
                            EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": " + (Object)inframe.command + " address " + inframe.statusByte);
                            addr = inframe.statusByte;
                            this.purgeDownDeviceFromTxQueue(addr);
                            ** GOTO lbl9
lbl408:
                            // 1 sources

                            EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": Received unexpected emstp frame type");
                            ** GOTO lbl9
lbl410:
                            // 1 sources

                            if (inframe.prefix != EmstpCommandPrefixEnum.NAK) ** GOTO lbl427
                            EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": Received NAK to " + (Object)inframe.command);
                            if (inframe.command != EmstpCommandEnum.MSTP_SET_ADDR) ** GOTO lbl415
                            this.needToSetAddress = false;
                            ** GOTO lbl9
lbl415:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_SET_MAX_MASTER) ** GOTO lbl418
                            this.needToSetMaxMaster = false;
                            ** GOTO lbl9
lbl418:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_SET_INFO_FRAMES) ** GOTO lbl421
                            this.needToSetMaxInfoFrames = false;
                            ** GOTO lbl9
lbl421:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_SET_USAGE) ** GOTO lbl424
                            this.needToSetUsageTimeout = false;
                            ** GOTO lbl9
lbl424:
                            // 1 sources

                            if (inframe.command != EmstpCommandEnum.MSTP_SET_TX_THROTTLE) continue block46;
                            this.needToSetTxThrottle = false;
                            ** GOTO lbl9
lbl427:
                            // 1 sources

                            EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": Received unexpected message type " + (Object)inframe.command);
                            ** GOTO lbl9
                        }
                    }
                    EmstpStateMachine.log.warning("EmstpStateMachine " + this.osPortName + ": Undefined state machine state");
                }
                catch (IOException ioe) {
                    if (!this.portDown) {
                        EmstpStateMachine.log.log(Level.SEVERE, "EmstpStateMachine " + this.osPortName + ": IOException", ioe.getMessage());
                    }
                    this.portDown = true;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            EmstpStateMachine.log.log(Level.SEVERE, "EmstpStateMachine " + this.osPortName + ": undhandled throwable", throwable);
            throw throwable;
        }
        finally {
            EmstpStateMachine.log.info("EmstpStateMachine " + this.osPortName + ": done");
        }
    }

    private void sendCommand(OutputStream serialOutputStream, EmstpCommandEnum cmd, int val) throws IOException {
        byte[] bytes = new byte[]{(byte)(val & 0xFF)};
        EmstpFrame cmdFrame = new EmstpFrame(EmstpCommandPrefixEnum.REQ, cmd, bytes);
        byte[] sendBytes = cmdFrame.encodeToTransmit().toByteArray();
        serialOutputStream.write(sendBytes, 0, sendBytes.length);
        this.portDown = false;
    }

    private void emptyStream(InputStream in) {
        try {
            in.skip(in.available());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resetHostStatistics() {
        this.keepAliveSent = 0;
        this.txQ_fullCount = 0;
        this.unknownEmstpMessages = 0;
        this.ioErrorAvail = 0;
    }

    private void purgeDownDeviceFromTxQueue(int addr) {
        this.txqueue.removeIf(frame -> frame.getCommand() == EmstpCommandEnum.MSTP_APP_TX && frame.getMstpAddress() == addr);
    }

    private /* synthetic */ Void lambda$run$0(String statsFile) throws Exception {
        try (FileWriter myWriter = new FileWriter(statsFile, false);){
            myWriter.write(this.statistics.toString());
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "EmstpStateMachine " + this.osPortName + ": Cannot create statistics file " + statsFile, e);
        }
        return null;
    }
}

