/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.platMstp.BBacnetMstpBaudRate;
import com.tridium.platMstp.BBacnetMstpPlatformService;
import com.tridium.platMstp.BBacnetMstpSpecialBaudRate;
import com.tridium.platMstp.EmstpCommandEnum;
import com.tridium.platMstp.EmstpCommandPrefixEnum;
import com.tridium.platMstp.EmstpFrame;
import com.tridium.platMstp.EmstpStateMachine;
import com.tridium.platMstp.EmstpStats;
import com.tridium.platMstp.MstpFrame;
import com.tridium.platMstp.MstpListener;
import com.tridium.platSerial.BSerialPort;
import com.tridium.platSerial.BSerialPortPlatformService;
import com.tridium.sys.Nre;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperty(name="txThrottle", type="int", defaultValue="10", flags=4, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(20), BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")})
public class BBacnetMstpPlatformServiceEmstp
extends BBacnetMstpPlatformService {
    @Generated
    public static final Property txThrottle = BBacnetMstpPlatformServiceEmstp.newProperty((int)4, (int)10, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)20), (String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMstpPlatformServiceEmstp.class);
    private final HashMap<Integer, EmstpTrunkListener> emstpTrunkListeners = new HashMap();
    private final HashMap<Integer, BISerialPort> serialPorts = new HashMap();
    private final HashMap<Integer, EmstpStateMachine> emstpStateMachines = new HashMap();
    private final HashMap<Integer, LinkedBlockingDeque<EmstpFrame>> transmitQueues = new HashMap();
    private final HashMap<Integer, EmstpStats> statsHashMap = new HashMap();
    protected boolean usingCoprocessor;

    @Generated
    public int getTxThrottle() {
        return this.getInt(txThrottle);
    }

    @Generated
    public void setTxThrottle(int v) {
        this.setInt(txThrottle, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if ("edge10".equalsIgnoreCase(Nre.getHostModel().toLowerCase(Locale.US))) {
            this.setUseCoprocessor(false);
        }
        super.started();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(useCoprocessor)) {
            if ("edge10".equalsIgnoreCase(Nre.getHostModel().toLowerCase(Locale.US))) {
                if (this.getUseCoprocessor()) {
                    this.setUseCoprocessor(false);
                    log.warning("BacnetMstp: Coprocessor mode not supported on this platform type");
                }
            } else {
                log.info("BacnetMstp: Coprocessor mode changed to " + this.getUseCoprocessor() + ", will not take affect until reboot");
            }
        } else if (p.equals(txThrottle)) {
            log.info("BacnetMstp: setting txThrottle to " + this.getTxThrottle());
            this.emstpStateMachines.forEach((k, stateMachine) -> stateMachine.setTxThrottle(this.getTxThrottle()));
        }
    }

    public boolean isValidPlatform() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.emstp.enabled")) != false;
    }

    public void serviceStarted() throws Exception {
        this.usingCoprocessor = true;
        if (!this.getUseCoprocessor() || "edge10".equalsIgnoreCase(Nre.getHostModel().toLowerCase(Locale.US))) {
            this.usingCoprocessor = false;
        }
        if (!this.initMstp()) {
            throw new RuntimeException("failed to initialize mstp platform driver");
        }
        log.fine("BacnetMstp: Mstp platform service started");
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        this.cleanupMstp();
        log.fine("BacnetMstp: Mstp platform service stopped");
        super.serviceStopped();
    }

    @Override
    protected boolean initMstp() {
        return true;
    }

    @Override
    protected void cleanupMstp() {
    }

    @Override
    public int startDriver(String trunk, String osSerialPortName, int baudRate, int tsAddr, int maxMaster, int maxFrames, MstpListener linkListener) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Starting mstp driver on " + osSerialPortName + " at " + baudRate + " baud, tsAddr=" + tsAddr + " maxMaster=" + maxMaster + " maxInfoFrames=" + maxFrames);
        }
        if (osSerialPortName == null) {
            throw new NullPointerException("BacnetMstp: Invalid serial port");
        }
        if (this.usingCoprocessor) {
            int handle = this.startCoprocessorDriver(trunk, osSerialPortName, baudRate, tsAddr, maxMaster, maxFrames, linkListener);
            return handle;
        }
        return this.startDriverLegacy(trunk, osSerialPortName, baudRate, tsAddr, maxMaster, maxFrames, linkListener);
    }

    @Override
    public void stopDriver(int handle) {
        if (this.usingCoprocessor) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("BacnetMstp: Stopping mstp coprocessor driver on " + this.serialPorts.get(handle).getOsPortName());
            }
            this.stopCoprocessorDriver(handle);
        } else {
            this.stopDriverLegacy(handle);
        }
    }

    public EmstpStats getStatistics(int handle) {
        return this.statsHashMap.get(handle);
    }

    private int startCoprocessorDriver(String trunk, String osSerialPortName, int baudRate, int tsAddr, int maxMaster, int maxFrames, MstpListener linkListener) {
        Thread trunkListenerThread;
        BISerialPort serialPort;
        BISerialService platSvc;
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Mstp platform service is using mstp coprocessor for " + trunk + " on " + osSerialPortName);
        }
        try {
            platSvc = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            log.severe("BacnetMstp: Cannot find serial platform service");
            throw new RuntimeException("BacnetMstp: Cannot find serial platform service");
        }
        String portName = this.getSerialPortNameFromOsName(osSerialPortName);
        if (portName == null) {
            log.severe("BacnetMstp: Cannot find port for name " + osSerialPortName);
            throw new RuntimeException("BacnetMstp: Cannot find port for name " + osSerialPortName);
        }
        try {
            serialPort = platSvc.openPort(portName, "BacnetEmstp");
            serialPort.setSerialPortParams((BBaudRate)BSerialBaudRate.make((int)baudRate), BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
        }
        catch (PortNotFoundException pnfe) {
            log.severe("BacnetMstp: Cannot find serial port for coprocessor operation: " + osSerialPortName);
            throw new RuntimeException("BacnetMstp: Cannot find serial port for coprocessor operation: " + osSerialPortName);
        }
        catch (PortDeniedException pde) {
            log.severe("BacnetMstp: Port already in use " + osSerialPortName);
            throw new RuntimeException("Port already in use " + osSerialPortName);
        }
        int offset = portName.length();
        for (int i = portName.length() - 1; i >= 0; --i) {
            char c = portName.charAt(i);
            if (!Character.isDigit(c)) continue;
            --offset;
        }
        int handle = Integer.parseInt(portName.substring(offset));
        this.serialPorts.put(handle, serialPort);
        String trunkName = trunk.substring(trunk.lastIndexOf(47) + 1);
        LinkedBlockingDeque<EmstpFrame> transmitQueue = new LinkedBlockingDeque<EmstpFrame>(32);
        LinkedBlockingDeque<MstpFrame> receiveQueue = new LinkedBlockingDeque<MstpFrame>(32);
        this.transmitQueues.put(handle, transmitQueue);
        EmstpTrunkListener trunkListener = new EmstpTrunkListener(linkListener, receiveQueue);
        trunkListener.emstpTrunkListenerThread = trunkListenerThread = new Thread((Runnable)trunkListener, "BacnetMstp:EmstpTrunkListener" + handle);
        trunkListenerThread.start();
        this.emstpTrunkListeners.put(handle, trunkListener);
        EmstpStats stats = new EmstpStats(portName, trunkName);
        this.statsHashMap.put(handle, stats);
        EmstpStateMachine stateMachine = new EmstpStateMachine(serialPort, receiveQueue, transmitQueue, trunkName, stats);
        stateMachine.setAddress(tsAddr);
        stateMachine.setMaxMaster(maxMaster);
        stateMachine.setMaxInfoFrames(maxFrames);
        stateMachine.setTxThrottle(this.getTxThrottle());
        stateMachine.setBytesPerSec(baudRate / 10);
        stateMachine.setBaudRate(BBacnetMstpBaudRate.make(baudRate));
        Thread emstpStateMachineThread = new Thread((Runnable)stateMachine, "BacnetMstp:EmstpStateMachine" + handle);
        emstpStateMachineThread.start();
        stateMachine.myThread = emstpStateMachineThread;
        this.emstpStateMachines.put(handle, stateMachine);
        return handle;
    }

    private void stopCoprocessorDriver(int handle) {
        EmstpStateMachine sm = this.emstpStateMachines.get(handle);
        if (sm == null) {
            log.warning("BacnetMstp: Emstp state machine handle invalid while stopping");
        } else {
            try {
                sm.stopTokenPassing();
                Thread.sleep(100L);
                sm.exitCoprocessorMode();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.fine("BacnetMstp: Mstp coprocessor thread interrupted while shutting down");
            }
            sm.done = true;
            this.emstpStateMachines.remove(handle);
        }
        EmstpTrunkListener emstpTrunkListener = this.emstpTrunkListeners.get(handle);
        if (emstpTrunkListener == null) {
            log.warning("BacnetMstp: Mstp Trunk listener handle invalid while stopping mstp coprocessor mode");
        } else {
            emstpTrunkListener.done = true;
            emstpTrunkListener.emstpTrunkListenerThread.interrupt();
            this.emstpTrunkListeners.remove(handle);
        }
        BISerialPort serialPort = this.serialPorts.get(handle);
        if (serialPort == null) {
            log.warning("BacnetMstp: Serial port handle invalid while stopping mstp coprocessor mode");
        } else {
            serialPort.setSerialPortParams((BBaudRate)BBacnetMstpSpecialBaudRate.cdcNormal, BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
            serialPort.close();
            this.serialPorts.remove(handle);
        }
        LinkedBlockingDeque<EmstpFrame> transmitQueue = this.transmitQueues.get(handle);
        if (transmitQueue != null) {
            transmitQueue.clear();
            this.transmitQueues.remove(handle);
        }
        this.statsHashMap.remove(handle);
    }

    @Override
    public void sendFrame(int handle, byte destAddr, byte[] packet, boolean dataExpectingReply) {
        if (packet.length > 1497) {
            throw new IllegalArgumentException("BacnetMstp: Invalid frame length " + packet.length);
        }
        if (this.usingCoprocessor) {
            MstpFrame frame = new MstpFrame(destAddr, packet, dataExpectingReply);
            EmstpFrame emstpFrame = new EmstpFrame(EmstpCommandPrefixEnum.REQ, EmstpCommandEnum.MSTP_APP_TX, frame);
            LinkedBlockingDeque<EmstpFrame> txQ = this.transmitQueues.get(handle);
            if (!txQ.offerLast(emstpFrame)) {
                EmstpStateMachine sm = this.emstpStateMachines.get(handle);
                sm.incrementQueueFullCount();
            }
        } else {
            this.sendFrameLegacy(handle, (byte)(destAddr & 0xFF), packet, dataExpectingReply);
        }
    }

    @Override
    public void setBaudRate(int handle, int baudRate) {
        BISerialPort serialPort = this.serialPorts.get(handle);
        serialPort.setSerialPortParams((BBaudRate)BBacnetMstpBaudRate.make(baudRate), BSerialDataBits.dataBits8, BSerialStopBits.stopBit1, BSerialParity.none);
        if (!this.usingCoprocessor) {
            this.setBaudRateLegacy(handle, baudRate);
        } else {
            EmstpStateMachine sm = this.emstpStateMachines.get(handle);
            sm.setBaudRate(BBacnetMstpBaudRate.make(baudRate));
        }
    }

    @Override
    public void setMaxMaster(int handle, int maxMaster) {
        if (this.usingCoprocessor) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("BacnetMstp: Setting max master on " + this.serialPorts.get(handle).getOsPortName() + " to " + maxMaster);
            }
            EmstpStateMachine sm = this.emstpStateMachines.get(handle);
            sm.setMaxMaster(maxMaster);
        } else {
            this.setMaxMasterLegacy(handle, maxMaster);
        }
    }

    @Override
    public void setMaxInfoFrames(int handle, int maxInfoFrames) {
        if (this.usingCoprocessor) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("BacnetMstp: Setting max info frames on " + this.serialPorts.get(handle).getOsPortName() + " to " + maxInfoFrames);
            }
            EmstpStateMachine sm = this.emstpStateMachines.get(handle);
            sm.setMaxInfoFrames(maxInfoFrames);
        } else {
            this.setMaxInfoFramesLegacy(handle, maxInfoFrames);
        }
    }

    @Override
    public void setAddress(int handle, int macAddress) {
        if (this.usingCoprocessor) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("BacnetMstp: Setting address on " + this.serialPorts.get(handle).getOsPortName() + " to " + macAddress);
            }
            EmstpStateMachine sm = this.emstpStateMachines.get(handle);
            sm.setAddress(macAddress);
        } else {
            this.setAddressLegacy(handle, macAddress);
        }
    }

    @Override
    public int getAddress(int handle) {
        if (this.usingCoprocessor) {
            EmstpStateMachine sm = this.emstpStateMachines.get(handle);
            if (sm == null) {
                throw new RuntimeException("BacnetMstp: EmstpStateMachine is null");
            }
            return sm.getAddress();
        }
        return this.getAddressLegacy(handle);
    }

    @Override
    public void setParameter(int handle, String name, String value) {
        if (name == null || value == null) {
            throw new RuntimeException("BacnetMstp: Null mstp parameter");
        }
        if (this.usingCoprocessor) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("BacnetMstp: Setting parameter " + name + " on " + this.serialPorts.get(handle).getOsPortName() + " to " + value);
            }
            EmstpStateMachine sm = this.emstpStateMachines.get(handle);
            if ("usageTimeout".equalsIgnoreCase(name)) {
                sm.setUsageTimeout(Integer.parseInt(value));
            } else if ("resetCounters".equalsIgnoreCase(name)) {
                sm.resetCounters();
            } else if ("getStatistics".equalsIgnoreCase(name)) {
                sm.pollStatistics();
            } else if ("txThrottle".equalsIgnoreCase(name)) {
                sm.setTxThrottle(Integer.parseInt(value));
            } else {
                log.warning("BacnetMstp: Attempt to set unknown parameter " + value);
            }
        } else {
            this.setParameterLegacy(handle, name, value);
        }
    }

    private String getSerialPortNameFromOsName(String osPortName) {
        String[] portNames;
        BSerialPortPlatformService service = BBacnetMstpPlatformServiceEmstp.getSerialService();
        if (service == null) {
            log.severe("BacnetMstp: Cannot lock serial port " + osPortName);
            return null;
        }
        for (String portName : portNames = service.getPortNames()) {
            BSerialPort serialPort = (BSerialPort)service.get(portName);
            if (!serialPort.getOsPortName().equalsIgnoreCase(osPortName)) continue;
            return portName;
        }
        return null;
    }

    protected int startDriverLegacy(String trunk, String osSerialPortName, int baudRate, int tsAddr, int maxMaster, int maxFrames, MstpListener linkListener) {
        throw new IllegalStateException();
    }

    protected void stopDriverLegacy(int handle) {
        throw new IllegalStateException();
    }

    protected void sendFrameLegacy(int handle, byte destAddr, byte[] frame, boolean dataExpectingReply) {
        throw new IllegalStateException();
    }

    protected void setBaudRateLegacy(int handle, int baudRate) {
        throw new IllegalStateException();
    }

    protected void setMaxMasterLegacy(int handle, int maxMaster) {
        throw new IllegalStateException();
    }

    protected void setMaxInfoFramesLegacy(int handle, int maxInfoFrames) {
        throw new IllegalStateException();
    }

    protected void setAddressLegacy(int handle, int macAddress) {
        throw new IllegalStateException();
    }

    protected int getAddressLegacy(int handle) {
        throw new IllegalStateException();
    }

    protected void setParameterLegacy(int handle, String name, String value) {
        throw new IllegalStateException();
    }

    static class EmstpTrunkListener
    implements Runnable {
        MstpListener linkListener;
        LinkedBlockingDeque<MstpFrame> rxqueue;
        Thread emstpTrunkListenerThread;
        boolean done;

        public EmstpTrunkListener(MstpListener linkListener, LinkedBlockingDeque<MstpFrame> rxqueue) {
            this.linkListener = linkListener;
            this.rxqueue = rxqueue;
            this.done = false;
        }

        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            if (BBacnetMstpPlatformService.log.isLoggable(Level.FINE)) {
                BBacnetMstpPlatformService.log.fine("BacnetMstp: Starting emstp trunk listener " + threadName);
            }
            while (!this.done) {
                try {
                    MstpFrame rxframe = this.rxqueue.takeFirst();
                    if (this.linkListener != null) {
                        this.linkListener.receiveFrame(rxframe.getAddr(), rxframe.getData(), rxframe.getDataExpectingReply());
                        continue;
                    }
                    BBacnetMstpPlatformService.log.warning(threadName + ": No link layer listening");
                }
                catch (InterruptedException ie) {
                    this.done = true;
                }
            }
            this.linkListener = null;
            this.rxqueue = null;
            BBacnetMstpPlatformService.log.info(threadName + " Done");
        }
    }
}

