/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

import com.tridium.platCcn.CcnDataWrapper;

public class CcnUnsolicitedMsg
implements CcnDataWrapper {
    private boolean wait;
    private long timestamp;
    private long dwIdleTime;
    private byte destAddr;
    private byte destBus;
    private byte srcAddr;
    private byte srcBus;
    private byte pid;
    private byte extension;
    private byte command;
    private byte[] data;
    private short dataLength;

    public CcnUnsolicitedMsg(byte newDestAddr, byte newDestBus, byte newSrcAddr, byte newSrcBus, byte newPid, byte newExt, byte newCmd, byte[] newData, short newDataLength) {
        this.destAddr = newDestAddr;
        this.destBus = newDestBus;
        this.srcAddr = newSrcAddr;
        this.srcBus = newSrcBus;
        this.pid = newPid;
        this.extension = newExt;
        this.command = newCmd;
        this.data = newData;
        this.dataLength = newDataLength;
    }

    public void setParams(byte newDestAddr, byte newDestBus, byte newSrcAddr, byte newSrcBus, byte newPid, byte newExt, byte newCmd, byte[] newData, short newDataLength) {
        this.destAddr = newDestAddr;
        this.destBus = newDestBus;
        this.srcAddr = newSrcAddr;
        this.srcBus = newSrcBus;
        this.pid = newPid;
        this.extension = newExt;
        this.command = newCmd;
        this.data = newData;
        this.dataLength = newDataLength;
    }

    public int getDestAddr() {
        return this.destAddr & 0xFF;
    }

    public int getDestBus() {
        return this.destBus & 0xFF;
    }

    public int getSrcAddr() {
        return this.srcAddr & 0xFF;
    }

    public int getSrcBus() {
        return this.srcBus & 0xFF;
    }

    public int getCommand() {
        return this.command & 0xFF;
    }

    public byte[] getDataCopy() {
        byte[] dataCopy = new byte[this.dataLength];
        System.arraycopy(this.data, 0, dataCopy, 0, this.dataLength);
        return dataCopy;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    private static String get2DigHexString(int val) {
        String hex = "00" + Integer.toHexString(val);
        return hex.substring(hex.length() - 2);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        ret.append("wt=").append(this.wait).append(",");
        ret.append("tm=").append(this.timestamp).append(",");
        ret.append("idleTm=").append(this.dwIdleTime).append(",");
        ret.append("dAddr=").append(this.destAddr & 0xFF).append(",");
        ret.append("dBus=").append(this.destBus & 0xFF).append(",");
        ret.append("sAddr=").append(this.srcAddr & 0xFF).append(",");
        ret.append("sBus=").append(this.srcBus & 0xFF).append(",");
        ret.append("pid=").append(this.pid & 0xFF).append(",");
        ret.append("ext=").append(this.extension & 0xFF).append(",");
        ret.append("cmd=0x").append(CcnUnsolicitedMsg.get2DigHexString(this.command & 0xFF)).append(",");
        ret.append("dataLen=").append(this.dataLength & 0xFFFF).append(",");
        ret.append("dataAsc=").append(new String(this.data)).append(",");
        ret.append("dataHex={");
        for (int i = 0; i < this.dataLength; ++i) {
            ret.append(CcnUnsolicitedMsg.get2DigHexString(this.data[i] & 0xFF));
            if (i >= this.dataLength - 1) continue;
            ret.append(" ");
        }
        ret.append("}");
        ret.append("]");
        return ret.toString();
    }
}

