/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

import com.tridium.platCcn.CcnDefSettablePid;

public class CcnTableDef
implements CcnDefSettablePid {
    private final byte address;
    private final byte bus;
    private byte[] name;
    private final short type;
    private final byte instance;
    private final byte blockNumber;
    private final byte blockSize;
    private byte pid;

    public CcnTableDef(byte newAddress, byte newBus, byte[] newName, short newType, byte newInstance, byte newBlockNumber, byte newBlockSize, byte newPid) {
        this.address = newAddress;
        this.bus = newBus;
        int MAX_NAME_SIZE = 8;
        this.name = new byte[8];
        for (int zeroPad = 0; zeroPad < 8; ++zeroPad) {
            this.name[zeroPad] = 0;
        }
        if (newName != null) {
            int newNameLength = Math.min(newName.length, 8);
            System.arraycopy(newName, 0, this.name, 0, newNameLength);
        }
        this.type = newType;
        this.instance = newInstance;
        this.blockNumber = newBlockNumber;
        this.blockSize = newBlockSize;
        this.pid = newPid;
    }

    @Override
    public void setPid(byte newPid) {
        this.pid = newPid;
    }

    public byte getAddress() {
        return this.address;
    }

    public byte getBus() {
        return this.bus;
    }

    public byte[] getName() {
        return this.name;
    }

    public short getType() {
        return this.type;
    }

    public byte getInstance() {
        return this.instance;
    }

    public byte getBlockNumber() {
        return this.blockNumber;
    }

    public byte getBlockSize() {
        return this.blockSize;
    }

    public byte getPid() {
        return this.pid;
    }

    public void setName(byte[] newName) {
        this.name = newName;
    }

    private static String get4DigHexString(int val) {
        String hex = "0000" + Integer.toHexString(val);
        return hex.substring(hex.length() - 4);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        ret.append("addr=").append(this.address & 0xFF).append(",");
        ret.append("bus=").append(this.bus & 0xFF).append(",");
        ret.append("type=0x").append(CcnTableDef.get4DigHexString(this.type & 0xFFFF)).append(",");
        ret.append("inst=").append(this.instance & 0xFF).append(",");
        ret.append("bkNo=").append(this.blockNumber & 0xFF).append(",");
        ret.append("bkSz=").append(this.blockSize & 0xFF);
        ret.append("]");
        return ret.toString();
    }
}

