/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

import com.tridium.platCcn.CcnDefSettablePid;

public class CcnObjectDef
implements CcnDefSettablePid {
    private final byte address;
    private final byte bus;
    private byte[] name;
    private final short objectClass;
    private final byte paramNumber;
    private final byte paramClass;
    private final byte blockNumber;
    private final byte dataSize;
    private byte pid;

    public CcnObjectDef(byte newAddress, byte newBus, byte[] newName, short newObjectClass, byte newParamNumber, byte newParamClass, byte newBlockNumber, byte newDataSize) {
        this.address = newAddress;
        this.bus = newBus;
        int MAX_NAME_SIZE = 8;
        this.name = new byte[8];
        if (newName != null) {
            int newNameLength = Math.min(newName.length, 8);
            System.arraycopy(newName, 0, this.name, 0, newNameLength);
        }
        this.objectClass = newObjectClass;
        this.paramNumber = newParamNumber;
        this.paramClass = newParamClass;
        this.blockNumber = newBlockNumber;
        this.dataSize = newDataSize;
    }

    @Override
    public void setPid(byte newPid) {
        this.pid = newPid;
    }

    public byte getAddress() {
        return this.address;
    }

    public byte getBus() {
        return this.bus;
    }

    public byte[] getName() {
        return this.name;
    }

    public short getObjectClass() {
        return this.objectClass;
    }

    public byte getParamNumber() {
        return this.paramNumber;
    }

    public byte getParamClass() {
        return this.paramClass;
    }

    public byte getBlockNumber() {
        return this.blockNumber;
    }

    public byte getDataSize() {
        return this.dataSize;
    }

    public byte getPid() {
        return this.pid;
    }

    public void setName(byte[] newName) {
        this.name = newName;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        ret.append("addr=").append(this.address & 0xFF).append(",");
        ret.append("bus=").append(this.bus & 0xFF).append(",");
        ret.append("objCls=").append(this.objectClass & 0xFFFF).append(",");
        ret.append("parNo=").append(this.paramNumber & 0xFF).append(",");
        ret.append("parCls=").append(this.paramClass & 0xFF).append(",");
        ret.append("blkNo=").append(this.blockNumber & 0xFF).append(",");
        ret.append("dataSz=").append(this.dataSize & 0xFF);
        ret.append("]");
        return ret.toString();
    }
}

