/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platCcn.BCcnLinkParameters;
import com.tridium.platCcn.CcnCommProps;
import com.tridium.platCcn.CcnObjectDef;
import com.tridium.platCcn.CcnResponseBuffer;
import com.tridium.platCcn.CcnTableDef;
import com.tridium.platCcn.CcnUnsolMsgListener;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import com.tridium.platCcn.CcnVariableDef;
import com.tridium.platSerial.BSerialPort;
import com.tridium.platSerial.BSerialPortPlatformService;
import com.tridium.platform.BPlatformService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="testCommDriver", parameterType="BCcnLinkParameters", defaultValue="new BCcnLinkParameters()", flags=20)
public abstract class BCcnPlatformService
extends BPlatformService {
    @Generated
    public static final Action testCommDriver = BCcnPlatformService.newAction((int)20, (BValue)new BCcnLinkParameters(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnPlatformService.class);
    private static final BIcon icon = BIcon.std((String)"connections.png");
    protected static final Logger log = Logger.getLogger("plat.ccn");
    private CcnUnsolMsgListener listener;
    protected volatile boolean commOpened = false;
    private static final String STATION_PREFIX = "station:";
    private static BSerialPortPlatformService serialPortPlatformService = null;
    HashMap<Integer, String> handleToName = new HashMap();
    private static final String CCN_TRUNK_PREFIX = "/dev/ccn";

    @Generated
    public void testCommDriver(BCcnLinkParameters parameter) {
        this.invoke(testCommDriver, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("CcnPlatformService.description"));
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public String getLicenseFeature() {
        return "ccnl";
    }

    public BIcon getIcon() {
        return icon;
    }

    public abstract int openDriverComm(CcnCommProps var1);

    public abstract CcnResponseBuffer changeTableName(CcnTableDef var1);

    public abstract CcnResponseBuffer readTable(CcnTableDef var1);

    public abstract CcnResponseBuffer writeTable(CcnTableDef var1, byte[] var2);

    public abstract CcnResponseBuffer readVariable(CcnVariableDef var1);

    public abstract CcnResponseBuffer writeVariable(CcnVariableDef var1, float var2);

    public abstract CcnResponseBuffer autoVariable(CcnVariableDef var1);

    public abstract CcnResponseBuffer readObjectData(CcnObjectDef var1);

    public abstract CcnResponseBuffer sendByteArray(byte[] var1);

    public abstract int changeExtendedParams(int var1, byte var2, byte var3, short var4, boolean var5, boolean var6);

    public abstract void setLowLevelDebug(boolean var1, int var2);

    public abstract void closeDriver();

    public void registerUnsolMsgListener(CcnUnsolMsgListener newListener) {
        this.listener = newListener;
    }

    public void unsolicitedMessageReceived(CcnUnsolicitedMsg unsolMsg) {
        if (this.listener != null) {
            this.listener.unsolicitedMessageReceived(unsolMsg);
        }
    }

    synchronized void lockSerial(String osPortName) throws PortDeniedException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Attempting to lock " + osPortName + " for owner Ccn");
        }
        if (osPortName == null) {
            throw new NullPointerException("Can not lock null device");
        }
        String lockFileName = BCcnPlatformService.getLockFileName(osPortName);
        if (lockFileName == null) {
            log.severe("Can not lock " + osPortName + ", can not map os name to lock file");
            return;
        }
        String currentOwner = BCcnPlatformService.getLockFileOwner(lockFileName);
        if (!"none".equalsIgnoreCase(currentOwner)) {
            log.severe("Unable to create lock for " + osPortName + " for owner Ccn, already owned by " + currentOwner);
            throw new PortDeniedException("Unable to create lock for " + osPortName + " for owner Ccn, already owned by " + currentOwner);
        }
        try {
            FileOutputStream fos;
            try {
                fos = AccessController.doPrivileged(() -> new FileOutputStream(lockFileName));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            fos.write("station:Ccn".getBytes(StandardCharsets.UTF_8));
            fos.close();
        }
        catch (Exception e) {
            log.severe("Unable to create lock for " + osPortName + " for owner Ccn : " + e);
            throw new PortDeniedException("Unable to create lock for " + osPortName + " for owner Ccn : " + e);
        }
        BCcnPlatformService.setOwner(osPortName, "Ccn");
        if (log.isLoggable(Level.FINE)) {
            log.fine(osPortName + " locked for owner Ccn");
        }
    }

    synchronized void unlockSerial(String osPortName) throws PortDeniedException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Attempting to unlock " + osPortName + " as owner Ccn");
        }
        if (osPortName == null) {
            throw new NullPointerException("Can not unlock null device");
        }
        String lockFileName = BCcnPlatformService.getLockFileName(osPortName);
        if (lockFileName == null) {
            log.severe("Can not unlock " + osPortName + ", can not map lock file");
            return;
        }
        String currentOwner = BCcnPlatformService.getLockFileOwner(lockFileName);
        if (!currentOwner.equalsIgnoreCase("station:Ccn")) {
            throw new PortDeniedException("Unable to unlock " + osPortName + ", Ccn does not have the port lock, owned by " + currentOwner);
        }
        File file = new File(lockFileName);
        boolean result = AccessController.doPrivileged(file::delete);
        if (!result) {
            throw new PortDeniedException("Unable to unlock " + osPortName + ", failed to delete " + lockFileName);
        }
        BCcnPlatformService.setOwner(osPortName, "none");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Successfully released Ccn lock on " + osPortName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLockFileOwner(String lockFileName) {
        FileInputStream fis = null;
        try {
            try {
                fis = AccessController.doPrivileged(() -> new FileInputStream(lockFileName));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            StringBuilder buf = new StringBuilder();
            int c = fis.read();
            while (c != -1) {
                buf.append((char)c);
                c = fis.read();
            }
            fis.close();
            String owner = buf.toString().trim();
            owner = TextUtil.replace((String)owner, (String)"\n", (String)"");
            String string = owner = TextUtil.replace((String)owner, (String)"\r", (String)"");
            return string;
        }
        catch (FileNotFoundException buf) {
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem reading lock file " + lockFileName + " for Ccn defaulting to no ownership", e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return "none";
    }

    private static void setOwner(String osPortName, String owner) {
        String[] portNames;
        if (BCcnPlatformService.getSerialService() == null) {
            log.severe("Could not locate serial port platform service, can not lock serial port for Ccn");
            return;
        }
        for (String portName : portNames = serialPortPlatformService.getPortNames()) {
            BSerialPort serialPort = (BSerialPort)serialPortPlatformService.get(portName);
            if (!serialPort.getOsPortName().equalsIgnoreCase(osPortName)) continue;
            serialPort.setOwner(owner);
            return;
        }
    }

    private static String getLockFileName(String osPortName) {
        if (BCcnPlatformService.getSerialService() == null) {
            log.severe("Could not locate serial port platform service, can not lock serial port for Ccn");
            return null;
        }
        String[] portNames = serialPortPlatformService.getPortNames();
        int index = -1;
        for (String portName : portNames) {
            BSerialPort serialPort = (BSerialPort)serialPortPlatformService.get(portName);
            if (!serialPort.getOsPortName().equalsIgnoreCase(osPortName)) continue;
            index = serialPort.getPortIndex();
        }
        if (index == -1) {
            log.severe("Could not locate serial port index in serial port platform service serial platform service, can not lock serial port for Ccn");
            return null;
        }
        if (PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
            if (osPortName.contains("gprs")) {
                return "/dev/shmem" + File.separatorChar + "sergprs" + index + ".owner";
            }
            return "/dev/shmem" + File.separatorChar + "ser" + index + ".owner";
        }
        return TempDirectoryHolder.TEMP_DIRECTORY + File.separatorChar + "niagara-ser" + index + ".owner";
    }

    private static BSerialPortPlatformService getSerialService() {
        if (serialPortPlatformService == null) {
            try {
                serialPortPlatformService = (BSerialPortPlatformService)Sys.getService((Type)BSerialPortPlatformService.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return serialPortPlatformService;
    }

    public void doTestCommDriver(final BCcnLinkParameters portParameters) {
        new Thread("TestCommDriver"){

            @Override
            public void run() {
                BCcnPlatformService.this.doTestCommDriverEntry(portParameters);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestCommDriverEntry(BCcnLinkParameters linkParameters) {
        String osName;
        BISerialService serialService;
        log.info("[TestCommDriver] Start");
        log.info("[TestCommDriver] Testing with parameters");
        log.info("[TestCommDriver]   serialPort:      '" + linkParameters.getSerialPort() + "'");
        log.info("[TestCommDriver]   baudRate:        '" + linkParameters.getBaudRate() + "'");
        log.info("[TestCommDriver]   receiveAddress:  '" + linkParameters.getReceiveAddress() + "'");
        log.info("[TestCommDriver]   receiveBus:      '" + linkParameters.getReceiveBus() + "'");
        log.info("[TestCommDriver]   responseTimeOut: '" + linkParameters.getResponseTimeOut() + "'");
        log.info("[TestCommDriver]   alarmAck:        '" + linkParameters.getAlarmAck() + "'");
        log.info("[TestCommDriver]   bcastAck:        '" + linkParameters.getBcastAck() + "'");
        try {
            serialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            serialService.checkPropertiesLoaded();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "[TestCommDriver] ERROR: Failed to load serial port service, can not test CCN", e);
            return;
        }
        BComponent serialPortComponent = null;
        String serialPortName = linkParameters.getSerialPort();
        boolean lockSucceeded = false;
        try {
            serialPortComponent = (BComponent)((BComponent)serialService).get(serialPortName);
            if (serialPortComponent == null) {
                throw new PortNotFoundException(serialPortName);
            }
            Property p = serialPortComponent.getProperty("owner");
            String owner = serialPortComponent.getString(p);
            if (owner == null) {
                serialPortComponent.setString(p, "CcnTest");
            } else if (owner.length() == 0 || owner.equals("none")) {
                serialPortComponent.setString(p, "CcnTest");
            } else {
                throw new PortDeniedException(serialPortName + " is already owned by " + owner);
            }
            lockSucceeded = true;
            Property osPortNameProp = serialPortComponent.getProperty("osPortName");
            osName = serialPortComponent.getString(osPortNameProp);
            if (osName == null || osName.trim().length() == 0) {
                throw new PortDeniedException(serialPortName + " has invalid os name " + osName);
            }
        }
        catch (Exception e) {
            try {
                if (lockSucceeded) {
                    Property p = serialPortComponent.getProperty("owner");
                    serialPortComponent.setString(p, "none");
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            log.log(Level.SEVERE, "[TestCommDriver] ERROR: Failed to resolve serial port " + serialPortName + " to OS name, can not test CCN", e);
            return;
        }
        byte[] TOO_LARGE_BYTES = new byte[16384];
        try {
            CcnCommProps ccnCommProps = new CcnCommProps(linkParameters.getSerialPort(), linkParameters.getBaudRate().getOrdinal(), (byte)linkParameters.getReceiveAddress(), (byte)linkParameters.getReceiveBus(), (short)linkParameters.getResponseTimeOut().getMillis(), linkParameters.getAlarmAck(), linkParameters.getBcastAck());
            log.info("[TestCommDriver] Trying openDriverComm(null);");
            try {
                this.openDriverComm(null);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            String originalSerialPortName = ccnCommProps.getCommPortName();
            log.info("[TestCommDriver] Trying openDriverComm(new CcnCommProperties(null));");
            ccnCommProps.setCommPortName(null);
            try {
                this.openDriverComm(ccnCommProps);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ccnCommProps.setCommPortName(originalSerialPortName);
            this.commOpened = true;
            log.info("[TestCommDriver] Trying changeTableName(null);");
            try {
                this.changeTableName(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying changeTableName(new CcnTableDef());");
            CcnTableDef ccnTableDef = new CcnTableDef(0, 0, null, 0, 0, 0, 0, 0);
            try {
                this.changeTableName(ccnTableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying changeTableName(new CcnTableDef(null));");
            ccnTableDef.setName(null);
            try {
                this.changeTableName(ccnTableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying changeTableName(new CcnTableDef(TOO_LARGE_BYTES));");
            ccnTableDef.setName(TOO_LARGE_BYTES);
            try {
                this.changeTableName(ccnTableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readTable(null);");
            try {
                this.readTable(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readTable(new CcnTableDef());");
            ccnTableDef = new CcnTableDef(0, 0, null, 0, 0, 0, 0, 0);
            try {
                this.readTable(ccnTableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readTable(new CcnTableDef(null));");
            ccnTableDef.setName(null);
            try {
                this.readTable(ccnTableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readTable(new CcnTableDef(TOO_LARGE_BYTES));");
            ccnTableDef.setName(TOO_LARGE_BYTES);
            try {
                this.readTable(ccnTableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying writeTable(null, new byte[0]);");
            try {
                this.writeTable(null, new byte[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying writeTable(new CcnTableDef(), new byte[0]);");
            ccnTableDef = new CcnTableDef(0, 0, null, 0, 0, 0, 0, 0);
            try {
                this.writeTable(ccnTableDef, new byte[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying writeTable(new CcnTableDef(null), new byte[0]);");
            ccnTableDef.setName(null);
            try {
                this.writeTable(ccnTableDef, new byte[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying writeTable(new CcnTableDef(TOO_LARGE_BYTES), new byte[0]);");
            ccnTableDef.setName(TOO_LARGE_BYTES);
            try {
                this.writeTable(ccnTableDef, new byte[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying writeTable(new CcnTableDef(new byte[0]), null);");
            try {
                this.writeTable(new CcnTableDef(0, 0, new byte[0], 0, 0, 0, 0, 0), null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readVariable(null);");
            try {
                this.readVariable(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readVariable(new CcnVariableDef());");
            CcnVariableDef ccnVariableDef = new CcnVariableDef(0, 0, null, 0, 0, 0);
            try {
                this.readVariable(ccnVariableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readVariable(new CcnVariableDef(null));");
            ccnVariableDef.setName(null);
            try {
                this.readVariable(ccnVariableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readVariable(new CcnVariableDef(TOO_LARGE_BYTES));");
            ccnVariableDef.setName(TOO_LARGE_BYTES);
            try {
                this.readVariable(ccnVariableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying writeVariable(null, 0.0f);");
            try {
                this.writeVariable(null, 0.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying writeVariable(new CcnVariableDef(), 0.0f);");
            ccnVariableDef = new CcnVariableDef(0, 0, null, 0, 0, 0);
            try {
                this.writeVariable(ccnVariableDef, 0.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying writeVariable(new CcnVariableDef(null), 0.0f);");
            ccnVariableDef.setName(null);
            try {
                this.writeVariable(ccnVariableDef, 0.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying writeVariable(new CcnVariableDef(TOO_LARGE_BYTES), 0.0f);");
            ccnVariableDef.setName(TOO_LARGE_BYTES);
            try {
                this.writeVariable(ccnVariableDef, 0.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying autoVariable(null);");
            try {
                this.autoVariable(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying autoVariable(new CcnVariableDef());");
            ccnVariableDef = new CcnVariableDef(0, 0, null, 0, 0, 0);
            try {
                this.autoVariable(ccnVariableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying autoVariable(new CcnVariableDef(null));");
            ccnVariableDef.setName(null);
            try {
                this.autoVariable(ccnVariableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying autoVariable(new CcnVariableDef(TOO_LARGE_BYTES));");
            ccnVariableDef.setName(TOO_LARGE_BYTES);
            try {
                this.autoVariable(ccnVariableDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readObjectData(null);");
            try {
                this.readObjectData(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readObjectData(new CcnObjectDef());");
            CcnObjectDef ccnObjectDef = new CcnObjectDef(0, 0, null, 0, 0, 0, 0, 0);
            try {
                this.readObjectData(ccnObjectDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readObjectData(new CcnObjectDef(null));");
            ccnObjectDef.setName(null);
            try {
                this.readObjectData(ccnObjectDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying readObjectData(new CcnObjectDef(TOO_LARGE_BYTES));");
            ccnObjectDef.setName(TOO_LARGE_BYTES);
            try {
                this.readObjectData(ccnObjectDef);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying sendByteArray(null);");
            try {
                this.sendByteArray(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying sendByteArray(new byte[0]);");
            try {
                this.sendByteArray(new byte[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying sendByteArray(TOO_LARGE_BYTES);");
            try {
                this.sendByteArray(TOO_LARGE_BYTES);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.info("[TestCommDriver] Link checks passed");
            this.commOpened = false;
            int handle = -1;
            try {
                log.info("[TestCommDriver] Starting the CCN driver on [ trunk = /dev/ccn1 | device = " + osName + " | baud = " + ccnCommProps.getBaudRate() + " | receiveAddress = " + ccnCommProps.getReceiveAddress() + " | receiveBus = " + ccnCommProps.getReceiveBus() + " | responseTimeout = " + ccnCommProps.getResponseTimeout() + " | alarmAck = " + ccnCommProps.getAlarmAck() + " | broadcastAck = " + ccnCommProps.getBcastAck() + " ]");
                handle = this.openDriverComm(ccnCommProps);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "[TestCommDriver] ERROR: Failed to open the CCN port, can not test CCN", e);
                try {
                    Property p = serialPortComponent.getProperty("owner");
                    serialPortComponent.setString(p, "none");
                }
                catch (Exception p) {
                    // empty catch block
                }
                this.commOpened = false;
                log.info("[TestCommDriver] End");
                return;
            }
            log.info("[TestCommDriver] Opened the CCN driver, handle = " + handle);
            log.info("[TestCommDriver] Trying changeTableName(new CcnTableDef(\"TABLE\"));");
            ccnTableDef = new CcnTableDef(1, 2, new byte[]{84, 65, 66, 76, 69, 0}, 3, 4, 5, 6, 7);
            CcnResponseBuffer responseBuffer = this.changeTableName(ccnTableDef);
            log.info("[TestCommDriver] Got response: " + responseBuffer);
            log.info("[TestCommDriver] Trying readTable(new CcnTableDef(\"TABLE\"));");
            ccnTableDef = new CcnTableDef(1, 2, new byte[]{84, 65, 66, 76, 69, 0}, 3, 4, 5, 6, 7);
            responseBuffer = this.readTable(ccnTableDef);
            log.info("[TestCommDriver] Got response: " + responseBuffer);
            log.info("[TestCommDriver] Trying writeTable(new CcnTableDef(\"TABLE\"), new byte[32]);");
            ccnTableDef = new CcnTableDef(1, 2, new byte[]{84, 65, 66, 76, 69, 0}, 3, 4, 5, 6, 7);
            responseBuffer = this.writeTable(ccnTableDef, new byte[32]);
            log.info("[TestCommDriver] Got response: " + responseBuffer);
            log.info("[TestCommDriver] Trying readVariable(new CcnVariableDef(\"VAR\"));");
            ccnVariableDef = new CcnVariableDef(1, 2, new byte[]{86, 65, 82, 0}, 3, 4, 5);
            responseBuffer = this.readVariable(ccnVariableDef);
            log.info("[TestCommDriver] Got response: " + responseBuffer);
            log.info("[TestCommDriver] Trying writeVariable(new CcnVariableDef(\"VAR\"), 1.0f);");
            ccnVariableDef = new CcnVariableDef(1, 2, new byte[]{86, 65, 82, 0}, 3, 4, 5);
            responseBuffer = this.writeVariable(ccnVariableDef, 1.0f);
            log.info("[TestCommDriver] Got response: " + responseBuffer);
            log.info("[TestCommDriver] Trying autoVariable(new CcnVariableDef(\"VAR\"));");
            ccnVariableDef = new CcnVariableDef(1, 2, new byte[]{86, 65, 82, 0}, 3, 4, 5);
            responseBuffer = this.autoVariable(ccnVariableDef);
            log.info("[TestCommDriver] Got response: " + responseBuffer);
            log.info("[TestCommDriver] Trying readObjectData(new CcnObjectDef(\"OBJECT\"));");
            ccnObjectDef = new CcnObjectDef(1, 2, new byte[]{79, 66, 74, 69, 67, 84, 0}, 3, 4, 5, 6, 7);
            responseBuffer = this.readObjectData(ccnObjectDef);
            log.info("[TestCommDriver] Got response: " + responseBuffer);
            log.info("[TestCommDriver] Trying sendByteArray(new byte[32]);");
            responseBuffer = this.sendByteArray(new byte[32]);
            log.info("[TestCommDriver] Got response: " + responseBuffer);
            log.info("[TestCommDriver] Trying changeExtendedParams(!new CcnCommProps()");
            int response = this.changeExtendedParams(linkParameters.getBaudRate() == BSerialBaudRate.baud9600 ? BSerialBaudRate.baud19200.getOrdinal() : BSerialBaudRate.baud9600.getOrdinal(), (byte)(ccnCommProps.getReceiveAddress() + 1), (byte)(ccnCommProps.getReceiveBus() + 1), (short)(ccnCommProps.getResponseTimeout() + 100), !ccnCommProps.getAlarmAck(), !ccnCommProps.getBcastAck());
            log.info("[TestCommDriver] Got response: " + response);
            log.info("[TestCommDriver] Trying changeExtendedParams(new CcnCommProps()");
            response = this.changeExtendedParams((int)ccnCommProps.getBaudRate(), ccnCommProps.getReceiveAddress(), ccnCommProps.getReceiveBus(), ccnCommProps.getResponseTimeout(), ccnCommProps.getAlarmAck(), ccnCommProps.getBcastAck());
            log.info("[TestCommDriver] Got response: " + response);
            log.info("[TestCommDriver] Trying setLowLevelDebug(true, 0)");
            this.setLowLevelDebug(true, 1);
            log.info("[TestCommDriver] Trying setLowLevelDebug(false, 0)");
            this.setLowLevelDebug(false, 0);
            try {
                log.info("[TestCommDriver] Stopping the CCN driver on [ trunk = /dev/ccn1 | device = " + osName + " ]");
                this.closeDriver();
                handle = -1;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "[TestCommDriver] ERROR: Failed to close the CCN port", e);
                try {
                    Property p = serialPortComponent.getProperty("owner");
                    serialPortComponent.setString(p, "none");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.commOpened = false;
                log.info("[TestCommDriver] End");
                return;
            }
            log.info("[TestCommDriver] Driver closed");
        }
        finally {
            try {
                Property p = serialPortComponent.getProperty("owner");
                serialPortComponent.setString(p, "none");
            }
            catch (Exception exception) {}
            this.commOpened = false;
            log.info("[TestCommDriver] End");
        }
    }

    private static final class TempDirectoryHolder {
        private static final String TEMP_DIRECTORY = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getTempDirPath());

        private TempDirectoryHolder() {
        }
    }
}

