/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.point;

import com.tridium.opc.OpcEnv;
import com.tridium.opc.client.BOpcDaClient;
import com.tridium.opc.client.BOpcDevice;
import com.tridium.opc.client.BOpcNetwork;
import com.tridium.opc.client.point.BOpcPointDeviceExt;
import com.tridium.opc.client.point.BOpcPointFolder;
import com.tridium.opc.client.util.BIOpcPollable;
import com.tridium.opc.client.util.BOpcDataType;
import com.tridium.opc.client.util.BOpcLimit;
import com.tridium.opc.client.util.BOpcQuality;
import com.tridium.opc.client.util.BOpcQualityBad;
import com.tridium.opc.client.util.BOpcQualityGood;
import com.tridium.opc.client.util.BOpcQualityUncertain;
import com.tridium.opc.client.util.BOpcQualityUnknown;
import com.tridium.opc.client.util.BOpcReadMode;
import com.tridium.opc.client.util.BOpcTuningPolicy;
import com.tridium.opc.jni.client.da.OpcItemMgt;
import com.tridium.opc.jni.client.da.OpcSyncIo;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="String", defaultValue=""), @NiagaraProperty(name="opcDataType", type="BOpcDataType", defaultValue="BOpcDataType.vtEmpty"), @NiagaraProperty(name="opcReadTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=67), @NiagaraProperty(name="opcQuality", type="BOpcQuality", defaultValue="BOpcQuality.good", flags=67), @NiagaraProperty(name="opcQualitySubcode", type="BFrozenEnum", defaultValue="BOpcQualityGood.nonSpecific", flags=67), @NiagaraProperty(name="opcLimit", type="BOpcLimit", defaultValue="BOpcLimit.notLimited", flags=67), @NiagaraProperty(name="serverHandle", type="int", defaultValue="0", flags=67), @NiagaraProperty(name="mode", type="BReadWriteMode", defaultValue="BReadWriteMode.readWrite", flags=65), @NiagaraProperty(name="opcActualDataType", type="BOpcDataType", defaultValue="BOpcDataType.vtEmpty")})
@NiagaraActions(value={@NiagaraAction(name="read"), @NiagaraAction(name="forceWrite")})
public class BOpcProxyExt
extends BProxyExt
implements BIOpcPollable {
    @Generated
    public static final Property id = BOpcProxyExt.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property opcDataType = BOpcProxyExt.newProperty((int)0, (BValue)BOpcDataType.vtEmpty, null);
    @Generated
    public static final Property opcReadTime = BOpcProxyExt.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property opcQuality = BOpcProxyExt.newProperty((int)67, (BValue)BOpcQuality.good, null);
    @Generated
    public static final Property opcQualitySubcode = BOpcProxyExt.newProperty((int)67, (BValue)BOpcQualityGood.nonSpecific, null);
    @Generated
    public static final Property opcLimit = BOpcProxyExt.newProperty((int)67, (BValue)BOpcLimit.notLimited, null);
    @Generated
    public static final Property serverHandle = BOpcProxyExt.newProperty((int)67, (int)0, null);
    @Generated
    public static final Property mode = BOpcProxyExt.newProperty((int)65, (BValue)BReadWriteMode.readWrite, null);
    @Generated
    public static final Property opcActualDataType = BOpcProxyExt.newProperty((int)0, (BValue)BOpcDataType.vtEmpty, null);
    @Generated
    public static final Action read = BOpcProxyExt.newAction((int)0, null);
    @Generated
    public static final Action forceWrite = BOpcProxyExt.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcProxyExt.class);
    private BOpcDaClient daClient;
    private BOpcPointDeviceExt deviceExt = null;
    private BOpcPointFolder folder = null;
    private boolean subscribed = false;
    private boolean writePending = false;
    private boolean itemIdChanged = false;
    private boolean isWriteInProgress = false;
    private Object syncIsWriteInProgress = new Object();
    private boolean isReadInProgress = false;
    private Object syncIsReadInProgress = new Object();
    private boolean isAddRemoveInProgress = false;
    Log opcLog = Log.getLog((String)"OpcDaLog");
    Log opcWriteLog = Log.getLog((String)"OpcDaWriteLog");

    @Generated
    public String getId() {
        return this.getString(id);
    }

    @Generated
    public void setId(String v) {
        this.setString(id, v, null);
    }

    @Generated
    public BOpcDataType getOpcDataType() {
        return (BOpcDataType)this.get(opcDataType);
    }

    @Generated
    public void setOpcDataType(BOpcDataType v) {
        this.set(opcDataType, (BValue)v, null);
    }

    @Generated
    public BAbsTime getOpcReadTime() {
        return (BAbsTime)this.get(opcReadTime);
    }

    @Generated
    public void setOpcReadTime(BAbsTime v) {
        this.set(opcReadTime, (BValue)v, null);
    }

    @Generated
    public BOpcQuality getOpcQuality() {
        return (BOpcQuality)this.get(opcQuality);
    }

    @Generated
    public void setOpcQuality(BOpcQuality v) {
        this.set(opcQuality, (BValue)v, null);
    }

    @Generated
    public BFrozenEnum getOpcQualitySubcode() {
        return (BFrozenEnum)this.get(opcQualitySubcode);
    }

    @Generated
    public void setOpcQualitySubcode(BFrozenEnum v) {
        this.set(opcQualitySubcode, (BValue)v, null);
    }

    @Generated
    public BOpcLimit getOpcLimit() {
        return (BOpcLimit)this.get(opcLimit);
    }

    @Generated
    public void setOpcLimit(BOpcLimit v) {
        this.set(opcLimit, (BValue)v, null);
    }

    @Generated
    public int getServerHandle() {
        return this.getInt(serverHandle);
    }

    @Generated
    public void setServerHandle(int v) {
        this.setInt(serverHandle, v, null);
    }

    @Generated
    public BReadWriteMode getMode() {
        return (BReadWriteMode)this.get(mode);
    }

    @Generated
    public void setMode(BReadWriteMode v) {
        this.set(mode, (BValue)v, null);
    }

    @Generated
    public BOpcDataType getOpcActualDataType() {
        return (BOpcDataType)this.get(opcActualDataType);
    }

    @Generated
    public void setOpcActualDataType(BOpcDataType v) {
        this.set(opcActualDataType, (BValue)v, null);
    }

    @Generated
    public void read() {
        this.invoke(read, null, null);
    }

    @Generated
    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void changed(Property p, Context c) {
        super.changed(p, c);
        if (c != Context.decoding && this.subscribed && this.isRunning()) {
            BOpcDaClient server;
            if (p == id) {
                this.itemIdChanged = true;
                this.readUnsubscribed(c);
                this.readSubscribed(c);
            }
            if ((server = this.getDaClient()).isDown() || server.isDisabled()) {
                this.readUnsubscribed(null);
            }
        }
    }

    public void doRead() {
        if (!this.isRunning()) {
            return;
        }
        this.getOpcPointDeviceExt().read(this);
    }

    public final Type getDeviceExtType() {
        return BOpcPointDeviceExt.TYPE;
    }

    public final BOpcPointFolder getFolder() {
        if (this.folder == null) {
            for (BComplex cur = this.getParent(); cur != null; cur = cur.getParent()) {
                if (!(cur instanceof BOpcPointFolder)) continue;
                this.folder = (BOpcPointFolder)cur;
                break;
            }
        }
        return this.folder;
    }

    public final BOpcDevice getOpcDevice() {
        return (BOpcDevice)this.getDevice();
    }

    public final BOpcDaClient getDaClient() {
        if (this.daClient == null) {
            this.daClient = (BOpcDaClient)this.getDevice();
        }
        return this.daClient;
    }

    public final BOpcPointDeviceExt getOpcPointDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BOpcPointDeviceExt)this.getDeviceExt();
        }
        return this.deviceExt;
    }

    public final BOpcNetwork getOpcNetwork() {
        return this.getOpcDevice().getOpcNetwork();
    }

    public BPollFrequency getPollFrequency() {
        return ((BOpcTuningPolicy)this.getTuningPolicy()).getPollFrequency();
    }

    public final boolean isReadSubscribed() {
        return this.subscribed;
    }

    @Override
    public void poll() {
        if (BOpcReadMode.cov != this.getOpcPointDeviceExt().getReadMode()) {
            this.read();
        }
    }

    public final IFuture post(Action a, BValue arg, Context cx) {
        this.getOpcNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readSubscribed(Context cx) {
        BOpcProxyExt bOpcProxyExt = this;
        synchronized (bOpcProxyExt) {
            if (this.subscribed) {
                return;
            }
            this.subscribed = true;
        }
        this.getOpcPointDeviceExt().subscribe(this, cx);
        this.writeReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readUnsubscribed(Context cx) {
        BOpcProxyExt bOpcProxyExt = this;
        synchronized (bOpcProxyExt) {
            if (!this.subscribed) {
                return;
            }
            this.setSubscribed(false);
            this.getOpcDevice().getPollScheduler().unsubscribe(this);
            BOpcDaClient server = this.getDaClient();
            if (server.isDown() || server.isDisabled() || server.getState().isDisengaged()) {
                this.setServerHandle(0);
                this.setOpcQuality(BOpcQuality.bad);
                this.setOpcQualitySubcode(BOpcQualityBad.nonSpecific);
            } else {
                this.getOpcPointDeviceExt().unsubscribe(this, cx);
            }
            this.writeReset();
        }
    }

    public final void setStale(boolean stale, Context cx) {
        super.setStale(stale, cx);
        if (stale && this.subscribed) {
            if (this.getServerHandle() == 0) {
                this.readUnsubscribed(cx);
                this.readSubscribed(cx);
            } else {
                this.read();
            }
        }
    }

    public final void started() throws Exception {
        if (this.isWritablePoint()) {
            this.setMode(BReadWriteMode.readWrite);
        } else {
            this.setMode(BReadWriteMode.readonly);
        }
        BOpcPointDeviceExt ext = this.getOpcPointDeviceExt();
        ext.add(this);
    }

    public final void stopped() throws Exception {
        this.readUnsubscribed(null);
        this.deviceExt = null;
        this.folder = null;
        super.stopped();
    }

    public boolean write(Context cx) {
        this.opcWriteLog.trace("BOpcProxyExt.write Entered with point::" + this.getId());
        BStatusValue val = this.getWriteValue();
        if (val.getStatus().isNull()) {
            this.opcWriteLog.trace("BOpcProxyExt.write Status is null for::" + this.getId());
            return false;
        }
        this.writePending = true;
        if (!this.subscribed) {
            this.opcWriteLog.trace("Proxy::Write,point not subscribed.Calling read subscribed::" + this.getId());
            this.readSubscribed(null);
        } else if (this.getServerHandle() == 0) {
            this.opcWriteLog.trace("BOpcProxyExt.write server handle is zero for::" + this.getId());
            this.writeReset();
            if (!this.subscribed) {
                this.readSubscribed(null);
            }
        } else {
            this.opcWriteLog.trace("Proxy::Write,point subscribed.adding to pendingWriteMap::" + this.getId());
            this.getOpcPointDeviceExt().write(this, cx);
        }
        this.opcWriteLog.trace("BOpcProxyExt.write Exited with point::" + this.getId());
        return true;
    }

    public void writablePointActionInvoked() {
        super.writablePointActionInvoked();
        this.getParentPoint().execute();
    }

    public void doForceWrite() {
        this.write(null);
    }

    protected void addResult(BOpcPointDeviceExt ext, OpcItemMgt.ItemResult res) {
        this.opcLog.trace("Proxy::addResult. Point " + this.getId() + " with server handle at beginning:" + this.getServerHandle());
        BOpcDaClient server = this.getDaClient();
        server.getPollScheduler().unsubscribe(this);
        String msg = "";
        this.setIsAddRemoveInProgress(false);
        if (res == null) {
            this.setServerHandle(0);
            this.setOpcQuality(BOpcQuality.bad);
            this.setOpcQualitySubcode(BOpcQualityBad.nonSpecific);
            msg = "Add item, no result";
            this.readFail(msg);
            if (!this.isRunning() || this.isDisabled() || this.isDown()) {
                ext.unsubscribe(this, null);
                this.opcLog.trace("Proxy::Additem, no result.Point " + this.getId() + " is unsubscribed");
                return;
            }
            ext.subscribe(this, null);
            this.opcLog.trace("Proxy::Additem, no result. Subscribing " + this.getId() + " again for adding in next trail ");
            return;
        }
        this.opcLog.trace("Proxy::addResult. Point " + this.getId() + " with hresult:" + res.hresult + " and new server handle" + res.serverHandle);
        if (OpcEnv.failed(res.hresult)) {
            msg = OpcEnv.resultString(res.hresult);
            this.readFail(msg);
            if (this.isRunning() && !this.isDisabled() && !this.isDown()) {
                ext.subscribe(this, null);
                this.opcLog.trace("Proxy::Additem failed with hresult::" + Integer.toHexString(res.hresult) + ". Putting the Point subscribe list for next trial " + this.getId());
            } else {
                return;
            }
        }
        this.opcLog.trace("Proxy::Add item succeeded::" + res.hresult + " for item " + this.getId() + ", Name::" + this.getName());
        this.setServerHandle(res.serverHandle);
        ext.addToServerHandleMap(this);
        ext.add(this);
        boolean r = OpcEnv.isReadable(res.access);
        boolean w = OpcEnv.isWritable(res.access);
        if (r && w) {
            if (this.isWritablePoint() && this.getMode() != BReadWriteMode.readWrite) {
                this.setMode(BReadWriteMode.readWrite);
            }
        } else if (w) {
            if (this.isWritablePoint() && this.getMode() != BReadWriteMode.writeonly) {
                this.setMode(BReadWriteMode.writeonly);
            }
        } else if (this.getMode() != BReadWriteMode.readonly) {
            this.setMode(BReadWriteMode.readonly);
        }
        try {
            this.setOpcDataType(BOpcDataType.make(res.dataType));
            this.setOpcActualDataType(BOpcDataType.make(res.actualdataType));
        }
        catch (Exception x) {
            this.opcLog.error("Unexpected datatype: " + res.dataType);
        }
        if (ext.getReadMode() != BOpcReadMode.cov) {
            server.getPollScheduler().subscribe(this);
        }
        if (this.writePending) {
            this.write(null);
        }
    }

    protected boolean isValidItem() {
        if (!this.isRunning()) {
            return false;
        }
        if (this.isDown() || this.isDisabled()) {
            this.opcWriteLog.error("Proxy::IsValidItem, UnOperationl. Returning from write operation::" + this.getId());
            return false;
        }
        if (this.getServerHandle() == 0) {
            this.getOpcPointDeviceExt().write(this, null);
            this.opcWriteLog.error("Proxy::IsValidItem, Serverhandle is 0. Returning from write operation::" + this.getId());
            return false;
        }
        this.writePending = false;
        BStatusValue val = this.getWriteValue();
        if (val.getStatus().isNull()) {
            this.writePending = true;
            this.writeOk(val);
            this.opcWriteLog.trace("Proxy::IsValidItem, value.getStatus =Null, WriteOK called, Returning.." + this.getId());
            return false;
        }
        return true;
    }

    protected boolean isNumericOutofRange(BStatusValue val) {
        double d = ((BStatusNumeric)val).getNumeric();
        BNumber bn = (BNumber)this.getDeviceFacets().get("min");
        if (bn != null && bn.getDouble() > d) {
            this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
            this.opcWriteLog.message("Proxy::isOutofRange, Write failed as value out of range::" + this.getId());
            return true;
        }
        bn = (BNumber)this.getDeviceFacets().get("max");
        if (bn != null && bn.getDouble() < d) {
            this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
            this.opcWriteLog.message("Proxy::isOutofRange, Write failed as value out of range::" + this.getId());
            return true;
        }
        BControlPoint cp = (BControlPoint)this.getParent();
        bn = (BNumber)cp.getFacets().get("min");
        if (bn != null && bn.getDouble() > d) {
            this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
            this.opcWriteLog.message("Proxy::isOutofRange, Write failed as value out of range::" + this.getId());
            return true;
        }
        bn = (BNumber)cp.getFacets().get("max");
        if (bn != null && bn.getDouble() < d) {
            this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
            this.opcWriteLog.message("Proxy::isOutofRange, Write failed as value out of range::" + this.getId());
            return true;
        }
        return false;
    }

    protected boolean isValidDataType(BStatusValue val) {
        int hresult = 0;
        String strTemp = ((BStatusString)val).getValue();
        String[] strArr = TextUtil.split((String)strTemp, (char)',');
        boolean isBool = true;
        if (strArr.length == 0) {
            if (this.getOpcActualDataType().getOrdinal() == 8) {
                return true;
            }
            if (this.getOpcActualDataType().getOrdinal() == 8200) {
                return true;
            }
            hresult = -1073479676;
        } else {
            if (this.getOpcActualDataType().getOrdinal() == 8) {
                return true;
            }
            if (8203 == this.getOpcActualDataType().getOrdinal()) {
                for (int i = 0; i < strArr.length; ++i) {
                    try {
                        strArr[i] = strArr[i].trim();
                        if (strArr[i].length() != 0) continue;
                        hresult = -1073479676;
                        isBool = false;
                        continue;
                    }
                    catch (Exception e) {
                        isBool = false;
                        break;
                    }
                }
                if (isBool) {
                    return true;
                }
                hresult = -1073479676;
            } else {
                if (this.getOpcActualDataType().getOrdinal() == 8200) {
                    return true;
                }
                int intValid = this.validateOpcDataType(val, this.getOpcActualDataType().getOrdinal());
                if (0 == intValid) {
                    return true;
                }
                hresult = 1 == intValid ? -1073479669 : -1073479676;
            }
        }
        if (OpcEnv.failed(hresult)) {
            this.opcWriteLog.error(this.getId() + " write failed 1 [val=" + val.getValueValue() + "] " + OpcEnv.getDescription(hresult));
            this.writeFail(OpcEnv.getDescription(hresult));
        }
        return false;
    }

    protected String getStringArrayValue(BStatusValue val) {
        String strBoolVal = "";
        String strTemp = ((BStatusString)val).getValue();
        String[] strArr = TextUtil.split((String)strTemp, (char)',');
        boolean isBool = true;
        if (8203 == this.getOpcActualDataType().getOrdinal()) {
            for (int i = 0; i < strArr.length; ++i) {
                try {
                    strArr[i] = strArr[i].trim();
                    if (strArr[i].length() == 0) continue;
                    int intTemp = Integer.parseInt(strArr[i]);
                    strBoolVal = intTemp != 0 ? strBoolVal + "true" : strBoolVal + "false";
                    if (i == strArr.length - 1) continue;
                    strBoolVal = strBoolVal + ",";
                    continue;
                }
                catch (Exception e) {
                    isBool = false;
                    break;
                }
            }
            if (isBool) {
                return strBoolVal;
            }
        } else if (this.getOpcActualDataType().getOrdinal() == 8200) {
            return ((BStatusString)val).getValue().trim();
        }
        return strTemp;
    }

    protected void updateWriteResult(int hresult) {
        if (OpcEnv.failed(hresult)) {
            this.opcWriteLog.error(this.getId() + " write failed 2 [val=" + this.getWriteValue().getValueValue() + "] " + OpcEnv.getDescription(hresult));
            this.writeFail(OpcEnv.getDescription(hresult));
        } else {
            this.opcWriteLog.trace(this.getId() + " write success [val=" + this.getWriteValue().getValueValue() + "] " + OpcEnv.getDescription(hresult));
            this.writeOk(this.getWriteValue());
            if (this.getParentPoint().isSubscribed()) {
                this.read();
            }
        }
    }

    protected void updateReadResult(int hresult) {
        if (OpcEnv.failed(hresult)) {
            this.setIsReadInProgress(false);
            this.readFail(OpcEnv.getDescription(hresult));
            this.opcLog.trace("PointDeviceExt::updateReadResult()-Point::" + this.getId() + " read failed. HRESULT::" + OpcEnv.getDescription(hresult));
        }
    }

    protected void performWrite(OpcSyncIo sio) {
        if (!this.isRunning()) {
            return;
        }
        if (this.isDown() || this.isDisabled() || this.isFatalFault()) {
            this.opcWriteLog.error("Proxy::PerformWrite, UnOperationl. Returning from write operation::" + this.getId());
            return;
        }
        if (this.getServerHandle() == 0) {
            this.getOpcPointDeviceExt().write(this, null);
            this.opcWriteLog.error("Proxy::PerformWrite, Serverhandle is 0. Returning from write operation::" + this.getId());
            return;
        }
        this.writePending = false;
        BStatusValue val = this.getWriteValue();
        if (val.getStatus().isNull()) {
            this.writePending = true;
            this.writeOk(val);
            this.opcWriteLog.trace("Proxy::PerformWrite, value.getStatus =Null, WriteOK called, Returning.." + this.getId());
            return;
        }
        if (val instanceof BStatusNumeric) {
            double d = ((BStatusNumeric)val).getNumeric();
            BNumber bn = (BNumber)this.getDeviceFacets().get("min");
            if (bn != null && bn.getDouble() > d) {
                this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
                this.opcWriteLog.message("Proxy::PerformWrite, Write failed as value out of range::" + this.getId());
                return;
            }
            bn = (BNumber)this.getDeviceFacets().get("max");
            if (bn != null && bn.getDouble() < d) {
                this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
                this.opcWriteLog.message("Proxy::PerformWrite, Write failed as value out of range::" + this.getId());
                return;
            }
            BControlPoint cp = (BControlPoint)this.getParent();
            bn = (BNumber)cp.getFacets().get("min");
            if (bn != null && bn.getDouble() > d) {
                this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
                this.opcWriteLog.message("Proxy::PerformWrite, Write failed as value out of range::" + this.getId());
                return;
            }
            bn = (BNumber)cp.getFacets().get("max");
            if (bn != null && bn.getDouble() < d) {
                this.writeFail(this.getOpcNetwork().lex("proxyExt.outOfRange"));
                this.opcWriteLog.message("Proxy::PerformWrite, Write failed as value out of range::" + this.getId());
                return;
            }
        }
        try {
            int hresult = 0;
            if (val instanceof BStatusBoolean) {
                hresult = sio.writeBoolean(this.getServerHandle(), ((BStatusBoolean)val).getValue());
            } else if (val instanceof BStatusNumeric) {
                hresult = sio.writeNumeric(this.getServerHandle(), this.getOpcDataType().getOrdinal(), ((BStatusNumeric)val).getValue());
            } else {
                String strBoolVal = "";
                String strTemp = ((BStatusString)val).getValue();
                String[] strArr = TextUtil.split((String)strTemp, (char)',');
                boolean isBool = true;
                if (strArr.length == 0) {
                    hresult = this.getOpcActualDataType().getOrdinal() == 8 ? sio.writeString(this.getServerHandle(), ((BStatusString)val).getValue(), this.getOpcActualDataType().getOrdinal()) : (this.getOpcActualDataType().getOrdinal() == 8200 ? sio.writeString(this.getServerHandle(), ((BStatusString)val).getValue(), this.getOpcActualDataType().getOrdinal()) : -1073479676);
                } else if (this.getOpcActualDataType().getOrdinal() == 8) {
                    hresult = sio.writeString(this.getServerHandle(), ((BStatusString)val).getValue(), this.getOpcActualDataType().getOrdinal());
                } else if (8203 == this.getOpcActualDataType().getOrdinal()) {
                    for (int i = 0; i < strArr.length; ++i) {
                        try {
                            strArr[i] = strArr[i].trim();
                            if (strArr[i].length() == 0) {
                                hresult = -1073479676;
                                isBool = false;
                                continue;
                            }
                            int intTemp = Integer.parseInt(strArr[i]);
                            strBoolVal = intTemp != 0 ? strBoolVal + "true" : strBoolVal + "false";
                            if (i == strArr.length - 1) continue;
                            strBoolVal = strBoolVal + ",";
                            continue;
                        }
                        catch (Exception e) {
                            isBool = false;
                            break;
                        }
                    }
                    if (isBool) {
                        ((BStatusString)val).setValue(strBoolVal);
                        hresult = sio.writeString(this.getServerHandle(), strBoolVal, this.getOpcActualDataType().getOrdinal());
                    } else {
                        hresult = -1073479676;
                    }
                } else if (this.getOpcActualDataType().getOrdinal() == 8200) {
                    ((BStatusString)val).setValue(((BStatusString)val).getValue().trim());
                    hresult = sio.writeString(this.getServerHandle(), ((BStatusString)val).getValue(), this.getOpcActualDataType().getOrdinal());
                } else {
                    int intValid = this.validateOpcDataType(val, this.getOpcActualDataType().getOrdinal());
                    hresult = 0 == intValid ? sio.writeString(this.getServerHandle(), ((BStatusString)val).getValue(), this.getOpcActualDataType().getOrdinal()) : (1 == intValid ? -1073479669 : -1073479676);
                }
            }
            if (OpcEnv.failed(hresult)) {
                this.opcWriteLog.error(this.getId() + " write failed 3 [val=" + val.getValueValue() + "] " + OpcEnv.getDescription(hresult));
                this.writeFail(OpcEnv.getDescription(hresult));
            } else {
                this.opcWriteLog.trace("Proxy::PerformWrite, Write successful::" + this.getId());
                this.writeOk(val);
                if (this.getParentPoint().isSubscribed()) {
                    this.read();
                }
            }
        }
        catch (Exception x) {
            this.opcWriteLog.error("Write fail [val=" + val.getValueValue() + "] " + this.getId(), (Throwable)x);
            this.writeFail(x.getMessage());
        }
    }

    protected void readResult(BStatusValue val, long timestamp, int quality, int hresult) {
        this.setIsReadInProgress(false);
        this.setOpcReadTime(BAbsTime.make((long)timestamp));
        this.setOpcQuality(BOpcQuality.getQuality(quality));
        this.setOpcLimit(BOpcLimit.getLimit(quality));
        if (BOpcQuality.isBad(quality)) {
            BOpcQualityBad q = BOpcQualityBad.getQuality(quality);
            if (val != null) {
                val.setStatus(BStatus.fault);
            }
            this.setOpcQualitySubcode(q);
        } else if (BOpcQuality.isGood(quality)) {
            BOpcQualityGood q = BOpcQualityGood.getQuality(quality);
            if (val != null && q == BOpcQualityGood.localOverride) {
                val.setStatus(BStatus.overridden);
            }
            this.setOpcQualitySubcode(q);
        } else if (BOpcQuality.isUncertain(quality)) {
            this.setOpcQualitySubcode(BOpcQualityUncertain.getQuality(quality));
        } else {
            this.setOpcQualitySubcode(BOpcQualityUnknown.getQuality(quality));
        }
        if (val != null) {
            this.readOk(val);
        } else {
            this.readFail(OpcEnv.resultString(hresult));
            this.opcLog.trace("Proxy::write, Read failed with hresult ::" + hresult + "for Point ::" + this.getId());
        }
    }

    public int validateOpcDataType(BStatusValue val, int DataType) {
        int intValid = 0;
        String strTemp = ((BStatusString)val).getValue();
        String[] strArr = TextUtil.split((String)strTemp, (char)',');
        if (strArr.length != 0) {
            for (int i = 0; i < strArr.length; ++i) {
                block10: {
                    try {
                        if (strArr[i].length() != 0) {
                            double temp = Double.parseDouble(strArr[i]);
                            BStatusNumeric strStatusArr = new BStatusNumeric(temp);
                            double d = strStatusArr.getNumeric();
                            BNumber bn = (BNumber)this.getDeviceFacets().get("min");
                            if (bn != null && bn.getDouble() > d) {
                                return 1;
                            }
                            bn = (BNumber)this.getDeviceFacets().get("max");
                            if (bn != null && bn.getDouble() < d) {
                                return 1;
                            }
                            if (DataType == 8208 ? d > 127.0 || d < -127.0 : (DataType == 8209 ? d > 255.0 || d < 0.0 : (DataType == 8210 ? d > 65535.0 || d < 0.0 : DataType == 8211 && d < 0.0))) {
                                return 1;
                            }
                            break block10;
                        }
                        return 2;
                    }
                    catch (Exception e) {
                        intValid = 2;
                    }
                }
                if (intValid == 0) {
                    continue;
                }
                break;
            }
        } else {
            intValid = 2;
        }
        return intValid;
    }

    public boolean getItemIDChanged() {
        return this.itemIdChanged;
    }

    public void setItemIDChanged(boolean changed) {
        this.itemIdChanged = changed;
    }

    private boolean isWritablePoint() {
        boolean isWritablePoint = false;
        BControlPoint parentPt = this.getParentPoint();
        TypeInfo info = parentPt.getType().getTypeInfo();
        isWritablePoint = info.is(BIWritablePoint.TYPE);
        return isWritablePoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsReadInProgress() {
        Object object = this.syncIsReadInProgress;
        synchronized (object) {
            return this.isReadInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIsReadInProgress(boolean isInProg) {
        Object object = this.syncIsReadInProgress;
        synchronized (object) {
            this.isReadInProgress = isInProg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsWriteInProgress() {
        Object object = this.syncIsWriteInProgress;
        synchronized (object) {
            return this.isWriteInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIsWriteInProgress(boolean isInProg) {
        Object object = this.syncIsWriteInProgress;
        synchronized (object) {
            this.isWriteInProgress = isInProg;
        }
    }

    public synchronized boolean getIsAddRemoveInProgress() {
        return this.isAddRemoveInProgress;
    }

    public synchronized void setIsAddRemoveInProgress(boolean isInProg) {
        this.isAddRemoveInProgress = isInProg;
    }

    public boolean getIsInUse() {
        return this.getIsReadInProgress() || this.getIsWriteInProgress();
    }

    public void setSubscribed(boolean value) {
        this.subscribed = value;
    }

    public void readOk(BStatusValue newValue) {
        super.readOk(newValue);
        if (this.getIsReadInProgress()) {
            this.setIsReadInProgress(false);
        }
    }

    public void readFail(String cause) {
        super.readFail(cause);
        if (this.getIsReadInProgress()) {
            this.setIsReadInProgress(false);
        }
    }

    public void writeOk(BStatusValue writeValue) {
        super.writeOk(writeValue);
        if (this.getIsWriteInProgress()) {
            this.setIsWriteInProgress(false);
        }
    }

    public void writeFail(String cause) {
        super.writeFail(cause);
        if (this.getIsWriteInProgress()) {
            this.setIsWriteInProgress(false);
        }
    }
}

